/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.views;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.impl.DirectToolItemImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditor;
import org.grits.toolbox.editor.experimentdesigner.io.ProtocolFileHandler;
import org.grits.toolbox.editor.experimentdesigner.model.ExperimentGraph;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.InputNode;
import org.grits.toolbox.editor.experimentdesigner.model.OutputNode;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.parts.GraphNodeEditPart;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ProtocolView
implements ModifyListener {
    public static final String VIEW_ID = "org.grits.toolbox.editor.experimentdesigner.part.protocolview";
    private static Logger logger = Logger.getLogger(ProtocolView.class);
    private FormToolkit toolkit;
    private ScrolledForm scrolledForm;
    private Text name;
    private Text description;
    private Text creator;
    private Text protocolCategory;
    private Text template;
    private Text templateUri;
    private Text uri;
    private Text url;
    private Text file;
    private ProtocolNode protocol;
    @Inject
    IEventBroker eventBroker;
    GraphEditor editor;
    Button download;
    private Entry projectEntry;
    private Button delete;
    private Button browse;
    private DirectToolItemImpl saveVariantToolItem;
    private DirectToolItemImpl saveTemplateToolItem;
    private final EventHandler closePartEventHandler = new EventHandler(){

        void clearFields() {
            if (ProtocolView.this.name != null && !ProtocolView.this.name.isDisposed()) {
                ProtocolView.this.name.removeModifyListener((ModifyListener)ProtocolView.this);
                ProtocolView.this.description.removeModifyListener((ModifyListener)ProtocolView.this);
                ProtocolView.this.creator.removeModifyListener((ModifyListener)ProtocolView.this);
                ProtocolView.this.url.removeModifyListener((ModifyListener)ProtocolView.this);
                ProtocolView.this.uri.removeModifyListener((ModifyListener)ProtocolView.this);
                ProtocolView.this.cleanUp();
                ProtocolView.this.name.addModifyListener((ModifyListener)ProtocolView.this);
                ProtocolView.this.description.addModifyListener((ModifyListener)ProtocolView.this);
                ProtocolView.this.creator.addModifyListener((ModifyListener)ProtocolView.this);
                ProtocolView.this.uri.addModifyListener((ModifyListener)ProtocolView.this);
                ProtocolView.this.url.addModifyListener((ModifyListener)ProtocolView.this);
            }
        }

        public void handleEvent(Event event) {
            Object part = event.getProperty("ChangedElement");
            if (part == null) {
                return;
            }
            boolean toBeRendered = (Boolean)event.getProperty("NewValue");
            if (!toBeRendered && part instanceof MPart && ((MPart)part).getObject() instanceof CompatibilityEditor && ((CompatibilityEditor)((MPart)part).getObject()).getEditor() instanceof GraphEditor) {
                this.clearFields();
            }
        }
    };

    public ProtocolNode getProtocol() {
        return this.protocol;
    }

    public Entry getProjectEntry() {
        return this.projectEntry;
    }

    @PostConstruct
    public void createPartControl(final Composite parent, MPart part, EModelService modelService) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.scrolledForm = this.toolkit.createScrolledForm(parent);
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 5;
        this.scrolledForm.getBody().setLayout((Layout)tableWrapLayout);
        Label lblName = this.toolkit.createLabel(this.scrolledForm.getBody(), "Name", 0);
        lblName.setLayoutData((Object)new TableWrapData(8, 16, 1, 1));
        this.name = this.toolkit.createText(this.scrolledForm.getBody(), "", 0);
        this.name.setTextLimit(80);
        this.name.setLayoutData((Object)new TableWrapData(256, 16, 1, 4));
        this.name.addModifyListener((ModifyListener)this);
        Label lblUrl = this.toolkit.createLabel(this.scrolledForm.getBody(), "URL", 0);
        lblUrl.setLayoutData((Object)new TableWrapData(8, 16, 1, 1));
        this.url = this.toolkit.createText(this.scrolledForm.getBody(), "", 0);
        this.url.setLayoutData((Object)new TableWrapData(256, 16, 1, 4));
        this.url.addModifyListener((ModifyListener)this);
        Label lblFile = this.toolkit.createLabel(this.scrolledForm.getBody(), "File", 0);
        lblFile.setLayoutData((Object)new TableWrapData(8, 16, 1, 1));
        this.file = this.toolkit.createText(this.scrolledForm.getBody(), "", 8);
        TableWrapData twd_file = new TableWrapData(128, 16, 1, 1);
        twd_file.grabHorizontal = true;
        this.file.setLayoutData((Object)twd_file);
        this.browse = this.toolkit.createButton(this.scrolledForm.getBody(), "Select File", 8);
        this.browse.setLayoutData((Object)new TableWrapData(8, 16, 1, 1));
        this.browse.setToolTipText("Select a file from the file system to upload");
        this.browse.setEnabled(false);
        this.browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(parent.getDisplay().getActiveShell(), 4096);
                fd.setText("Upload");
                String selected = fd.open();
                try {
                    if (selected != null && selected.trim().length() != 0) {
                        String filename = ProtocolView.this.uploadFile(ProtocolView.this.file.getText(), selected);
                        if (ProtocolView.this.protocol != null) {
                            ProtocolView.this.protocol.setFile(filename);
                            ProtocolView.this.file.setText(filename);
                            ProtocolView.this.eventBroker.post("EventTopic_EventPart_Modified", (Object)ProtocolView.this.protocol);
                            ProtocolView.this.delete.setEnabled(true);
                            ProtocolView.this.download.setEnabled(true);
                        }
                    }
                }
                catch (IOException e1) {
                    logger.error((Object)"Could not upload file", (Throwable)e1);
                    MessageDialog.openError((Shell)parent.getDisplay().getActiveShell(), (String)"File Upload Error", (String)"Could not upload the file into workspace");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.delete = this.toolkit.createButton(this.scrolledForm.getBody(), "Remove", 8);
        this.delete.setLayoutData((Object)new TableWrapData(8, 16, 1, 1));
        this.delete.setToolTipText("Delete the file associated with the protocol");
        this.delete.setEnabled(false);
        this.delete.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String filename = ProtocolView.this.file.getText();
                if (filename != null && filename.length() != 0) {
                    ProtocolView.this.deleteFile(filename);
                    ProtocolView.this.file.setText("");
                    ProtocolView.this.protocol.setFile(null);
                    ProtocolView.this.eventBroker.post("EventTopic_EventPart_Modified", (Object)ProtocolView.this.protocol);
                    ProtocolView.this.delete.setEnabled(false);
                    ProtocolView.this.download.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.download = this.toolkit.createButton(this.scrolledForm.getBody(), "Download", 8);
        this.download.setLayoutData((Object)new TableWrapData(8, 16, 1, 1));
        this.download.setToolTipText("Download the file into your computer");
        this.download.setEnabled(false);
        this.download.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ProtocolView.this.protocol.getFile() != null) {
                    FileDialog fd = new FileDialog(parent.getDisplay().getActiveShell(), 8192);
                    fd.setText("Download");
                    fd.setFileName(ProtocolView.this.protocol.getFile());
                    fd.setOverwrite(true);
                    String selected = fd.open();
                    try {
                        if (selected != null && selected.trim().length() != 0) {
                            ProtocolView.this.downloadFile(ProtocolView.this.protocol.getFile(), selected);
                        }
                    }
                    catch (IOException e1) {
                        logger.error((Object)"Could not download file", (Throwable)e1);
                        MessageDialog.openError((Shell)parent.getDisplay().getActiveShell(), (String)"File Download Error", (String)"Could not download the file. It has been removed from the workspace");
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblDescription = this.toolkit.createLabel(this.scrolledForm.getBody(), "Description", 0);
        lblDescription.setLayoutData((Object)new TableWrapData(8, 16, 1, 1));
        this.description = this.toolkit.createText(this.scrolledForm.getBody(), "", 578);
        this.description.setTextLimit(10000);
        TableWrapData twd_description = new TableWrapData(256, 16, 1, 4);
        twd_description.heightHint = 60;
        this.description.setLayoutData((Object)twd_description);
        this.description.addModifyListener((ModifyListener)this);
        this.description.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 97) {
                    ((Text)e.widget).selectAll();
                }
            }
        });
        Label lblCreator = this.toolkit.createLabel(this.scrolledForm.getBody(), "Creator", 0);
        lblCreator.setLayoutData((Object)new TableWrapData(8, 16, 1, 1));
        this.creator = this.toolkit.createText(this.scrolledForm.getBody(), "", 0);
        this.creator.setTextLimit(80);
        this.creator.setLayoutData((Object)new TableWrapData(256, 16, 1, 4));
        this.creator.addModifyListener((ModifyListener)this);
        Label lblCategory = this.toolkit.createLabel(this.scrolledForm.getBody(), "Category", 0);
        lblCategory.setLayoutData((Object)new TableWrapData(8, 16, 1, 1));
        this.protocolCategory = this.toolkit.createText(this.scrolledForm.getBody(), "", 8);
        this.protocolCategory.setBackground(ColorConstants.button);
        this.protocolCategory.setLayoutData((Object)new TableWrapData(256, 16, 1, 4));
        Label lblTemplate = this.toolkit.createLabel(this.scrolledForm.getBody(), "Template", 0);
        lblTemplate.setLayoutData((Object)new TableWrapData(8, 16, 1, 1));
        this.template = this.toolkit.createText(this.scrolledForm.getBody(), "", 8);
        this.template.setLayoutData((Object)new TableWrapData(256, 16, 1, 4));
        this.template.setBackground(ColorConstants.button);
        Label lbltemplateURI = this.toolkit.createLabel(this.scrolledForm.getBody(), "Template URI", 0);
        lbltemplateURI.setLayoutData((Object)new TableWrapData(8, 16, 1, 1));
        this.templateUri = this.toolkit.createText(this.scrolledForm.getBody(), "", 8);
        this.templateUri.setLayoutData((Object)new TableWrapData(256, 16, 1, 4));
        this.templateUri.setBackground(ColorConstants.button);
        Label lblURI = this.toolkit.createLabel(this.scrolledForm.getBody(), "Protocol URI", 0);
        lblURI.setLayoutData((Object)new TableWrapData(8, 16, 1, 1));
        this.uri = this.toolkit.createText(this.scrolledForm.getBody(), "", 0);
        this.uri.setLayoutData((Object)new TableWrapData(256, 16, 1, 4));
        this.uri.addModifyListener((ModifyListener)this);
        this.toolkit.paintBordersFor(this.scrolledForm.getBody());
        part.getContext().set(ProtocolView.class, (Object)this);
        this.saveVariantToolItem = (DirectToolItemImpl)modelService.find("org.grits.toolbox.editor.experimentdesigner.directtoolitem.savethisprotocolasavariant", (MUIElement)part.getToolbar());
        this.saveTemplateToolItem = (DirectToolItemImpl)modelService.find("org.grits.toolbox.editor.experimentdesigner.directtoolitem.savethisprotocolasanewtemplate", (MUIElement)part.getToolbar());
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this.closePartEventHandler);
    }

    @Inject
    @Optional
    public void subscribeTopicPartActivation(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/activate") Event event, IEclipseContext eclipseContext) {
        Object element = event.getProperty("ChangedElement");
        if (!(element instanceof MPart)) {
            return;
        }
        MPart part = (MPart)element;
        if (part.getObject() instanceof CompatibilityEditor && ((CompatibilityEditor)part.getObject()).getEditor() instanceof GraphEditor) {
            this.editor = (GraphEditor)((CompatibilityEditor)part.getObject()).getEditor();
            logger.debug((Object)("ProtocolView - Active Graph Editor changed to: " + this.editor.getPartName()));
        }
    }

    @PreDestroy
    public void preDestroy(MPart part) {
        ContextInjectionFactory.uninject((Object)this, (IEclipseContext)part.getContext());
        this.eventBroker.unsubscribe(this.closePartEventHandler);
    }

    protected void downloadFile(String file, String newPath) throws IOException {
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator;
        if (this.projectEntry != null) {
            projectFolderLocation = String.valueOf(projectFolderLocation) + this.projectEntry.getDisplayName();
        }
        String uploadFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "files";
        File workspaceFile = new File(String.valueOf(uploadFolderLocation) + File.separator + file);
        FileOutputStream out = new FileOutputStream(newPath);
        Files.copy(workspaceFile.toPath(), out);
        out.close();
    }

    private boolean deleteFile(String filename) {
        String fileFolderLocation;
        File fileToBeRemoved;
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator;
        if (this.projectEntry != null) {
            projectFolderLocation = String.valueOf(projectFolderLocation) + this.projectEntry.getDisplayName();
        }
        if ((fileToBeRemoved = new File(String.valueOf(fileFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "files") + File.separator + filename)).exists()) {
            return fileToBeRemoved.delete();
        }
        return false;
    }

    private String uploadFile(String oldFile, String path) throws IOException {
        File old;
        String uploadFolderLocation;
        File uploadFolder;
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator;
        if (this.projectEntry != null) {
            projectFolderLocation = String.valueOf(projectFolderLocation) + this.projectEntry.getDisplayName();
        }
        if (!(uploadFolder = new File(uploadFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "files")).exists()) {
            uploadFolder.mkdirs();
        }
        if (oldFile != null && oldFile.length() != 0 && (old = new File(String.valueOf(uploadFolderLocation) + File.separator + oldFile)).exists()) {
            old.delete();
        }
        File original = new File(path);
        File destinationFile = new File(String.valueOf(uploadFolderLocation) + File.separator + original.getName());
        String f = original.getName();
        while (destinationFile.exists()) {
            f = ProtocolFileHandler.generateUniqueFileName(f, uploadFolder.list());
            destinationFile = new File(String.valueOf(uploadFolderLocation) + File.separator + f);
        }
        FileOutputStream uploadedFile = new FileOutputStream(destinationFile);
        Files.copy(original.toPath(), uploadedFile);
        uploadedFile.close();
        return destinationFile.getName();
    }

    public void setProtocol(ProtocolNode node) {
        this.protocol = node;
    }

    public void modifyText(ModifyEvent e) {
        if (this.editor == null) {
            logger.error((Object)"Cannot get the reference to Graph Editor");
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Update Error", (String)"Cannot get the reference to Graph Editor");
            return;
        }
        Text newText = (Text)e.widget;
        String newValue = newText.getText();
        if (newValue != null) {
            newValue = newValue.trim();
        }
        if (this.protocol != null) {
            if (e.getSource().equals(this.name)) {
                this.protocol.setLabelModify(newValue);
                this.eventBroker.post("EventTopic_EventPart_Modified", (Object)this.protocol);
                this.editor.refreshProtocolNode(this.protocol);
            } else if (e.getSource().equals(this.description)) {
                this.protocol.setDescription(newValue);
                this.eventBroker.post("EventTopic_EventPart_Modified", (Object)this.protocol);
                this.editor.refreshProtocolNode(this.protocol);
            } else if (e.getSource().equals(this.creator)) {
                this.protocol.setCreator(newValue);
                this.eventBroker.post("EventTopic_EventPart_Modified", (Object)this.protocol);
                this.editor.refreshProtocolNode(this.protocol);
            } else if (e.getSource().equals(this.url)) {
                this.protocol.setUrl(newValue);
                this.eventBroker.post("EventTopic_EventPart_Modified", (Object)this.protocol);
                this.editor.refreshProtocolNode(this.protocol);
            } else if (e.getSource().equals(this.uri)) {
                this.protocol.setUri(newValue);
                this.eventBroker.post("EventTopic_EventPart_Modified", (Object)this.protocol);
                this.editor.refreshProtocolNode(this.protocol);
            }
        }
    }

    @Optional
    @Inject
    void setSelection(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object selection) {
        if (selection != null && !(selection instanceof StructuredSelection)) {
            return;
        }
        if (this.name == null || this.name.isDisposed()) {
            return;
        }
        if (selection == null || !(((StructuredSelection)selection).getFirstElement() instanceof GraphNodeEditPart)) {
            this.cleanUp();
        } else if (((StructuredSelection)selection).getFirstElement() != null && ((StructuredSelection)selection).getFirstElement() instanceof GraphNodeEditPart) {
            this.name.removeModifyListener((ModifyListener)this);
            this.description.removeModifyListener((ModifyListener)this);
            this.url.removeModifyListener((ModifyListener)this);
            this.creator.removeModifyListener((ModifyListener)this);
            this.uri.removeModifyListener((ModifyListener)this);
            Object modelObject = ((GraphNodeEditPart)((StructuredSelection)selection).getFirstElement()).getModel();
            if (modelObject instanceof ProtocolNode) {
                ExperimentGraph graph = (ExperimentGraph)((GraphNodeEditPart)((StructuredSelection)selection).getFirstElement()).getParent().getModel();
                this.projectEntry = graph.getProjectEntry();
                this.protocol = (ProtocolNode)modelObject;
                if (this.protocol.getTemplate() != null) {
                    this.template.setText(this.protocol.getTemplate());
                } else {
                    this.template.setText("");
                }
                if (this.protocol.getDescription() != null) {
                    this.description.setText(this.protocol.getDescription());
                } else {
                    this.description.setText("");
                }
                if (this.protocol.getCategory() != null) {
                    this.protocolCategory.setText(this.protocol.getCategory().getName());
                } else {
                    this.protocolCategory.setText("");
                }
                if (this.protocol.getLabel() != null) {
                    this.name.setText(this.protocol.getLabel());
                } else {
                    this.name.setText("");
                }
                if (this.protocol.getCreator() != null) {
                    this.creator.setText(this.protocol.getCreator());
                } else {
                    this.creator.setText("");
                }
                if (this.protocol.getTemplateUri() != null) {
                    if (!this.protocol.getTemplateUri().equals(this.protocol.getUri())) {
                        this.uri.setText(this.protocol.getUri() == null ? "" : this.protocol.getUri());
                    }
                    this.templateUri.setText(this.protocol.getTemplateUri());
                } else {
                    this.uri.setText(this.protocol.getUri() == null ? "" : this.protocol.getUri());
                    this.templateUri.setText("");
                }
                if (this.protocol.getUrl() != null) {
                    this.url.setText(this.protocol.getUrl());
                } else {
                    this.url.setText("");
                }
                if (this.protocol.getFile() != null) {
                    this.file.setText(this.protocol.getFile());
                    this.delete.setEnabled(true);
                    this.download.setEnabled(true);
                } else {
                    this.file.setText("");
                }
                this.browse.setEnabled(true);
                this.saveVariantToolItem.setEnabled(true);
                this.saveTemplateToolItem.setEnabled(true);
            } else if (modelObject instanceof OutputNode || modelObject instanceof InputNode) {
                this.name.setText(((GraphNode)modelObject).getLabel());
                if (((GraphNode)modelObject).getDescription() != null) {
                    this.description.setText(((GraphNode)modelObject).getDescription());
                } else {
                    this.description.setText("");
                }
                this.protocolCategory.setText("");
                this.template.setText("");
                this.creator.setText("");
                this.templateUri.setText("");
                this.file.setText("");
                this.url.setText("");
                this.protocol = null;
                this.download.setEnabled(false);
                this.delete.setEnabled(false);
                this.browse.setEnabled(false);
                this.saveVariantToolItem.setEnabled(false);
                this.saveTemplateToolItem.setEnabled(false);
            } else {
                this.cleanUp();
            }
            this.name.addModifyListener((ModifyListener)this);
            this.description.addModifyListener((ModifyListener)this);
            this.creator.addModifyListener((ModifyListener)this);
            this.url.addModifyListener((ModifyListener)this);
            this.uri.addModifyListener((ModifyListener)this);
        }
    }

    void cleanUp() {
        this.protocol = null;
        this.name.setText("");
        this.description.setText("");
        this.template.setText("");
        this.protocolCategory.setText("");
        this.creator.setText("");
        this.templateUri.setText("");
        this.url.setText("");
        this.uri.setText("");
        this.file.setText("");
        this.download.setEnabled(false);
        this.delete.setEnabled(false);
        this.browse.setEnabled(false);
        this.saveVariantToolItem.setEnabled(false);
        this.saveTemplateToolItem.setEnabled(false);
    }

    public void templateChanged(String newTemplate, String newTemplateUri) {
        this.template.setText(newTemplate);
        this.templateUri.setText(newTemplateUri);
    }

    public void templateAdded(String templateURI) {
        this.eventBroker.post("EventTopic_EventPart_Modified", (Object)templateURI);
        if (this.editor == null) {
            logger.error((Object)"Cannot get a reference to GraphEditor");
            return;
        }
        this.editor.refreshPalette(templateURI);
    }

    @Optional
    @Inject
    void refreshTemplate(@UIEventTopic(value="EventTopic_EventPart_Modified") String newTemplate) {
        this.template.setText("");
        this.templateUri.setText("");
    }
}

