/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.model;

import com.hp.hpl.jena.vocabulary.XSD;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.grits.toolbox.editor.experimentdesigner.model.EntityWithPosition;
import org.grits.toolbox.editor.experimentdesigner.model.MeasurementUnit;
import org.grits.toolbox.editor.experimentdesigner.ontology.OntologyManager;

@XmlRootElement(name="parameter")
public class Parameter
implements EntityWithPosition {
    String uri;
    String name;
    String value;
    MeasurementUnit unit;
    Boolean required;
    String description;
    Integer position;
    List<String> guidelineURIs;
    List<MeasurementUnit> availableUnits;
    String namespace;
    String namespaceFile;
    Boolean shortNamespace = false;
    Integer groupId;

    public Parameter() {
    }

    public Parameter(Parameter p) {
        this.uri = p.getUri();
        this.name = p.getName();
        this.value = p.getValue();
        this.description = p.getDescription();
        this.required = p.getRequired();
        this.availableUnits = p.getAvailableUnits();
        this.unit = p.getUnit();
        this.namespace = p.getNamespace();
        this.namespaceFile = p.getNamespaceFile();
        this.shortNamespace = p.getShortNamespace();
        this.position = p.getPosition();
        this.guidelineURIs = p.getGuidelineURIs();
    }

    public Parameter(Parameter p, int gid) {
        this(p);
        this.groupId = gid;
    }

    @XmlAttribute
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @XmlElement
    public MeasurementUnit getUnit() {
        return this.unit;
    }

    public void setUnit(MeasurementUnit unit) {
        this.unit = unit;
    }

    @XmlElementWrapper
    public List<MeasurementUnit> getAvailableUnits() {
        return this.availableUnits;
    }

    public void setAvailableUnits(List<MeasurementUnit> availableUnits) {
        this.availableUnits = availableUnits;
    }

    @XmlAttribute
    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    @XmlAttribute
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        if (namespace != null && namespace.equals(XSD.xdouble.getURI())) {
            namespace = String.valueOf(OntologyManager.baseURI) + "double";
        } else if (namespace != null && namespace.equals(XSD.xstring.getURI())) {
            namespace = String.valueOf(OntologyManager.baseURI) + "string";
        }
        this.namespace = namespace;
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Parameter) {
            if (this.groupId != null && ((Parameter)obj).getGroupId() != null) {
                return ((Parameter)obj).getName().equals(this.name) && ((Parameter)obj).getGroupId().equals(this.groupId);
            }
            return ((Parameter)obj).getName().equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getNamespaceFile() {
        return this.namespaceFile;
    }

    public void setNamespaceFile(String namespaceFile) {
        this.namespaceFile = namespaceFile;
    }

    @XmlAttribute
    public Boolean getShortNamespace() {
        return this.shortNamespace;
    }

    public void setShortNamespace(Boolean isShortNamespace) {
        this.shortNamespace = isShortNamespace;
    }

    @Override
    @XmlAttribute
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Integer position) {
        this.position = position;
    }

    public List<String> getGuidelineURIs() {
        return this.guidelineURIs;
    }

    public void setGuidelineURIs(List<String> guidelineURIs) {
        this.guidelineURIs = guidelineURIs;
    }

    public Parameter getACopy() {
        Parameter parameter = new Parameter();
        parameter.setUri(this.uri);
        parameter.setName(this.name);
        parameter.setDescription(this.description);
        parameter.setGroupId(this.groupId);
        parameter.setNamespace(this.namespace);
        parameter.setNamespaceFile(this.namespaceFile);
        parameter.setPosition(this.getPosition());
        parameter.setGuidelineURIs(this.getGuidelineURIs());
        if (this.shortNamespace != null) {
            parameter.setShortNamespace((boolean)this.shortNamespace);
        }
        if (this.unit != null) {
            parameter.setUnit(this.unit.getACopy());
        }
        if (this.availableUnits != null) {
            ArrayList<MeasurementUnit> unitList = new ArrayList<MeasurementUnit>();
            for (MeasurementUnit availableUnit : this.availableUnits) {
                unitList.add(availableUnit.getACopy());
            }
            parameter.setAvailableUnits(unitList);
        }
        parameter.setValue(this.value);
        parameter.setRequired(this.required);
        return parameter;
    }
}

