/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.handler;

import java.util.Arrays;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.grits.toolbox.editor.experimentdesigner.config.ImageRegistry;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditor;
import org.grits.toolbox.editor.experimentdesigner.pdfgeneration.ExperimentDesignRDFReport;
import org.grits.toolbox.editor.experimentdesigner.wordgeneration.ExperimentDesignerWordReport;

public class ExperimentDesignReportHandler {
    public static Image wordIcon = ImageRegistry.getImageDescriptor(ImageRegistry.ExperimentDesignerImage.WORDICON).createImage();
    public static Image pdfIcon = ImageRegistry.getImageDescriptor(ImageRegistry.ExperimentDesignerImage.PDFICON).createImage();
    Options options;

    @Execute
    public void execute(@Named(value="e4ActivePart") @Named(value="e4ActivePart") MPart part, @Named(value="activeShell") @Named(value="activeShell") Shell shell) {
        if (part.getObject() instanceof CompatibilityEditor && ((CompatibilityEditor)part.getObject()).getEditor() instanceof GraphEditor) {
            this.options = new Options();
            ListDialog dialog = new ListDialog(shell){

                protected Control createDialogArea(Composite container) {
                    Composite parent = (Composite)super.createDialogArea(container);
                    ExperimentDesignReportHandler.this.addPreferenceSelection(parent);
                    return parent;
                }

                protected void okPressed() {
                    if (!(ExperimentDesignReportHandler.this.options == null || ExperimentDesignReportHandler.this.options.expDesign.booleanValue() || ExperimentDesignReportHandler.this.options.project.booleanValue() || ExperimentDesignReportHandler.this.options.sample.booleanValue())) {
                        MessageDialog.openError((Shell)this.getShell(), (String)"Selection Error", (String)"Please select at least one part to be included in the report");
                    } else {
                        super.okPressed();
                    }
                }
            };
            dialog.setLabelProvider((ILabelProvider)new ArrayLabelProvider());
            dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            dialog.setInput(Arrays.asList("PDF", "Word"));
            dialog.setTitle("Select report format");
            dialog.setInitialSelections((Object[])new String[]{"PDF"});
            dialog.setWidthInChars(35);
            dialog.setHeightInChars(10);
            if (dialog.open() != 0) {
                return;
            }
            Object[] result = dialog.getResult();
            if (result != null && result.length > 0) {
                String format = (String)result[0];
                if (format.equals("PDF")) {
                    new ExperimentDesignRDFReport().generateDocument(this.options, (GraphEditor)((CompatibilityEditor)part.getObject()).getEditor());
                } else if (format.equals("Word")) {
                    new ExperimentDesignerWordReport().generateReport(this.options, (GraphEditor)((CompatibilityEditor)part.getObject()).getEditor());
                } else {
                    MessageDialog.openInformation((Shell)shell, (String)"Not Supported", (String)("The format" + format + " is not supported"));
                }
            }
        }
    }

    protected void addPreferenceSelection(Composite parent) {
        GridLayout g = new GridLayout();
        g.numColumns = 2;
        Composite preferenceComposite = new Composite(parent, 0);
        preferenceComposite.setLayout((Layout)g);
        Label projectLabel = new Label(preferenceComposite, 0);
        projectLabel.setText("Project Information");
        Button project = new Button(preferenceComposite, 32);
        project.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    ExperimentDesignReportHandler.this.options.setProject(true);
                } else {
                    ExperimentDesignReportHandler.this.options.setProject(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    ExperimentDesignReportHandler.this.options.setProject(true);
                } else {
                    ExperimentDesignReportHandler.this.options.setProject(false);
                }
            }
        });
        project.setSelection(true);
        Label sampleLabel = new Label(preferenceComposite, 0);
        sampleLabel.setText("Analyte Information");
        Button sample = new Button(preferenceComposite, 32);
        sample.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    ExperimentDesignReportHandler.this.options.setSample(true);
                } else {
                    ExperimentDesignReportHandler.this.options.setSample(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    ExperimentDesignReportHandler.this.options.setSample(true);
                } else {
                    ExperimentDesignReportHandler.this.options.setSample(false);
                }
            }
        });
        sample.setSelection(true);
        Label expDesignLabel = new Label(preferenceComposite, 0);
        expDesignLabel.setText("Experiment Design");
        Button expDesign = new Button(preferenceComposite, 32);
        expDesign.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    ExperimentDesignReportHandler.this.options.setExpDesign(true);
                } else {
                    ExperimentDesignReportHandler.this.options.setExpDesign(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    ExperimentDesignReportHandler.this.options.setExpDesign(true);
                } else {
                    ExperimentDesignReportHandler.this.options.setExpDesign(false);
                }
            }
        });
        expDesign.setSelection(true);
    }

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") @Named(value="e4ActivePart") MPart part) {
        return part.getObject() instanceof CompatibilityEditor && ((CompatibilityEditor)part.getObject()).getEditor() instanceof GraphEditor;
    }

    static class ArrayLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ArrayLabelProvider() {
        }

        public String getText(Object element) {
            return (String)element;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (((String)element).equals("Word")) {
                return wordIcon;
            }
            if (((String)element).equals("PDF")) {
                return pdfIcon;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return (String)element;
        }
    }

    public class Options {
        Boolean project = true;
        Boolean sample = true;
        Boolean expDesign = true;

        public Boolean getProject() {
            return this.project;
        }

        public void setProject(Boolean project) {
            this.project = project;
        }

        public Boolean getSample() {
            return this.sample;
        }

        public void setSample(Boolean sample) {
            this.sample = sample;
        }

        public Boolean getExpDesign() {
            return this.expDesign;
        }

        public void setExpDesign(Boolean expDesign) {
            this.expDesign = expDesign;
        }
    }
}

