/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.editing;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.graphics.Image;

public class DoubleValidator
implements ICellEditorValidator {
    private ControlDecoration controlDecoration;

    public DoubleValidator(ControlDecoration controlDecoration) {
        this.controlDecoration = controlDecoration;
    }

    public String isValid(Object value) {
        String stringValue;
        String inValidMessage = null;
        if (value != null && !(stringValue = (String)value).isEmpty()) {
            try {
                Double.parseDouble(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                inValidMessage = "not a double value";
            }
        }
        if (inValidMessage != null) {
            Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
            this.controlDecoration.setMarginWidth(2);
            this.controlDecoration.setImage(errorImage);
            this.controlDecoration.setDescriptionText(inValidMessage);
            this.controlDecoration.show();
        } else {
            this.controlDecoration.hide();
        }
        return inValidMessage;
    }
}

