/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.actions;

import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.editor.experimentdesigner.dialog.SaveAsDialog;
import org.grits.toolbox.editor.experimentdesigner.io.ProtocolExistsException;
import org.grits.toolbox.editor.experimentdesigner.io.ProtocolFileHandler;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentDesignOntologyAPI;
import org.grits.toolbox.editor.experimentdesigner.views.ProtocolView;

public class SaveProtocolTemplateAction {
    private static final Logger logger = Logger.getLogger(SaveProtocolTemplateAction.class);
    @Inject
    ProtocolView view;

    @Execute
    public void run() {
        logger.debug((Object)"org.grits.toolbox.editor.experimentdesigner BEGIN SaveProtocolTemplateAction");
        this.openDialog(this.view);
        logger.debug((Object)"org.grits.toolbox.editor.experimentdesigner END SaveProtocolTemplateAction");
    }

    @CanExecute
    public boolean canExecute() {
        return this.view.getProtocol() != null;
    }

    private void openDialog(ProtocolView view) {
        ProtocolNode protocol = view.getProtocol();
        if (protocol != null) {
            boolean yes;
            Shell shell = Display.getCurrent().getActiveShell();
            if (!protocol.isTemplateChanged() && !(yes = MessageDialog.openQuestion((Shell)shell, (String)"Warning", (String)"No changes have been made to the protocol.\nDo you still wish to save it as a new template?"))) {
                return;
            }
            try {
                ExperimentDesignOntologyAPI api = new ExperimentDesignOntologyAPI();
                SaveAsDialog dialog = new SaveAsDialog(shell, SaveAsDialog.PROTOCOL_TEMPLATE, protocol.getCategory(), api.getTopLevelCategoryForProtocol(protocol));
                dialog.setDescription(protocol.getDescription());
                dialog.create();
                dialog.getShell().setSize(500, 500);
                if (dialog.open() == 0) {
                    try {
                        ProtocolNode protocolTemplate = new ProtocolNode();
                        protocolTemplate.setLabel(dialog.getName().trim());
                        protocolTemplate.setCategory(dialog.getCategory());
                        protocolTemplate.setDescription(dialog.getDescription().trim());
                        protocolTemplate.setColor(protocol.getColor());
                        protocolTemplate.setCreator(protocol.getCreator());
                        protocolTemplate.setUri(protocol.getUri());
                        protocolTemplate.setUrl(protocol.getUrl());
                        if (protocol.getFile() != null) {
                            protocolTemplate.setFile(ProtocolFileHandler.copyFromWorkspaceToConfig(protocol.getFile(), view.getProjectEntry().getDisplayName()));
                        }
                        protocolTemplate.setLocation(protocol.getLocation());
                        protocolTemplate.setSize(protocol.getSize());
                        protocolTemplate.setMyColor(protocol.getMyColor());
                        protocolTemplate.setPapers(protocol.getPapers());
                        protocolTemplate.setParameters(protocol.getParameters());
                        protocolTemplate.setParameterGroups(protocol.getParameterGroups());
                        String templateURI = api.createProtocolTemplate(protocolTemplate, dialog.getPaletteCategory().getUri());
                        view.templateAdded(templateURI);
                        protocol.setTemplate(protocolTemplate.getLabel());
                        protocol.setTemplateUri(templateURI);
                        protocol.setTemplateChanged(false);
                        view.templateChanged(protocol.getTemplate(), templateURI);
                    }
                    catch (ProtocolExistsException protocolExistsException) {
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)("Protocol template with name: " + dialog.getName() + " already exists. Please choose a different name"));
                        this.openDialog(view);
                    }
                    catch (Exception e) {
                        logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Could not save it as a protocol template. ", (Throwable)e);
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)("Could not save it as a protocol template. " + e));
                    }
                }
            }
            catch (Exception e1) {
                logger.error((Object)"Cannot access the ontology", (Throwable)e1);
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Cannot access the ontology. " + e1));
            }
        }
    }
}

