/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.actions;

import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;
import org.grits.toolbox.editor.experimentdesigner.config.ImageRegistry;
import org.grits.toolbox.editor.experimentdesigner.dialog.SaveAsDialog;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditor;
import org.grits.toolbox.editor.experimentdesigner.io.ProtocolFileHandler;
import org.grits.toolbox.editor.experimentdesigner.io.TemplateExistsException;
import org.grits.toolbox.editor.experimentdesigner.model.ExperimentGraph;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentDesignOntologyAPI;

public class SaveExperimentTemplateAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private static final Logger logger = Logger.getLogger(SaveExperimentTemplateAction.class);
    ExperimentGraph experimentDesign;
    GraphEditor editor;

    public SaveExperimentTemplateAction(GraphEditor editor) {
        this.editor = editor;
        this.experimentDesign = editor.getModel();
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageRegistry.getImageDescriptor(ImageRegistry.ExperimentDesignerImage.SAVEASTEMPLATE);
    }

    public String getId() {
        return "SaveAsTemplate";
    }

    public void run() {
        logger.debug((Object)"org.grits.toolbox.editor.experimentdesigner BEGIN SaveExperimentTemplateAction...Saving the experiment design as a template");
        this.openDialog(null, null);
        logger.debug((Object)"org.grits.toolbox.editor.experimentdesigner END SaveExperimentTemplateAction.");
    }

    private void openDialog(String name, String description) {
        Shell shell = Display.getCurrent().getActiveShell();
        SaveAsDialog dialog = new SaveAsDialog(shell, SaveAsDialog.EXPERIMENT_TEMPLATE);
        dialog.setName(name);
        dialog.setDescription(description);
        dialog.create();
        dialog.getShell().setSize(500, 500);
        if (dialog.open() == 0) {
            if (this.experimentDesign != null) {
                ExperimentGraph experimentTemplate = new ExperimentGraph();
                experimentTemplate.setName(dialog.getName());
                experimentTemplate.setDescription(dialog.getDescription());
                experimentTemplate.setDateCreated(new Date());
                experimentTemplate.setCreatedBy(dialog.getCreator());
                experimentTemplate.setNodes(this.experimentDesign.getNodes());
                experimentTemplate.setConnections(this.experimentDesign.getConnections());
                experimentTemplate.setUri(this.experimentDesign.getUri());
                try {
                    new ExperimentDesignOntologyAPI().createTemplateForExperimentGraph(experimentTemplate);
                    List<GraphNode> nodes = experimentTemplate.getNodes();
                    for (GraphNode graphNode : nodes) {
                        if (!(graphNode instanceof ProtocolNode) || ((ProtocolNode)graphNode).getFile() == null) continue;
                        ((ProtocolNode)graphNode).setFile(ProtocolFileHandler.copyFromWorkspaceToConfig(((ProtocolNode)graphNode).getFile(), this.experimentDesign.getProjectEntry().getDisplayName()));
                    }
                }
                catch (TemplateExistsException templateExistsException) {
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Template with name: " + dialog.getName() + " already exists. Please choose a different name"));
                    this.openDialog(dialog.getName(), dialog.getDescription());
                }
                catch (Exception e) {
                    logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Could not save it as a template. ", (Throwable)e);
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Could not save it as a template. " + e));
                }
            } else {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Could not save it as a template. ");
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Could not save it as a template. ");
            }
        }
    }

    public void dispose() {
    }
}

