/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.wurcs.graph;

import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitor;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorException;
import org.glycoinfo.WURCSFramework.wurcs.graph.BackboneCarbon;
import org.glycoinfo.WURCSFramework.wurcs.graph.InterfaceRepeat;
import org.glycoinfo.WURCSFramework.wurcs.graph.LinkagePosition;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSComponent;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class Backbone
extends WURCSComponent {
    private LinkedList<BackboneCarbon> m_aCarbons = new LinkedList();
    private int m_iAnomericPosition = 0;
    private char m_iAnomericSymbol = (char)111;

    public int getAnomericPosition() {
        return this.m_iAnomericPosition;
    }

    public void setAnomericPosition(int a_iAnomPos) {
        this.m_iAnomericPosition = a_iAnomPos;
    }

    public char getAnomericSymbol() {
        return this.m_iAnomericSymbol;
    }

    public void setAnomericSymbol(char a_cAnomSymbol) {
        this.m_iAnomericSymbol = a_cAnomSymbol;
    }

    public boolean addBackboneCarbon(BackboneCarbon bc) {
        if (this.m_aCarbons.contains(bc)) {
            return false;
        }
        return this.m_aCarbons.add(bc);
    }

    public LinkedList<BackboneCarbon> getBackboneCarbons() {
        return this.m_aCarbons;
    }

    public int getLength() {
        if (this.hasUnknownLength()) {
            return -1;
        }
        return this.m_aCarbons.size();
    }

    public String getSkeletonCode() {
        String code = "";
        for (BackboneCarbon oBC : this.m_aCarbons) {
            code = code + oBC.getCode();
        }
        return code;
    }

    public boolean hasUnknownLength() {
        for (BackboneCarbon bc : this.m_aCarbons) {
            if (!bc.hasUnknownLength()) continue;
            return true;
        }
        return false;
    }

    private void clear() {
        this.m_aCarbons.clear();
    }

    public WURCSEdge getAnomericEdge() {
        if (this.m_iAnomericPosition == 0) {
            return null;
        }
        for (WURCSEdge edge : this.getEdges()) {
            if (edge.getLinkages().size() > 1 || edge.getLinkages().get(0).getBackbonePosition() != this.m_iAnomericPosition || edge.getModification() == null || !edge.getModification().isGlycosidic() || edge.getModification() instanceof InterfaceRepeat) continue;
            return edge;
        }
        return null;
    }

    public boolean hasParent() {
        WURCSEdge t_objAnomEdge = this.getAnomericEdge();
        if (t_objAnomEdge == null) {
            return false;
        }
        if (t_objAnomEdge.getModification().isGlycosidic()) {
            return true;
        }
        return !t_objAnomEdge.getModification().isAglycone();
    }

    public int getBackboneScore() {
        int score = 0;
        score += 20 * this.m_iAnomericPosition;
        int length = this.getLength();
        for (int i = 0; i < length; ++i) {
            score += (i + 1) * this.getBackboneCarbons().get(i).getDescriptor().getCarbonScore();
        }
        return score;
    }

    @Override
    public Backbone copy() {
        Backbone copy = new Backbone();
        for (BackboneCarbon bc : this.getBackboneCarbons()) {
            copy.addBackboneCarbon(bc.copy(copy));
        }
        copy.setAnomericPosition(this.m_iAnomericPosition);
        copy.setAnomericSymbol(this.m_iAnomericSymbol);
        copy.removeAllEdges();
        return copy;
    }

    public void invert() {
        if (this.hasUnknownLength()) {
            return;
        }
        LinkedList<BackboneCarbon> inverts = new LinkedList<BackboneCarbon>();
        for (BackboneCarbon orig : this.m_aCarbons) {
            inverts.addFirst(orig.invert(this));
        }
        this.clear();
        for (BackboneCarbon inv : inverts) {
            this.m_aCarbons.add(inv);
        }
        for (WURCSEdge edge : this.getEdges()) {
            for (LinkagePosition link : edge.getLinkages()) {
                link.invertBackbonePosition(this.m_aCarbons.size());
            }
        }
        if (this.m_iAnomericPosition > 0 && !this.hasUnknownLength()) {
            this.m_iAnomericPosition = this.getLength() + 1 - this.m_iAnomericPosition;
        }
    }

    @Override
    public void accept(WURCSVisitor a_objVisitor) throws WURCSVisitorException {
        a_objVisitor.visit(this);
    }

    public String toString() {
        String strCode = this.getSkeletonCode();
        if (this.m_iAnomericPosition != 0 && this.m_iAnomericSymbol != 'o') {
            strCode = strCode + "-";
            strCode = strCode + (this.m_iAnomericPosition < 0 ? "?" : Integer.valueOf(this.m_iAnomericPosition));
            strCode = strCode + this.m_iAnomericSymbol;
        }
        return strCode;
    }
}

