/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.editor;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.Section;
import org.grits.toolbox.entry.qrtpcr.commands.EvaluateData;
import org.grits.toolbox.entry.qrtpcr.editor.IQrtPCRPart;
import org.grits.toolbox.entry.qrtpcr.editor.QrtPCRTableEditor;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;
import org.grits.toolbox.entry.qrtpcr.table.PlateTableBase;
import org.grits.toolbox.entry.qrtpcr.table.QrtPCRNatTable;

public class PlateTablePage
implements IQrtPCRPart {
    protected static final int HORIZONTAL_BUFFER = 8;
    protected static final int VERTICAL_BUFFER = 12;
    QrtPCRData data;
    private boolean raw;
    private Integer runId;
    Double stDevCutOff;
    Double lowerThreshold;
    boolean expanded = true;
    private QrtPCRNatTable table;
    private CTabItem cTabItem;

    public QrtPCRNatTable getTable() {
        return this.table;
    }

    @Inject
    public PlateTablePage(QrtPCRData data, CTabItem cTabItem, @Named(value="lowerThresholdContext") @Named(value="lowerThresholdContext") Double l, @Named(value="stDevContext") @Named(value="stDevContext") Double stDev, @Named(value="rawContext") @Named(value="rawContext") Boolean raw, @Named(value="runIdContext") @Named(value="runIdContext") Integer runId) {
        this.data = data;
        this.cTabItem = cTabItem;
        this.lowerThreshold = l;
        this.stDevCutOff = stDev;
        this.raw = raw;
        this.runId = runId;
    }

    @PostConstruct
    protected void createFormContent(MPart part) {
        this.createTableContents((QrtPCRTableEditor)part.getContext().get(QrtPCRTableEditor.class), this.raw, this.data, this.runId);
    }

    public void createTableContents(final QrtPCRTableEditor editor, final boolean rawData, final QrtPCRData data, final Integer runId) {
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.cTabItem.getParent(), 768);
        GridData layoutData = new GridData();
        scrolledComposite.setLayoutData((Object)layoutData);
        scrolledComposite.setLayout((Layout)new GridLayout());
        Composite parent = new Composite((Composite)scrolledComposite, 4);
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite sectionParentComposite = new Composite(parent, 4);
        sectionParentComposite.setLayout((Layout)new FillLayout());
        Section section = new Section(sectionParentComposite, 320);
        section.setText("Data");
        Composite client = new Composite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        ToolBarManager toolBarManager = new ToolBarManager();
        Action applyRulesAction = new Action("Apply Rules"){

            public void run() {
                Dialog stdevCutoffDialog;
                if (!rawData && (stdevCutoffDialog = new Dialog(Display.getCurrent().getActiveShell()){
                    private ControlDecoration dec2;

                    protected Control createDialogArea(Composite parent) {
                        Composite container = new Composite(parent, 0);
                        GridLayout gridLayout = new GridLayout();
                        gridLayout.numColumns = 2;
                        gridLayout.verticalSpacing = 10;
                        container.setLayout((Layout)gridLayout);
                        Label stDevLabel = new Label(container, 16384);
                        stDevLabel.setText("Maximum Standard Deviation");
                        stDevLabel.setToolTipText("Standard deviation cut-off value. Entries having standard deviations more than this cutoff will be highlighted");
                        Text stDevCutoffText = new Text(container, 2048);
                        stDevCutoffText.setText("" + (this).PlateTablePage.this.stDevCutOff);
                        this.dec2 = new ControlDecoration((Control)stDevCutoffText, 16512);
                        Image image = JFaceResources.getImage((String)"dialog_message_error_image");
                        this.dec2.setImage(image);
                        this.dec2.setDescriptionText("Should enter a floating point number");
                        this.dec2.hide();
                        stDevCutoffText.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                Text newText = (Text)e.widget;
                                String newValue = newText.getText();
                                if (newValue != null) {
                                    newValue = newValue.trim();
                                }
                                try {
                                    ((this).this).PlateTablePage.this.stDevCutOff = Double.parseDouble(newValue);
                                    dec2.hide();
                                }
                                catch (NumberFormatException numberFormatException) {
                                    dec2.show();
                                }
                            }
                        });
                        return container;
                    }
                }).open() == 0) {
                    if (EvaluateData.applyRules(data, 0, PlateTablePage.this.lowerThreshold, PlateTablePage.this.stDevCutOff)) {
                        PlateTablePage.this.table.refresh();
                        editor.markDirty();
                    }
                    editor.setOriginalForRun(runId);
                }
            }

            public String getToolTipText() {
                return "Apply rules to determine possible reruns";
            }
        };
        Action collapseExpandAction = new Action("Collapse/Expand"){

            public void run() {
                if (PlateTablePage.this.table != null) {
                    PlateTablePage.this.table.toggleExpandCollapse(PlateTablePage.this.expanded);
                    PlateTablePage.this.expanded = !PlateTablePage.this.expanded;
                }
            }
        };
        if (rawData) {
            applyRulesAction.setEnabled(false);
        }
        toolBarManager.add((IAction)applyRulesAction);
        toolBarManager.add((IAction)collapseExpandAction);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        section.setTextClient((Control)toolbar);
        if (!rawData) {
            this.createLegend(client);
        }
        PlateTableBase myTable = new PlateTableBase(editor);
        myTable.setData(data);
        myTable.setLowerThreshold(this.lowerThreshold);
        myTable.setRawData(rawData);
        myTable.setStDevCutOff(this.stDevCutOff);
        myTable.setRunId(runId);
        this.table = (QrtPCRNatTable)myTable.createControl(client);
        this.table.setLayoutData(new GridData(4, 4, true, true, 1, 20));
        section.setClient((Control)client);
        GridData compositeLayoutData = new GridData(1808);
        compositeLayoutData.verticalSpan = 1;
        compositeLayoutData.horizontalSpan = 1;
        sectionParentComposite.setLayoutData((Object)compositeLayoutData);
        scrolledComposite.setContent((Control)parent);
        scrolledComposite.setMinSize(parent.computeSize(-1, -1));
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        this.cTabItem.setControl((Control)scrolledComposite);
    }

    private void createLegend(Composite client) {
        FontData[] fD = Display.getDefault().getSystemFont().getFontData();
        fD[0].setStyle(1);
        Font boldFont = new Font((Device)Display.getDefault(), fD);
        Group legendGroup = new Group(client, 0);
        legendGroup.setText("Legend");
        legendGroup.setLayout((Layout)new GridLayout(17, false));
        Label control = new Label((Composite)legendGroup, 2049);
        control.setText("Bold");
        control.setFont(boldFont);
        Label controllabel = new Label((Composite)legendGroup, 2048);
        controllabel.setText("Control Gene");
        Label verticalSeparator = new Label((Composite)legendGroup, 514);
        GridData layoutData = new GridData();
        layoutData.heightHint = control.computeSize((int)-1, (int)-1).y + 5;
        verticalSeparator.setLayoutData((Object)layoutData);
        StyledText text = new StyledText((Composite)legendGroup, 2048);
        text.setText("xx.xx");
        text.setEnabled(false);
        StyleRange style2 = new StyleRange();
        style2.start = 0;
        style2.length = 5;
        style2.strikeout = true;
        text.setStyleRange(style2);
        text.setEditable(false);
        Label eliminate = new Label((Composite)legendGroup, 2048);
        eliminate.setText("Eliminated");
        verticalSeparator = new Label((Composite)legendGroup, 514);
        verticalSeparator.setLayoutData((Object)layoutData);
        Label rerun = new Label((Composite)legendGroup, 2048);
        rerun.setText("Gene");
        rerun.setBackground(Display.getDefault().getSystemColor(3));
        Label rerunLabel = new Label((Composite)legendGroup, 2048);
        rerunLabel.setText("To be Rerun");
        verticalSeparator = new Label((Composite)legendGroup, 514);
        verticalSeparator.setLayoutData((Object)layoutData);
        Label redForeground = new Label((Composite)legendGroup, 2048);
        redForeground.setText("xx.xx");
        redForeground.setForeground(Display.getDefault().getSystemColor(3));
        Label redLabel = new Label((Composite)legendGroup, 2048);
        redLabel.setText("StDev >= cutOff or user modified value");
        verticalSeparator = new Label((Composite)legendGroup, 514);
        verticalSeparator.setLayoutData((Object)layoutData);
        Label darkRedForeground = new Label((Composite)legendGroup, 2048);
        darkRedForeground.setText("xx.xx");
        darkRedForeground.setForeground(Display.getDefault().getSystemColor(4));
        Label darkRedLabel = new Label((Composite)legendGroup, 2048);
        darkRedLabel.setText("ct0 >= lowerThreshold or absent");
        verticalSeparator = new Label((Composite)legendGroup, 514);
        verticalSeparator.setLayoutData((Object)layoutData);
        Label magentaBackground = new Label((Composite)legendGroup, 2048);
        magentaBackground.setText("xx.xx");
        magentaBackground.setBackground(Display.getDefault().getSystemColor(11));
        Label magentaLabel = new Label((Composite)legendGroup, 2048);
        magentaLabel.setText("Value averaged by calculations");
    }

    public void refresh() {
        if (this.table != null) {
            this.table.refresh();
        }
    }
}

