/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.commands;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.qrtpcr.dialogs.UploadDataWizard;
import org.grits.toolbox.entry.qrtpcr.editor.QrtPCRTableEditor;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneData;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRRun;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRTable;
import org.grits.toolbox.entry.qrtpcr.property.QrtPCRProperty;
import org.grits.toolbox.entry.qrtpcr.util.FileUtils;

public class AddReRunData {
    private static final Logger logger = Logger.getLogger(AddReRunData.class);
    @Inject
    private static IGritsDataModelService gritsDataModelService = null;
    @Inject
    static IGritsUIService gritsUIService = null;

    @Execute
    public Object execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object object, @Named(value="activeShell") @Named(value="activeShell") Shell shell, @Named(value="e4ActivePart") @Named(value="e4ActivePart") MPart part) throws ExecutionException {
        logger.debug((Object)"BEGIN AddReRunData");
        Entry selectedEntry = null;
        if (object instanceof Entry) {
            selectedEntry = (Entry)object;
        } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
            selectedEntry = (Entry)((StructuredSelection)object).getFirstElement();
        }
        if (selectedEntry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
            selectedEntry = (Entry)gritsDataModelService.getLastSelection().getFirstElement();
        }
        if (!(selectedEntry == null || selectedEntry.getProperty() != null && "org.grits.toolbox.property.qrtpcr".equals(selectedEntry.getProperty().getType()))) {
            selectedEntry = null;
        }
        if (selectedEntry != null) {
            QrtPCRProperty prop = (QrtPCRProperty)selectedEntry.getProperty();
            String filename = prop.getFilename();
            try {
                QrtPCRRun pcrRun = FileUtils.loadQrtPCRRun(selectedEntry, filename);
                UploadDataWizard wizard = new UploadDataWizard();
                wizard.setSampleEntry(selectedEntry.getParent());
                wizard.setForReRerun(true);
                wizard.setMasterListFile(pcrRun.getGeneListFile());
                wizard.setEntryName(selectedEntry.getDisplayName());
                WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
                if (wizardDialog.open() == 0) {
                    logger.debug((Object)"qrtPCR Wizard - Add Re-run: Ok pressed");
                    QrtPCRTable originalTable = pcrRun.getFirstRun();
                    QrtPCRTable newTable = wizard.getTable();
                    newTable.setOriginal(true);
                    pcrRun.addRun(newTable);
                    this.addRerunValues(shell, originalTable, newTable);
                    if (part != null && part.getObject() instanceof QrtPCRTableEditor) {
                        for (String plateId : newTable.getPlateDataMap().keySet()) {
                            ((QrtPCRTableEditor)part.getObject()).addPlatePage(pcrRun.getRunId(), plateId, newTable.getInstrumentFileMap().get(plateId), true);
                        }
                        part.getContext().set(QrtPCRRun.class, (Object)pcrRun);
                        ((QrtPCRTableEditor)part.getObject()).refreshInput(pcrRun);
                        ((QrtPCRTableEditor)part.getObject()).markDirty();
                    }
                }
            }
            catch (JAXBException e) {
                logger.error((Object)"Error adding qrtPCR rerun Data", (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Error adding qrtPCR rerun Data", (Exception)((Object)e));
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"Error adding qrtPCR rerun Data", (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Error adding qrtPCR rerun Data", (Exception)e);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"Error loading qrtPCR Data", (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Error adding qrtPCR rerun Data", (Exception)e);
            }
        }
        logger.debug((Object)"END AddReRunData");
        return selectedEntry;
    }

    private void addRerunValues(Shell shell, QrtPCRTable table, QrtPCRTable newTable) {
        ArrayList<String> errorGenes = new ArrayList<String>();
        for (QrtPCRData data : newTable.getPlateDataMap().values()) {
            data.calculateNormValue();
            List<Gene> reRunGenes = data.getGenes();
            for (Gene gene : reRunGenes) {
                if (this.addReRunToGene(gene, table)) continue;
                errorGenes.add(gene.getGeneIdentifier());
            }
        }
        if (!errorGenes.isEmpty()) {
            logger.warn((Object)("Cannot find corresponding genes for: " + errorGenes.toArray()));
            ErrorUtils.createErrorMessageBox((Shell)shell, (String)("Cannot find corresponding genes for: " + errorGenes.toArray()));
        }
    }

    private boolean addReRunToGene(Gene reRunGene, QrtPCRTable table) {
        for (QrtPCRData data : table.getPlateDataMap().values()) {
            List<Gene> genes = data.getGenes();
            for (Gene gene : genes) {
                if (reRunGene.getGeneIdentifier() == null || gene.getGeneIdentifier() == null || !gene.getGeneIdentifier().equals(reRunGene.getGeneIdentifier())) continue;
                if (!gene.getIsControl().booleanValue() && !gene.getIsCommon().booleanValue()) {
                    List<GeneData> newGeneDataList = reRunGene.getDataMap().get(0);
                    ArrayList<GeneData> newGeneDataCopy = new ArrayList<GeneData>();
                    for (GeneData geneData : newGeneDataList) {
                        geneData.setGene(reRunGene);
                        GeneData geneDataCopy = new GeneData(geneData);
                        newGeneDataCopy.add(geneDataCopy);
                        geneDataCopy.setGene(gene);
                    }
                    gene.addGeneDataList(newGeneDataCopy);
                    gene.getNormValueMap().put(gene.getRunId(), reRunGene.getNormValue(0));
                    gene.setReRun(true);
                    return true;
                }
                return true;
            }
        }
        return false;
    }
}

