/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.Map;
import org.eurocarbdb.application.glycanbuilder.GWSParser;
import org.eurocarbdb.application.glycanbuilder.GlycanParser;
import org.eurocarbdb.application.glycanbuilder.GlycoCTParser;
import org.eurocarbdb.application.glycanbuilder.GlycoMindsParser;
import org.eurocarbdb.application.glycanbuilder.LinucsParser;
import org.eurocarbdb.application.glycanbuilder.MolecularFrameworkParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlycanParserFactory {
    public static Map<String, String> getImportFormats() {
        return GlycanParserFactory.getImportFormats(false);
    }

    public static Map<String, String> getImportFormats(boolean add_internal) {
        Map<String, String> ret = MolecularFrameworkParser.getImportFormats();
        if (add_internal) {
            ret.put("GWS", "GlycoWorkbench sequence");
        }
        ret.put("glycominds", "Glycominds");
        ret.put("gwlinucs", "Linucs");
        return ret;
    }

    public static Map<String, String> getExportFormats() {
        Map<String, String> ret = MolecularFrameworkParser.getExportFormats();
        ret.put("glycominds", "Glycominds");
        return ret;
    }

    public static Map<String, String> getFormats() {
        Map<String, String> ret = MolecularFrameworkParser.getFormats();
        ret.put("GWS", "GlycoWorkbench sequence");
        ret.put("glycominds", "Glycominds");
        ret.put("gwlinucs", "Linucs");
        return ret;
    }

    public static boolean isSequenceFormat(String format) {
        return GlycanParserFactory.getFormats().containsKey(format);
    }

    public static GlycanParser getParser(String format) throws Exception {
        if (MolecularFrameworkParser.isSequenceFormat(format)) {
            return new MolecularFrameworkParser(format);
        }
        if (format.compareToIgnoreCase("gws") == 0) {
            return new GWSParser();
        }
        if (format.compareToIgnoreCase("gwlinucs") == 0) {
            return new LinucsParser();
        }
        if (format.compareToIgnoreCase("glycominds") == 0) {
            return new GlycoMindsParser();
        }
        if (format.compareToIgnoreCase("glycoct") == 0) {
            return new GlycoCTParser(false);
        }
        if (format.compareToIgnoreCase("glycoct_condensed") == 0) {
            return new GlycoCTParser(false);
        }
        throw new Exception("Unsupported format-" + format + "-");
    }

    public static GlycanParser getParser(GlycanSequenceFormat glycanSequenceFormat) throws Exception {
        return GlycanParserFactory.getParser(glycanSequenceFormat.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GlycanSequenceFormat {
        GWS("gws"),
        GlycoMinds("Glycominds"),
        GwLinucs("Linucs");

        String format;

        private GlycanSequenceFormat(String format) {
            this.format = format;
        }

        public String toString() {
            return this.format;
        }
    }
}

