/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import org.eurocarbdb.application.glycanbuilder.GlycanSelection;
import org.eurocarbdb.application.glycanbuilder.ImageTransferable;

public class ClipUtils {
    protected static final Clipboard local_clipboard = new Clipboard("GWB");

    private ClipUtils() {
    }

    public static void setContents(Transferable t) {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(t, null);
        }
        catch (SecurityException se) {
            local_clipboard.setContents(t, null);
        }
    }

    public static void setContents(BufferedImage img) {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new ImageTransferable(img), null);
        }
        catch (SecurityException se) {
            local_clipboard.setContents(new ImageTransferable(img), null);
        }
    }

    public static Transferable getContents() {
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        }
        catch (SecurityException se) {
            return local_clipboard.getContents(null);
        }
    }

    public static void showFlavors(Transferable t) {
        DataFlavor[] flavors = t.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            System.out.println(flavors[i].getMimeType() + ": " + flavors[i].getHumanPresentableName());
        }
    }

    static {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new GlycanSelection(null, null), null);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

