/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.eurocarbdb.application.glycanbuilder.EurocarbResizableIcon;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import test.common.IconWrapperResizableIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionManager {
    protected HashMap<String, GlycanAction> theActions = new HashMap();

    public Collection<GlycanAction> actions() {
        return this.theActions.values();
    }

    public GlycanAction get(String action) {
        return this.theActions.get(action);
    }

    public GlycanAction add(String action, EurocarbResizableIcon i, String label, int mnemonic, String accelerator, ActionListener l) {
        GlycanAction a;
        if (i == null) {
            i = ThemeManager.getResizableEmptyIcon(ICON_SIZE.L1);
        }
        if ((a = this.theActions.get(action)) == null) {
            a = new GlycanAction(action, i, label, mnemonic, accelerator, l);
        } else {
            a.init(action, i, label, mnemonic, accelerator, l);
        }
        this.theActions.put(action, a);
        return a;
    }

    public GlycanAction add(GlycanAction parent, String action, int mnemonic, String accelerator, ActionListener l) {
        GlycanAction toadd = new GlycanAction(parent, action, mnemonic, accelerator, l);
        this.theActions.put(toadd.getActionCommand(), toadd);
        return toadd;
    }

    public void update(String action, EurocarbResizableIcon i, String label, int mnemonic, String accelerator) {
        GlycanAction a = this.theActions.get(action);
        if (a != null) {
            a.init(action, i, label, mnemonic, accelerator, null);
        }
    }

    public void add(String action, ImageIcon icon, String label, int mnemonic, String accelerator, ActionListener l) {
        EurocarbResizableIcon iconR;
        if (icon == null) {
            iconR = ThemeManager.getResizableEmptyIcon(ICON_SIZE.L1);
        } else {
            iconR = new EurocarbResizableIcon();
            iconR.iconProperties = null;
            iconR.resizableIcon = new IconWrapperResizableIcon((Icon)icon);
        }
        GlycanAction a = this.theActions.get(action);
        if (a == null) {
            a = new GlycanAction(action, iconR, label, mnemonic, accelerator, l);
        } else {
            a.init(action, iconR, label, mnemonic, accelerator, l);
        }
        this.theActions.put(action, a);
    }

    public void add(String action, Icon icon, String label, int mnemonic, String accelerator, ActionListener l) {
        EurocarbResizableIcon iconR;
        if (icon == null) {
            iconR = ThemeManager.getResizableEmptyIcon(ICON_SIZE.L1);
        } else {
            iconR = new EurocarbResizableIcon();
            iconR.iconProperties = null;
            iconR.resizableIcon = new IconWrapperResizableIcon(icon);
        }
        GlycanAction a = this.theActions.get(action);
        if (a == null) {
            a = new GlycanAction(action, iconR, label, mnemonic, accelerator, l);
        } else {
            a.init(action, iconR, label, mnemonic, accelerator, l);
        }
        this.theActions.put(action, a);
    }
}

