/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer;

import java.util.ArrayList;
import java.util.Collections;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.util.comparater.GlyCoModificationComparater;
import org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer.MAPAnalyzer;
import org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer.SkeletonCodeToStereo;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.util.oldUtil.ConverterExchangeException;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.BackboneCarbon;
import org.glycoinfo.WURCSFramework.wurcs.graph.CarbonDescriptor;
import org.glycoinfo.WURCSFramework.wurcs.graph.LinkagePosition;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationAlternative;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationRepeat;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class BackboneToNode {
    public Node start(Backbone _backbone) throws GlycanException, WURCSFormatException, ConverterExchangeException {
        Monosaccharide ret = new Monosaccharide();
        this.checkForCarbonDescriptor(_backbone);
        if (_backbone.hasUnknownLength()) {
            ret.setSuperClass(SuperClass.SUG);
        } else {
            ret.setSuperClass(SuperClass.forSize(_backbone.getLength()));
        }
        AnomericStateDescriptor enumAnom = this.parseAnomericState(_backbone);
        ret.setAnomer(enumAnom);
        int anomericposition = _backbone.getAnomericPosition();
        ret.setAnomericPosition(anomericposition);
        SkeletonCodeToStereo sc2s = new SkeletonCodeToStereo();
        ret.setStereos(sc2s.start(_backbone));
        this.extractRingPosition(_backbone, ret);
        ret.setModification(this.extractModification(ret, _backbone));
        this.extractSubstituent(_backbone, ret);
        return ret;
    }

    private ArrayList<GlyCoModification> extractModification(Monosaccharide _mono, Backbone _backbone) throws GlycanException {
        ArrayList<GlyCoModification> ret = new ArrayList<GlyCoModification>();
        String skeletonCode = _backbone.getSkeletonCode();
        for (int i = 0; i < skeletonCode.length(); ++i) {
            char carbon = skeletonCode.charAt(i);
            ModificationTemplate modT = ModificationTemplate.forCarbon(carbon);
            if (carbon == 'o') {
                modT = i == 0 || i == skeletonCode.length() - 1 ? ModificationTemplate.ALDEHYDE : ModificationTemplate.KETONE;
            }
            if (i != 0 && (carbon == 'O' || carbon == 'a')) {
                modT = ModificationTemplate.KETONE_U;
            }
            if (i == _mono.getSuperClass().getSize() - 1 && carbon == 'A') {
                modT = ModificationTemplate.URONICACID;
            }
            if (modT == null) continue;
            GlyCoModification mod = new GlyCoModification(modT, i + 1);
            ret.add(mod);
            if (!modT.equals((Object)ModificationTemplate.KETONE) && !modT.equals((Object)ModificationTemplate.KETONE_U) || i + 1 == _mono.getSuperClass().getSize()) continue;
            boolean haveMod = false;
            for (GlyCoModification gMod : ret) {
                if (gMod.getPositionOne() != 1) continue;
                haveMod = true;
                break;
            }
            if (haveMod) continue;
            mod = new GlyCoModification(modT, 1);
            ret.add(mod);
        }
        for (WURCSEdge we : _backbone.getChildEdges()) {
            Modification mod = we.getModification();
            if (mod.isRing() || mod.isGlycosidic() || mod instanceof ModificationRepeat || mod.getParentEdges().size() != 1 || !mod.getMAPCode().equals("*")) continue;
            ModificationTemplate modT = ModificationTemplate.DEOXY;
            GlyCoModification gmod = new GlyCoModification(modT, 0);
            ret.add(gmod);
        }
        ret.sort(new GlyCoModificationComparater());
        return ret;
    }

    private void extractSubstituent(Backbone _backbone, Monosaccharide _mono) throws GlycanException, ConverterExchangeException, WURCSFormatException {
        ArrayList<Modification> tempMods = new ArrayList<Modification>();
        for (WURCSEdge we : _backbone.getChildEdges()) {
            Modification mod = we.getModification();
            if (mod.isRing() || mod.isGlycosidic() || mod instanceof ModificationRepeat || mod.getMAPCode().equals("*")) continue;
            if (mod.getParentEdges().size() == 1) {
                _mono = this.appendSubstituent(_mono, this.ModificationToSubstituent(_backbone, mod));
            }
            if (mod.getParentEdges().size() == 2) {
                if (tempMods.contains(mod)) continue;
                _mono = this.appendSubstituent(_mono, this.ModificationToCyclicSubstituent(mod));
                tempMods.add(mod);
            }
            if (mod.getParentEdges().size() <= 2 || mod instanceof ModificationAlternative) continue;
            throw new GlycanException(mod.getMAPCode() + " have more than two anchors.");
        }
    }

    private Substituent ModificationToSubstituent(Backbone _backbone, Modification _mod) throws ConverterExchangeException, WURCSFormatException {
        MAPAnalyzer mapAnalyze = new MAPAnalyzer();
        mapAnalyze.start(_mod.getMAPCode());
        BaseSubstituentTemplate bsubT = mapAnalyze.getSingleTemplate();
        Linkage lin = new Linkage();
        if (bsubT == null) {
            throw new ConverterExchangeException("This substituent could not support: " + _mod.getMAPCode());
        }
        if (bsubT.getIUPACnotation().equals("")) {
            throw new ConverterExchangeException("This substituent could not support: " + _mod.getMAPCode());
        }
        for (WURCSEdge we : _mod.getParentEdges()) {
            for (LinkagePosition lp : we.getLinkages()) {
                lin.addParentLinkage(lp.getBackbonePosition());
                lin.addChildLinkage(lp.getModificationPosition());
                lin.setProbabilityUpper(lp.getProbabilityUpper());
                lin.setProbabilityLower(lp.getProbabilityLower());
            }
        }
        Substituent ret = new Substituent(bsubT, lin);
        ret.setHeadAtom(mapAnalyze.getHeadAtom());
        if (_backbone.hasUnknownLength()) {
            return ret;
        }
        if (!ret.getHeadAtom().equals("O") && lin.getParentLinkages().size() == 1 && !lin.getParentLinkages().contains(-1)) {
            int pos = lin.getParentLinkages().get(0);
            if (((BackboneCarbon)_backbone.getBackboneCarbons().get(pos - 1)).getDescriptor().equals(CarbonDescriptor.SS3_CHIRAL_X_U) || ((BackboneCarbon)_backbone.getBackboneCarbons().get(pos - 1)).getDescriptor().equals(CarbonDescriptor.SS3_CHIRAL_R_U) || ((BackboneCarbon)_backbone.getBackboneCarbons().get(pos - 1)).getDescriptor().equals(CarbonDescriptor.SS3_CHIRAL_r_U) || ((BackboneCarbon)_backbone.getBackboneCarbons().get(pos - 1)).getDescriptor().equals(CarbonDescriptor.SS3_CHIRAL_S_U) || ((BackboneCarbon)_backbone.getBackboneCarbons().get(pos - 1)).getDescriptor().equals(CarbonDescriptor.SS3_CHIRAL_s_U)) {
                ret.setHeadAtom("C");
            }
        }
        return ret;
    }

    private Substituent ModificationToCyclicSubstituent(Modification _mod) throws ConverterExchangeException, WURCSFormatException {
        MAPAnalyzer mapAnalyze = new MAPAnalyzer();
        mapAnalyze.start(_mod.getMAPCode().equals("") ? "*O*" : _mod.getMAPCode());
        BaseCrossLinkedTemplate subT = mapAnalyze.getCrossTemplate();
        Linkage first = new Linkage();
        Linkage second = new Linkage();
        if (subT == null) {
            throw new ConverterExchangeException("This substituent could not support: " + _mod.getMAPCode());
        }
        if (subT.getIUPACnotation().equals("")) {
            throw new ConverterExchangeException("This substituent could not support: " + _mod.getMAPCode());
        }
        for (WURCSEdge we : _mod.getParentEdges()) {
            if (_mod.getParentEdges().size() - 1 != _mod.getParentEdges().indexOf(we)) {
                for (LinkagePosition lp : we.getLinkages()) {
                    first.addParentLinkage(lp.getBackbonePosition());
                    first.addChildLinkage(lp.getModificationPosition());
                    first.setProbabilityUpper(lp.getProbabilityUpper());
                    first.setProbabilityLower(lp.getProbabilityLower());
                }
                continue;
            }
            for (LinkagePosition lp : we.getLinkages()) {
                second.addParentLinkage(lp.getBackbonePosition());
                second.addChildLinkage(lp.getModificationPosition());
                second.setProbabilityUpper(lp.getProbabilityUpper());
                second.setProbabilityLower(lp.getProbabilityLower());
            }
        }
        Substituent ret = new Substituent(subT, first, second);
        ret.setHeadAtom(mapAnalyze.getHeadAtom());
        ret.setTailAtom(mapAnalyze.getTailAtom());
        return ret;
    }

    private AnomericStateDescriptor parseAnomericState(Backbone _backbone) {
        AnomericStateDescriptor anomDesc;
        String skeletonCode = _backbone.getSkeletonCode();
        char anomericState = _backbone.getAnomericSymbol();
        if (_backbone.getAnomericPosition() == 0) {
            if (skeletonCode.indexOf("o") == 0 || skeletonCode.indexOf("O") == 1) {
                return AnomericStateDescriptor.OPEN;
            }
            if (skeletonCode.indexOf("u") == 0 || skeletonCode.indexOf("U") == 1) {
                return AnomericStateDescriptor.OPEN;
            }
            if (skeletonCode.indexOf("h") == 0) {
                return AnomericStateDescriptor.OPEN;
            }
        }
        if ((anomDesc = AnomericStateDescriptor.forAnomericState(anomericState)) == null) {
            return AnomericStateDescriptor.UNKNOWN_STATE;
        }
        return anomDesc;
    }

    private Monosaccharide appendSubstituent(Node _node, Node _substituent) throws GlycanException {
        Linkage linkage;
        Edge subEdge = new Edge();
        subEdge.setSubstituent(_substituent);
        subEdge.setParent(_node);
        _node.addChildEdge(subEdge);
        _substituent.addParentEdge(subEdge);
        Substituent sub = (Substituent)_substituent;
        if (sub.getFirstPosition() != null) {
            linkage = new Linkage();
            linkage.setChildLinkages(sub.getFirstPosition().getChildLinkages());
            linkage.setParentLinkages(sub.getFirstPosition().getParentLinkages());
            subEdge.addGlycosidicLinkage(linkage);
        }
        if (sub.getSecondPosition() != null) {
            linkage = new Linkage();
            linkage.setChildLinkages(sub.getSecondPosition().getChildLinkages());
            linkage.setParentLinkages(sub.getSecondPosition().getParentLinkages());
            subEdge.addGlycosidicLinkage(linkage);
        }
        return (Monosaccharide)_node;
    }

    private void extractRingPosition(Backbone _backbone, Monosaccharide _mono) throws GlycanException {
        int anomericPos = _backbone.getAnomericPosition();
        ArrayList<Integer> ring = new ArrayList<Integer>();
        int start = -1;
        for (WURCSEdge cwe : _backbone.getChildEdges()) {
            Modification mod = cwe.getModification();
            if (!mod.isRing()) continue;
            for (LinkagePosition lp : cwe.getLinkages()) {
                if (anomericPos == lp.getBackbonePosition()) {
                    start = lp.getBackbonePosition();
                    continue;
                }
                ring.add(lp.getBackbonePosition());
            }
        }
        if (ring.isEmpty()) {
            if (_mono.getAnomer().equals((Object)AnomericStateDescriptor.OPEN)) {
                _mono.setRing(0, 0);
            } else if (!_backbone.hasUnknownLength()) {
                throw new GlycanException("GlycanFormatConverter can not handle a monosaccharide having anomer without ring position.");
            }
        } else {
            Collections.sort(ring);
            int end = (Integer)ring.get(0);
            if (ring.size() > 1) {
                throw new GlycanException("GlycanFormatConverter can not handle multiple ring structure.");
            }
            if (start == 1 && end != 4 && end != 5 && end != -1) {
                throw new GlycanException("GlycanFormatConverter can not handle this ring end : " + end);
            }
            if (start == 2 && end != 5 && end != 6 && end != -1) {
                throw new GlycanException("GlycanFormatConverter can not handle this ring end : " + end);
            }
            _mono.setRing(start, (Integer)ring.get(0));
        }
    }

    private void checkForCarbonDescriptor(Backbone _backbone) throws WURCSFormatException {
        for (BackboneCarbon bc : _backbone.getBackboneCarbons()) {
            if (bc.getDescriptor().equals(CarbonDescriptor.SZ3_ACETAL_L)) {
                throw new WURCSFormatException("GlycanFormatConverter can not handle acetal : " + bc.getDescriptor().getChar());
            }
            if (bc.getDescriptor().equals(CarbonDescriptor.SZ3_ACETAL_U)) {
                throw new WURCSFormatException("GlycanFormatConverter can not handle acetal : " + bc.getDescriptor().getChar());
            }
            if (!bc.getDescriptor().equals(CarbonDescriptor.SS3_ACETAL)) continue;
            throw new WURCSFormatException("GlycanFormatConverter can not handle acetal : " + bc.getDescriptor().getChar());
        }
    }
}

