/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.LinearCode;

public enum LinearCodeSUDictionary {
    GLC("Glc", "", "Glc", "G", 1),
    GAL("Gal", "", "Gal", "A", 2),
    GLCNAC("Glc", "2NAc", "GlcNAc", "GN", 3),
    GALNAC("Gal", "2NAc", "GalNAc", "AN", 4),
    MAN("Man", "", "Man", "M", 5),
    NEUAC("Neu", "5Ac", "Neu5Ac", "NN", 6),
    NEU("Neu", "", "Neu", "N", 7),
    KDN("Kdn", "", "Kdn", "K", 8),
    KDO("Kdo", "", "Kdo", "W", 9),
    GALA("Gal", "6A", "GalA", "L", 10),
    IDO("Ido", "", "Ido", "I", 11),
    RHA("Rha", "", "Rha", "H", 12),
    FUC("Fuc", "", "Fuc", "F", 13),
    XYL("Xyl", "", "Xyl", "X", 14),
    Rib("Rib", "", "Rib", "B", 15),
    ARA("Ara", "", "Ara", "R", 16),
    GLCA("Glc", "6A", "GlcA", "U", 17),
    ALL("All", "", "ALl", "O", 18),
    API("Api", "", "Api", "P", 19),
    FRU("Fru", "", "Fru", "E", 20),
    NEUGC("Neu", "5Gc", "Neu5Gc", "NJ", 21),
    HEX("Hex", "", "", "Z", 97),
    HEXNAC("Hex", "2NAc", "HexNAc", "ZN", 98);

    private String iupacThreeLetter;
    private String nativeSubstituents;
    private String trivialName;
    private String linearCode;
    private int hierarchy;

    public String getIupacThreeLetter() {
        return this.iupacThreeLetter;
    }

    public String getNativeSubstituents() {
        return this.nativeSubstituents;
    }

    public String getLinearCode() {
        return this.linearCode;
    }

    public int getHierarchy() {
        return this.hierarchy;
    }

    private LinearCodeSUDictionary(String _iupacThreeLetter, String _nativeSubstituents, String _trivialName, String _linearCode, int _hierarchy) {
        this.iupacThreeLetter = _iupacThreeLetter;
        this.nativeSubstituents = _nativeSubstituents;
        this.trivialName = _trivialName;
        this.linearCode = _linearCode;
        this.hierarchy = _hierarchy;
    }

    public static LinearCodeSUDictionary forLinearCode(String _linearCode) {
        for (LinearCodeSUDictionary ind : LinearCodeSUDictionary.values()) {
            if (!ind.linearCode.equals(_linearCode)) continue;
            return ind;
        }
        return null;
    }

    public static LinearCodeSUDictionary forTrivialName(String _trivialName) {
        for (LinearCodeSUDictionary ind : LinearCodeSUDictionary.values()) {
            if (!ind.trivialName.equals(_trivialName)) continue;
            return ind;
        }
        return null;
    }
}

