/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.KCF;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;
import org.glycoinfo.GlycanFormatconverter.io.KCF.KCFMonosaccharideDescriptor;
import org.glycoinfo.GlycanFormatconverter.io.KCF.KCFNodeStateStacker;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.BaseStereoIndex;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.CoreSubstituentMonosaccharide;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.PrefixDescriptor;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameException;
import org.glycoinfo.GlycanFormatconverter.util.analyzer.IUPACSubstituentNotationAnalyzer;
import org.glycoinfo.GlycanFormatconverter.util.analyzer.MonosaccharideNotationAnalyzer;

public class KCFNotationToIUPACNotation {
    /*
     * WARNING - void declaration
     */
    public String start(String _input) throws GlyCoImporterException, GlycanException, TrivialNameException {
        Matcher matHead;
        Matcher matUlo;
        Matcher matDeoxy;
        Matcher unsat;
        Matcher matAnhydro;
        KCFNodeStateStacker kcfStacker = new KCFNodeStateStacker();
        String ringSize = "";
        KCFMonosaccharideDescriptor firstUnit = null;
        KCFMonosaccharideDescriptor secondUnit = null;
        ArrayList<String> subs = new ArrayList<String>();
        ArrayList<String> mods = new ArrayList<String>();
        if (!MonosaccharideNotationAnalyzer.start(_input)) {
            throw new GlyCoImporterException(_input + " is not found!");
        }
        Matcher prefixSub = Pattern.compile("(\\d)-([CO])-([Ff]ormyl|[Mm]ethyl)").matcher(_input);
        if (prefixSub.find()) {
            BaseSubstituentTemplate subT;
            String atomType = "";
            if (prefixSub.group(2) != null && prefixSub.group(2).equals("C")) {
                atomType = "C";
            }
            if (prefixSub.group(3).equalsIgnoreCase("formyl")) {
                subT = BaseSubstituentTemplate.OFORMYL;
                subs.add(prefixSub.group(1) + atomType + subT.getIUPACnotation());
                _input = _input.replace(prefixSub.group(), "");
            }
            if (prefixSub.group(3).equalsIgnoreCase("methyl")) {
                subT = BaseSubstituentTemplate.OMETHYL;
                subs.add(prefixSub.group(1) + atomType + subT.getIUPACnotation());
                _input = _input.replace(prefixSub.group(), "");
            }
        }
        if ((matAnhydro = Pattern.compile("-?(\\d,\\d-Anhydro)-").matcher(_input)).find()) {
            mods.add(matAnhydro.group(1));
            _input = _input.replace(matAnhydro.group(), "");
        }
        if ((unsat = Pattern.compile("-?(\\d)-?(enx|en)-").matcher(_input)).find()) {
            subs.add(unsat.group(1) + "(X)" + unsat.group(2));
            _input = _input.replace(unsat.group(), "");
        }
        if ((matDeoxy = Pattern.compile("([\\d,]+)+((d|-deoxy)-?)+").matcher(_input)).find()) {
            mods.add(this.analyzeDeoxy(matDeoxy.group(1)));
            _input = _input.replace(matDeoxy.group(), "");
        }
        if ((matUlo = Pattern.compile("-?([\\d,]+)-?(.*ulo)").matcher(_input)).find()) {
            for (String unit : matUlo.group(1).split(",")) {
                kcfStacker.setUlosonic(unit + "ulo");
            }
            _input = _input.replace(matUlo.group(), "");
        }
        if ((matHead = Pattern.compile("(-(ol|onic|aric|uronic))").matcher(_input)).find()) {
            kcfStacker.setTailStatus(matHead.group(1));
            _input = _input.replace(matHead.group(), "");
        }
        int count = 0;
        for (KCFMonosaccharideDescriptor kCFMonosaccharideDescriptor : KCFMonosaccharideDescriptor.values()) {
            void var18_24;
            String code = "";
            String config = "";
            if (_input.contains(kCFMonosaccharideDescriptor.getCode())) {
                config = this.extractConfiguration(_input, kCFMonosaccharideDescriptor.getCode());
                ringSize = this.extractRingSize(_input, kCFMonosaccharideDescriptor.getCode());
                code = kCFMonosaccharideDescriptor.getCode();
                _input = _input.replace(config + kCFMonosaccharideDescriptor.getCode() + ringSize, "");
                if (kCFMonosaccharideDescriptor.equals((Object)KCFMonosaccharideDescriptor.THO)) {
                    KCFMonosaccharideDescriptor kCFMonosaccharideDescriptor2 = KCFMonosaccharideDescriptor.THR;
                    code = kCFMonosaccharideDescriptor2.getCode();
                }
                ++count;
            }
            if (_input.contains(var18_24.getCode().toLowerCase())) {
                config = this.extractConfiguration(_input, var18_24.getCode().toLowerCase());
                ringSize = this.extractRingSize(_input, var18_24.getCode().toLowerCase());
                code = var18_24.getCode().toLowerCase();
                _input = _input.replace(config + var18_24.getCode().toLowerCase() + ringSize, "");
                if (var18_24.equals((Object)KCFMonosaccharideDescriptor.THO)) {
                    KCFMonosaccharideDescriptor kCFMonosaccharideDescriptor3 = KCFMonosaccharideDescriptor.THR;
                    code = kCFMonosaccharideDescriptor3.getCode().toLowerCase();
                }
                ++count;
            }
            if (!code.equals("")) {
                void var18_21;
                if (count == 1) {
                    firstUnit = var18_21;
                } else {
                    secondUnit = var18_21;
                }
            }
            if (config.equals("")) continue;
            if (count == 1) {
                kcfStacker.setFisrtConfig(config);
                continue;
            }
            kcfStacker.setSecondConfig(config);
        }
        for (Enum enum_ : SuperClass.values()) {
            if (!_input.contains(((SuperClass)enum_).getSuperClass())) continue;
            ringSize = this.extractRingSize(_input, ((SuperClass)enum_).getSuperClass());
            String config = this.extractConfiguration(_input, ((SuperClass)enum_).getSuperClass());
            kcfStacker.setSuperClass((SuperClass)enum_);
            if (firstUnit == null && secondUnit == null) {
                kcfStacker.setFisrtConfig(config);
            }
            _input = _input.replace(config + ((SuperClass)enum_).getSuperClass() + ringSize, "");
        }
        if (kcfStacker.getFisrtConfig().length() == 2) {
            kcfStacker.setSecondConfig(String.valueOf(kcfStacker.getFisrtConfig().charAt(1)));
            kcfStacker.setFisrtConfig(String.valueOf(kcfStacker.getFisrtConfig().charAt(0)));
            secondUnit = firstUnit;
            String anonymousCode = secondUnit.getCode().toLowerCase();
            int anonymousCarbonSize = kcfStacker.getSuperClass().getSize();
            BaseStereoIndex baseInd = BaseStereoIndex.forCode(anonymousCode);
            if ((anonymousCarbonSize -= baseInd.getSize()) == 1) {
                secondUnit = KCFMonosaccharideDescriptor.GRO;
            } else {
                throw new TrivialNameException("This anonymous monosaccharide size has more than 1 carbon backbone.");
            }
        }
        IUPACSubstituentNotationAnalyzer subAna = new IUPACSubstituentNotationAnalyzer();
        subs.addAll(subAna.resolveSubstituents(this.trimHyphen(_input), true));
        kcfStacker.setRingSize(ringSize);
        kcfStacker.setFisrtUnit(firstUnit);
        kcfStacker.setSecondUnit(secondUnit);
        kcfStacker.setSubstituents(subs);
        kcfStacker.setModifications(mods);
        return this.remodelMonosaccharideNotation(kcfStacker).toString();
    }

    private StringBuilder remodelMonosaccharideNotation(KCFNodeStateStacker _kcfStacker) throws GlyCoImporterException {
        StringBuilder notation = new StringBuilder();
        SuperClass superClass = _kcfStacker.getSuperClass();
        String firstConfig = _kcfStacker.getFisrtConfig();
        String secondConfig = _kcfStacker.getSecondConfig();
        KCFMonosaccharideDescriptor firstUnit = _kcfStacker.getFirstUnit();
        KCFMonosaccharideDescriptor secondUnit = _kcfStacker.getSecondUnit();
        this.appendPrefixAnnotations(notation, _kcfStacker.getModifications());
        if (firstUnit != null) {
            notation = this.appendCoreNotation(notation, this.modifyConfiguration(firstConfig, firstUnit.getCode()), firstUnit, superClass != null);
        }
        if (firstUnit == null && secondUnit == null) {
            notation.append(firstConfig.equals("D/L") || firstConfig.equals("") ? "?" : firstConfig).append("-");
        }
        if (secondUnit != null) {
            notation.append("-?-");
            if (secondConfig.equals("")) {
                secondConfig = this.modifyConfiguration(firstConfig, secondUnit.getCode());
            }
            notation = this.appendCoreNotation(notation, secondConfig, secondUnit, true);
        }
        if (superClass != null) {
            notation.append(superClass.getSuperClass());
        }
        notation.append(_kcfStacker.getUlosonic());
        String ringSize = _kcfStacker.getRingSize();
        if (secondUnit != null) {
            ringSize = this.modifyRingSize(ringSize, secondConfig, secondUnit);
        }
        if (firstUnit != null && secondUnit == null) {
            ringSize = this.modifyRingSize(ringSize, firstConfig, firstUnit);
        }
        if (firstUnit == null && secondUnit == null && superClass != null) {
            ringSize = "p";
        }
        notation.append(ringSize);
        String code = "";
        if (firstUnit != null && secondUnit == null) {
            code = firstUnit.getCode();
        }
        if (secondUnit != null) {
            code = secondUnit.getCode();
        }
        this.appendAcidicStatus(notation, _kcfStacker.getSubstituents(), code);
        notation.append(_kcfStacker.getTailStatus());
        return notation;
    }

    private StringBuilder appendAcidicStatus(StringBuilder _sb, ArrayList<String> _subs, String _code) throws GlyCoImporterException {
        String nativeSub = "";
        CoreSubstituentMonosaccharide hexDesc = CoreSubstituentMonosaccharide.forTrivialName(_code);
        for (String unit : _subs) {
            if (unit.matches("\\d.*")) continue;
            nativeSub = unit;
        }
        if (nativeSub.equals("A") || nativeSub.matches("N(Ac|Fo\\w*)?A") || nativeSub.matches("AN(Ac|Fo\\w*)?")) {
            _subs.remove(nativeSub);
            _sb.append("A");
            if (nativeSub.endsWith("A")) {
                nativeSub = nativeSub.substring(0, nativeSub.length() - 1);
            }
            if (nativeSub.startsWith("A") && !nativeSub.equals("A")) {
                nativeSub = nativeSub.substring(1, nativeSub.length());
            }
            if (!nativeSub.equals("A")) {
                _subs.add(nativeSub);
            }
        }
        String modifiedSub = this.modifySubstituentNotation(nativeSub);
        if (hexDesc != null) {
            if (nativeSub.matches("[GA]c") && hexDesc.equals((Object)CoreSubstituentMonosaccharide.NEU)) {
                _subs.remove(nativeSub);
                _subs.add(5 + modifiedSub);
            }
            if (nativeSub.matches("N[AG]c") && hexDesc.equals((Object)CoreSubstituentMonosaccharide.NEU)) {
                _subs.remove(nativeSub);
                _subs.add(modifiedSub.replaceFirst("N", "5"));
            }
            if (nativeSub.matches("[GA]c") && !hexDesc.equals((Object)CoreSubstituentMonosaccharide.NEU)) {
                _subs.remove(nativeSub);
                _subs.add(2 + modifiedSub);
            }
            if (nativeSub.matches("(?!NAc)N\\w+") && !hexDesc.equals((Object)CoreSubstituentMonosaccharide.NEU)) {
                _subs.remove(nativeSub);
                _subs.add(2 + modifiedSub);
            }
            if ((nativeSub.equals("N") || nativeSub.equals("NAc")) && !hexDesc.equals((Object)CoreSubstituentMonosaccharide.NEU)) {
                _subs.remove(nativeSub);
                _sb.append(modifiedSub);
            }
        } else if (nativeSub.startsWith("N")) {
            _subs.remove(nativeSub);
            _subs.add(2 + modifiedSub);
        }
        LinkedHashMap<String, ArrayList> sortedSubs = new LinkedHashMap<String, ArrayList>();
        Collections.sort(_subs);
        for (String unit : _subs) {
            ArrayList positions;
            Matcher matSub = Pattern.compile("([\\d,]+)+([(\\w]+.*)").matcher(unit);
            if (!matSub.find()) continue;
            String subNode = this.modifySubstituentNotation(matSub.group(2));
            if (!sortedSubs.containsKey(subNode)) {
                positions = new ArrayList();
                positions.add(matSub.group(1));
                sortedSubs.put(subNode, positions);
                continue;
            }
            positions = (ArrayList)sortedSubs.get(subNode);
            positions.add(matSub.group(1));
            sortedSubs.put(subNode, positions);
        }
        for (String key : sortedSubs.keySet()) {
            StringBuilder sub = new StringBuilder();
            Iterator iterPos = ((ArrayList)sortedSubs.get(key)).iterator();
            while (iterPos.hasNext()) {
                sub.append((String)iterPos.next());
                if (!iterPos.hasNext()) continue;
                sub.append(",");
            }
            sub.append(key);
            if (((ArrayList)sortedSubs.get(key)).size() > 1) {
                sub.append(((ArrayList)sortedSubs.get(key)).size());
            }
            _sb.append((CharSequence)sub);
        }
        return _sb;
    }

    private StringBuilder appendCoreNotation(StringBuilder _sb, String _configuration, KCFMonosaccharideDescriptor _kcfDesc, boolean _isLowCase) {
        if (_configuration != null && _kcfDesc != null) {
            _sb.append(_configuration);
            _sb.append("-");
            _sb.append(_isLowCase ? _kcfDesc.getCode().toLowerCase() : _kcfDesc.getCode());
        }
        return _sb;
    }

    private StringBuilder appendPrefixAnnotations(StringBuilder _sb, ArrayList<String> _mods) {
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        for (String unit : _mods) {
            String[] items = unit.split("-");
            sorted.put(items[1], items[0]);
        }
        for (String key : sorted.keySet()) {
            _sb.append((String)sorted.get(key)).append("-").append(key).append("-");
        }
        return _sb;
    }

    private String modifySubstituentNotation(String _subNotation) throws GlyCoImporterException {
        Enum subT;
        if (_subNotation.equals("")) {
            return "";
        }
        if (_subNotation.matches("N?diMe")) {
            _subNotation = _subNotation.replaceFirst("di", "Di");
        }
        if ((subT = BaseSubstituentTemplate.forIUPACNotationWithIgnore(_subNotation)) == null) {
            subT = BaseSubstituentTemplate.forGlycoCTNotationWithIgnore(_subNotation);
        }
        if (subT == null && _subNotation.startsWith("N")) {
            _subNotation = _subNotation.replaceFirst("N", "N-");
            subT = BaseSubstituentTemplate.forGlycoCTNotationWithIgnore(_subNotation);
        }
        if (subT == null) {
            if (_subNotation.equals("Me")) {
                subT = BaseSubstituentTemplate.OMETHYL;
            }
            if (_subNotation.contains("Py") || _subNotation.contains("pyr")) {
                if (_subNotation.equals("Py")) {
                    subT = BaseCrossLinkedTemplate.X_PYRUVATE;
                }
                if (_subNotation.startsWith("(R")) {
                    subT = BaseCrossLinkedTemplate.R_PYRUVATE;
                }
                if (_subNotation.startsWith("(S")) {
                    subT = BaseCrossLinkedTemplate.S_PYRUVATE;
                }
                if (_subNotation.startsWith("Pyr") || _subNotation.startsWith("pyr")) {
                    subT = BaseCrossLinkedTemplate.X_PYRUVATE;
                }
            }
            if (_subNotation.equals("Formyl")) {
                subT = BaseSubstituentTemplate.OFORMYL;
            }
            if (_subNotation.contains("en")) {
                return ModificationTemplate.UNSATURATION_FL.getIUPACnotation();
            }
        }
        if (subT == null) {
            throw new GlyCoImporterException(_subNotation + " is not defined.");
        }
        return subT.getIUPACnotation();
    }

    private String modifyConfiguration(String _configuration, String _notation) {
        if (_configuration.equals("D/L") || _configuration.equals("L/D")) {
            return "?";
        }
        if (_notation.contains("Col") || _notation.contains("Asc")) {
            return "L";
        }
        if (!_configuration.equals("")) {
            return _configuration;
        }
        return "D";
    }

    private String modifyRingSize(String _ringSize, String _config, KCFMonosaccharideDescriptor _kcfDesc) {
        if (!_ringSize.equals("")) {
            return _ringSize;
        }
        if (_kcfDesc.equals((Object)KCFMonosaccharideDescriptor.THR) || _kcfDesc.equals((Object)KCFMonosaccharideDescriptor.ERY) || _kcfDesc.equals((Object)KCFMonosaccharideDescriptor.API) || _kcfDesc.equals((Object)KCFMonosaccharideDescriptor.THO)) {
            return "f";
        }
        return "p";
    }

    private String extractRingSize(String _kcfNotation, String _notation) {
        String ringSize = "";
        Matcher matRing = Pattern.compile(_notation + "([pf?]).*").matcher(_kcfNotation);
        if (matRing.find()) {
            ringSize = matRing.group(1);
        }
        return ringSize;
    }

    private String extractConfiguration(String _kcfNotation, String _notation) {
        String configuration = "";
        Matcher matConfig = Pattern.compile("([DL/?]+)-?" + _notation + ".*").matcher(_kcfNotation);
        if (matConfig.find()) {
            configuration = matConfig.group(1);
        }
        return configuration;
    }

    private String analyzeDeoxy(String _position) throws TrivialNameException {
        PrefixDescriptor preDesc = PrefixDescriptor.forNumber(_position.split(",").length);
        return _position + "-" + preDesc.getPrefix() + "deoxy";
    }

    private String trimHyphen(String _notation) {
        _notation = _notation.replaceAll("-", "");
        return _notation;
    }
}

