/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC.condensed;

import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACNotationConverter;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.MonosaccharideIndex;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameException;

public class CondensedConverter
extends IUPACNotationConverter {
    public String start(Node _node) throws GlycanException, TrivialNameException {
        Node copy = _node.copy();
        this.makeTrivialName(copy);
        return this.makeCondensedNotation(copy);
    }

    private String makeCondensedNotation(Node _copy) throws TrivialNameException {
        Monosaccharide mono = (Monosaccharide)_copy;
        String threeLetter = this.getThreeLetterCode();
        String configuration = "?";
        if (!mono.getStereos().isEmpty()) {
            configuration = this.makeConfiguration(mono.getStereos().getFirst()).toUpperCase();
        }
        StringBuilder ret = new StringBuilder(threeLetter);
        MonosaccharideIndex monoInd = MonosaccharideIndex.forTrivialNameWithIgnore(threeLetter);
        if (monoInd != null && !monoInd.getFirstConfiguration().endsWith(configuration)) {
            ret.insert(0, configuration + "-");
        }
        if (monoInd == null && mono.getStereos().size() != 2) {
            ret.insert(0, configuration + "-");
        }
        String deoxyNotation = this.makeDeoxyPosition(mono);
        if (!ret.toString().contains(deoxyNotation)) {
            ret.insert(0, deoxyNotation);
        }
        ret.insert(0, this.getSubConv().getPrefixSubstituent());
        ret.append(this.extractUlonic(mono));
        String ringSize = this.defineRingSize(_copy);
        if (monoInd != null) {
            if (!monoInd.getRingSize().equals(ringSize)) {
                ret.append(ringSize);
            }
        } else {
            ret.append(ringSize);
        }
        ret.append(this.getSubConv().getCoreSubstituentNotaiton());
        String acidicStatus = this.makeAcidicStatus(_copy);
        if (acidicStatus.equals("A")) {
            ret.append(acidicStatus);
        }
        ret.append(this.getSubConv().getSubstituentNotation());
        if (!acidicStatus.equals("A") && !this.containUlonicAcid(this.getThreeLetterCode())) {
            ret.append(acidicStatus);
        }
        if (this.isAlditol(_copy)) {
            ret.append("-ol");
        }
        if (this.isAldose(_copy)) {
            ret.insert(0, "aldehyde-");
        }
        if (this.isKetose(_copy)) {
            ret.insert(0, "keto-");
        }
        return ret.toString();
    }
}

