/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.views.tabbed.content;

import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.Molecule;
import org.grits.toolbox.ms.om.data.MoleculeSettings;

public class AnnotationSettingsTableComposite
extends Composite {
    protected Method method;

    public AnnotationSettingsTableComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        this.setLayout((Layout)layout);
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void createGeneralSettingsTable() {
        Label label = new Label((Composite)this, 0);
        label.setText("Method Settings");
        TableViewer settingsTableViewer = new TableViewer((Composite)this, 67584);
        Table settingsTable = settingsTableViewer.getTable();
        GridData gd_table_2 = new GridData(4, 4, true, true, 1, 1);
        gd_table_2.heightHint = 150;
        settingsTable.setLayoutData((Object)gd_table_2);
        settingsTable.setHeaderVisible(true);
        settingsTable.setLinesVisible(true);
        TableViewerColumn nameColumn = new TableViewerColumn(settingsTableViewer, 0);
        TableColumn dColumn = nameColumn.getColumn();
        dColumn.setText("Setting");
        dColumn.setWidth(200);
        TableViewerColumn valueColumn = new TableViewerColumn(settingsTableViewer, 0);
        valueColumn.getColumn().setText("Value");
        valueColumn.getColumn().setWidth(150);
        this.addData(settingsTable);
    }

    private void addData(Table settingsTable) {
        String sText;
        String msType;
        TableItem item = new TableItem(settingsTable, 0);
        String string = msType = this.method.getMsType() != null ? this.method.getMsType() : "";
        if (!msType.isEmpty()) {
            msType = Method.getMsLabelByType((String)msType);
        }
        item.setText(new String[]{"MS Type", msType});
        item = new TableItem(settingsTable, 0);
        item.setText(new String[]{"Mass Type", this.method.getMonoisotopic() != false ? "Monoisotopic" : "Average"});
        item = new TableItem(settingsTable, 0);
        String string2 = sText = this.method.getAccuracy() != null ? this.method.getAccuracy().toString() : null;
        sText = sText != null ? String.valueOf(sText) + " " + (this.method.getAccuracyPpm() != false ? "ppm" : "Da") : "";
        item.setText(new String[]{"Precursor Accuracy", sText});
        item = new TableItem(settingsTable, 0);
        String string3 = sText = this.method.getAccuracy() != null ? this.method.getFragAccuracy().toString() : null;
        sText = sText != null ? String.valueOf(sText) + " " + (this.method.getFragAccuracyPpm() != false ? "ppm" : "Da") : "";
        item.setText(new String[]{"Fragment Accuracy", sText});
        item = new TableItem(settingsTable, 0);
        String[] stringArray = new String[2];
        stringArray[0] = "Trust Charge";
        stringArray[1] = this.method.getTrustMzCharge() != null ? (this.method.getTrustMzCharge().booleanValue() ? "Yes" : "No") : null;
        item.setText(stringArray);
        item = new TableItem(settingsTable, 0);
        item.setText(new String[]{"Shift", this.method.getShift() != null ? this.method.getShift().toString() : null});
        item = new TableItem(settingsTable, 0);
        item.setText(new String[]{"Fragment Intensity Cutoff", this.method.getIntensityCutoff() != null ? this.method.getIntensityCutoff().toString() : ""});
        item = new TableItem(settingsTable, 0);
        item.setText(new String[]{"Precursor Intensity Cutoff", this.method.getPrecursorIntensityCutoff() != null ? this.method.getPrecursorIntensityCutoff().toString() : ""});
        item = new TableItem(settingsTable, 0);
        item.setText(new String[]{"Fragment Intensity Cutoff Type", this.method.getIntensityCutoffType() != null ? this.method.getIntensityCutoffType().toString() : ""});
        item = new TableItem(settingsTable, 0);
        item.setText(new String[]{"Precursor Intensity Cutoff Type", this.method.getPrecursorIntensityCutoffType() != null ? this.method.getPrecursorIntensityCutoffType().toString() : ""});
        item = new TableItem(settingsTable, 0);
        item.setText(new String[]{"Max Ion Count", this.method.getMaxIonCount() != null ? this.method.getMaxIonCount().toString() : ""});
        item = new TableItem(settingsTable, 0);
        item.setText(new String[]{"Max Ion Exchange Count", this.method.getMaxIonExchangeCount() != null ? this.method.getMaxIonExchangeCount().toString() : ""});
    }

    public void createIonsTable() {
        Label label = new Label((Composite)this, 0);
        label.setText("Ions");
        if (this.method.getIons() != null) {
            this.createMoleculeTable(true, this.method.getIons());
        }
    }

    public void createIonExchangesTable() {
        Label label = new Label((Composite)this, 0);
        label.setText("Ion Exhanges");
        if (this.method.getIonExchanges() != null) {
            this.createMoleculeTable(true, this.method.getIonExchanges());
        }
    }

    public void createNeutralLossTable() {
        Label label = new Label((Composite)this, 0);
        label.setText("Neutral Loss");
        if (this.method.getNeutralLoss() != null) {
            this.createMoleculeTable(false, this.method.getNeutralLoss());
        }
    }

    private void createMoleculeTable(boolean ion, List<?> input) {
        TableViewer moleculeSettingsTableViewer = new TableViewer((Composite)this, 67584);
        Table table = moleculeSettingsTableViewer.getTable();
        GridData gd_table_2 = new GridData(4, 4, true, true, 1, 1);
        gd_table_2.heightHint = 50;
        table.setLayoutData((Object)gd_table_2);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewerColumn nameColumn = new TableViewerColumn(moleculeSettingsTableViewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setWidth(100);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Molecule) {
                    return ((Molecule)element).getName();
                }
                return "";
            }
        });
        TableViewerColumn labelColumn = new TableViewerColumn(moleculeSettingsTableViewer, 0);
        labelColumn.getColumn().setText("Label");
        labelColumn.getColumn().setWidth(100);
        labelColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Molecule) {
                    return ((Molecule)element).getLabel();
                }
                return "";
            }
        });
        TableViewerColumn massColumn = new TableViewerColumn(moleculeSettingsTableViewer, 0);
        massColumn.getColumn().setText("Mass");
        massColumn.getColumn().setWidth(70);
        massColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Molecule && ((Molecule)element).getMass() != null) {
                    return ((Molecule)element).getMass().toString();
                }
                return "";
            }
        });
        TableViewerColumn countColumn = new TableViewerColumn(moleculeSettingsTableViewer, 0);
        countColumn.getColumn().setText("Count");
        countColumn.getColumn().setWidth(70);
        countColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IonSettings) {
                    return ((IonSettings)element).getCounts().toString();
                }
                if (element instanceof MoleculeSettings) {
                    return ((MoleculeSettings)element).getCount().toString();
                }
                return "";
            }
        });
        if (ion) {
            TableViewerColumn chargeColumn = new TableViewerColumn(moleculeSettingsTableViewer, 0);
            chargeColumn.getColumn().setText("Charge");
            chargeColumn.getColumn().setWidth(70);
            chargeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IonSettings) {
                        return ((IonSettings)element).getCharge().toString();
                    }
                    return "";
                }
            });
            TableViewerColumn polarityColumn = new TableViewerColumn(moleculeSettingsTableViewer, 0);
            polarityColumn.getColumn().setText("Polarity");
            polarityColumn.getColumn().setWidth(200);
            polarityColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IonSettings) {
                        return ((IonSettings)element).getPolarity() != false ? "+" : "-";
                    }
                    return "";
                }
            });
        }
        moleculeSettingsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        moleculeSettingsTableViewer.setInput(input);
        moleculeSettingsTableViewer.getTable().computeSize(-1, moleculeSettingsTableViewer.getTable().getItemHeight());
    }

    public void createAnalyteSettingsTable() {
    }
}

