/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.wurcs.graph;

import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitable;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public abstract class WURCSComponent
implements WURCSVisitable {
    private LinkedList<WURCSEdge> m_aEdges = new LinkedList();

    public boolean addEdge(WURCSEdge edge) {
        if (this.m_aEdges.contains(edge)) {
            return false;
        }
        return this.m_aEdges.add(edge);
    }

    public LinkedList<WURCSEdge> getEdges() {
        return this.m_aEdges;
    }

    public LinkedList<WURCSEdge> getParentEdges() {
        LinkedList<WURCSEdge> t_aEdges = new LinkedList<WURCSEdge>();
        for (WURCSEdge t_oEdge : this.m_aEdges) {
            if (!t_oEdge.getNextComponent().equals(this)) continue;
            t_aEdges.addLast(t_oEdge);
        }
        return t_aEdges;
    }

    public LinkedList<WURCSEdge> getChildEdges() {
        LinkedList<WURCSEdge> t_aEdges = new LinkedList<WURCSEdge>();
        for (WURCSEdge t_oEdge : this.m_aEdges) {
            if (t_oEdge.getNextComponent().equals(this)) continue;
            t_aEdges.addLast(t_oEdge);
        }
        return t_aEdges;
    }

    public boolean removeEdge(WURCSEdge edge) throws WURCSException {
        if (edge == null) {
            throw new WURCSException("Can not delete null linkage in class WURCSCoponent(removeEdge).");
        }
        if (!this.m_aEdges.contains(edge)) {
            return false;
        }
        return this.m_aEdges.remove(edge);
    }

    public void removeAllEdges() {
        this.m_aEdges = new LinkedList();
    }

    public boolean isLeaf() {
        for (WURCSEdge t_oEdge : this.m_aEdges) {
            if (t_oEdge.getNextComponent().equals(this)) continue;
            return false;
        }
        return true;
    }

    public boolean isRoot() {
        for (WURCSEdge t_oEdge : this.m_aEdges) {
            if (!t_oEdge.getNextComponent().equals(this)) continue;
            return false;
        }
        return true;
    }

    public abstract WURCSComponent copy();
}

