/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.dialog;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eurocarbdb.application.glycanbuilder.Residue;

public class RepititionPropertyDialog
extends TitleAreaDialog {
    private Residue m_resEndRep;
    private Spinner m_spnMinRep;
    private Spinner m_spnMaxRep;

    public RepititionPropertyDialog(Shell parentShell, Residue resEndRep) {
        super(parentShell);
        this.m_resEndRep = resEndRep;
    }

    public void create() {
        super.create();
        this.setTitle("Reptition properties");
    }

    public Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, true);
        container.setLayout((Layout)layout);
        this.createControls(container);
        this.setValues(this.m_resEndRep);
        area.pack();
        return area;
    }

    private void createControls(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepititionPropertyDialog.this.validate();
            }
        };
        Label lbl = new Label(parent, 0);
        lbl.setText("Min repitition");
        Spinner spn = new Spinner(parent, 2048);
        spn.setMinimum(-1);
        spn.setMinimum(999);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)spn);
        spn.addSelectionListener((SelectionListener)listener);
        this.m_spnMinRep = spn;
        lbl = new Label(parent, 0);
        lbl.setText("Max repitition");
        spn = new Spinner(parent, 2048);
        spn.setMinimum(-1);
        spn.setMinimum(999);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)spn);
        spn.addSelectionListener((SelectionListener)listener);
        this.m_spnMaxRep = spn;
    }

    private void setValues(Residue resEndRep) {
        this.m_spnMinRep.setSelection(resEndRep.getMinRepetitions());
        this.m_spnMaxRep.setSelection(resEndRep.getMaxRepetitions());
    }

    private boolean validate() {
        this.setErrorMessage(null);
        int iMin = this.m_spnMinRep.getSelection();
        int iMax = this.m_spnMaxRep.getSelection();
        if (iMin >= 0 && iMax >= 0 && iMin > iMax) {
            this.setErrorMessage("Maximum value must be equal or larger than minimum value.");
            return false;
        }
        return true;
    }

    private void save() {
        this.m_resEndRep.setMinRepetitions(this.m_spnMinRep.getText());
        this.m_resEndRep.setMaxRepetitions(this.m_spnMaxRep.getText());
    }

    protected void okPressed() {
        if (!this.validate()) {
            MessageBox box = new MessageBox(this.getShell(), 33);
            box.setMessage(this.getErrorMessage());
            box.open();
            return;
        }
        this.save();
        super.okPressed();
    }
}

