/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.preference;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.IWizardPage;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanAnnotationPreference;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.AddAdductsForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.AddIonExchangeForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.AddNeutralLossForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.FragmentSettingsForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.GlycanSettingsForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.MSGlycanAnnotationWizard;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.util.structure.glycan.util.FilterUtils;

public class MSGlycanAnnotationSettingsPreferenceWizard
extends MSGlycanAnnotationWizard {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationWizard.class);
    private String preferenceName;

    public MSGlycanAnnotationSettingsPreferenceWizard(String name) {
        this.setWindowTitle("MS Annotation Settings");
        this.method = new Method();
        this.preferenceName = name;
        try {
            this.filterLibrary = FilterUtils.readFilters((String)this.getDefaultFiltersPath());
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Error getting the filters", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Error getting the filters", (Throwable)e);
        }
        catch (JAXBException e) {
            logger.error((Object)"Error getting the filters", (Throwable)e);
        }
    }

    public MSGlycanAnnotationSettingsPreferenceWizard(MSGlycanAnnotationPreference preference) {
        this(preference.getName());
        this.method = preference.getMethod();
        this.preferences = preference;
    }

    @Override
    public void addPages() {
        this.glycanSettingsForm = new GlycanSettingsForm(this.method, this, this.filterLibrary);
        this.fragmentSettingsForm = new FragmentSettingsForm(this.method);
        this.ionSettingsForm = new AddAdductsForm(this.method);
        this.ionExchangeForm = new AddIonExchangeForm(this.method);
        this.neutralLossForm = new AddNeutralLossForm(this.method);
        this.addPage((IWizardPage)this.glycanSettingsForm);
        this.addPage((IWizardPage)this.fragmentSettingsForm);
        this.addPage((IWizardPage)this.ionSettingsForm);
        this.addPage((IWizardPage)this.ionExchangeForm);
        this.addPage((IWizardPage)this.neutralLossForm);
    }

    @Override
    public boolean canFinish() {
        if (!this.glycanSettingsForm.canFinish()) {
            return false;
        }
        this.glycanSettingsForm.save();
        if (!this.fragmentSettingsForm.canFinish()) {
            return false;
        }
        this.fragmentSettingsForm.save();
        if (!this.ionSettingsForm.canFlipToNextPage()) {
            return false;
        }
        this.ionSettingsForm.save();
        if (!this.ionExchangeForm.canFlipToNextPage()) {
            return false;
        }
        this.ionExchangeForm.save();
        if (!this.neutralLossForm.isPageComplete()) {
            return false;
        }
        this.neutralLossForm.save();
        return this.ionSettingsForm.isPageComplete() && this.glycanSettingsForm.canFlipToNextPage() && this.fragmentSettingsForm.canFinish() && this.ionExchangeForm.isPageComplete() && this.neutralLossForm.isPageComplete();
    }

    @Override
    public boolean performFinish() {
        boolean bCanFinish = this.canFinish();
        if (bCanFinish) {
            if (this.preferences == null) {
                this.preferences = new MSGlycanAnnotationPreference();
            }
            this.preferences.setName(this.preferenceName);
            this.preferences.setMethod(this.method);
        }
        return bCanFinish;
    }

    @Override
    public MSGlycanAnnotationPreference getPreferences() {
        return this.preferences;
    }
}

