/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashSet;
import org.eurocarbdb.application.glycanbuilder.BBoxManager;
import org.eurocarbdb.application.glycanbuilder.DefaultPaintable;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.GroupingSVGGraphics2D;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.PositionManager;
import org.eurocarbdb.application.glycanbuilder.Residue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SVGGlycanRenderer
extends GlycanRendererAWT {
    public SVGGlycanRenderer(GlycanRendererAWT src) {
        this.theResidueRenderer = src.theResidueRenderer;
        this.theLinkageRenderer = src.theLinkageRenderer;
        this.theResiduePlacementDictionary = src.theResiduePlacementDictionary;
        this.theResidueStyleDictionary = src.theResidueStyleDictionary;
        this.theLinkageStyleDictionary = src.theLinkageStyleDictionary;
        this.theGraphicOptions = src.theGraphicOptions;
    }

    public void paint(GroupingSVGGraphics2D g2d, Glycan structure, HashSet<Residue> selected_residues, HashSet<Linkage> selected_linkages, boolean show_mass, boolean show_redend, PositionManager posManager, BBoxManager bboxManager) {
        if (structure == null || structure.getRoot(show_redend) == null) {
            return;
        }
        selected_residues = selected_residues != null ? selected_residues : new HashSet<Residue>();
        selected_linkages = selected_linkages != null ? selected_linkages : new HashSet<Linkage>();
        this.paintResidue(g2d, structure, structure.getRoot(show_redend), selected_residues, selected_linkages, posManager, bboxManager);
        this.paintBracket(g2d, structure, structure.getBracket(), selected_residues, selected_linkages, posManager, bboxManager);
        if (show_mass) {
            g2d.addGroup("m", structure, null);
            this.displayMass(new DefaultPaintable((Graphics2D)((Object)g2d)), structure, show_redend, bboxManager);
        }
    }

    public void paintResidue(GroupingSVGGraphics2D g2d, Glycan structure, Residue node, HashSet<Residue> selected_residues, HashSet<Linkage> selected_linkages, PositionManager posManager, BBoxManager bboxManager) {
        Rectangle child_border_bbox;
        Rectangle child_bbox;
        Residue child;
        if (node == null) {
            return;
        }
        Rectangle parent_bbox = bboxManager.getParent(node);
        Rectangle node_bbox = bboxManager.getCurrent(node);
        Rectangle border_bbox = bboxManager.getBorder(node);
        Rectangle support_bbox = bboxManager.getSupport(node);
        if (node_bbox == null) {
            return;
        }
        for (Linkage link : node.getChildrenLinkages()) {
            child = link.getChildResidue();
            child_bbox = bboxManager.getCurrent(child);
            child_border_bbox = bboxManager.getBorder(child);
            if (child_bbox == null || posManager.isOnBorder(child)) continue;
            g2d.addGroup("l", structure, node, child);
            boolean selected = selected_residues.contains(node) && selected_residues.contains(child) || selected_linkages.contains(link);
            this.theLinkageRenderer.paintEdge(new DefaultPaintable((Graphics2D)((Object)g2d)), link, selected, node_bbox, border_bbox, child_bbox, child_border_bbox);
        }
        g2d.addGroup("r", structure, node);
        this.theResidueRenderer.paint(new DefaultPaintable((Graphics2D)((Object)g2d)), node, selected_residues.contains(node), posManager.isOnBorder(node), parent_bbox, node_bbox, support_bbox, posManager.getOrientation(node));
        for (Linkage link : node.getChildrenLinkages()) {
            this.paintResidue(g2d, structure, link.getChildResidue(), selected_residues, selected_linkages, posManager, bboxManager);
        }
        for (Linkage link : node.getChildrenLinkages()) {
            child = link.getChildResidue();
            child_bbox = bboxManager.getCurrent(child);
            child_border_bbox = bboxManager.getBorder(child);
            if (child_bbox == null || posManager.isOnBorder(child)) continue;
            g2d.addGroup("li", structure, node, child);
            this.theLinkageRenderer.paintInfo(new DefaultPaintable((Graphics2D)((Object)g2d)), link, node_bbox, border_bbox, child_bbox, child_border_bbox);
        }
    }

    public void paintBracket(GroupingSVGGraphics2D g2d, Glycan structure, Residue bracket, HashSet<Residue> selected_residues, HashSet<Linkage> selected_linkages, PositionManager posManager, BBoxManager bboxManager) {
        if (bracket == null) {
            return;
        }
        Rectangle parent_bbox = bboxManager.getParent(bracket);
        Rectangle bracket_bbox = bboxManager.getCurrent(bracket);
        Rectangle support_bbox = bboxManager.getSupport(bracket);
        g2d.addGroup("b", structure, bracket);
        this.theResidueRenderer.paint(new DefaultPaintable((Graphics2D)((Object)g2d)), bracket, selected_residues.contains(bracket), false, parent_bbox, bracket_bbox, support_bbox, posManager.getOrientation(bracket));
        for (Linkage link : bracket.getChildrenLinkages()) {
            Residue child = link.getChildResidue();
            int quantity = bboxManager.getLinkedResidues(child).size() + 1;
            Rectangle node_bbox = bboxManager.getParent(child);
            Rectangle child_bbox = bboxManager.getCurrent(child);
            Rectangle child_border_bbox = bboxManager.getBorder(child);
            if (child_bbox == null) continue;
            if (!posManager.isOnBorder(child)) {
                g2d.addGroup("l", structure, bracket, child);
                boolean selected = selected_residues.contains(bracket) && selected_residues.contains(child) || selected_linkages.contains(link);
                this.theLinkageRenderer.paintEdge(new DefaultPaintable((Graphics2D)((Object)g2d)), link, selected, node_bbox, node_bbox, child_bbox, child_border_bbox);
            }
            this.paintResidue(g2d, structure, child, selected_residues, selected_linkages, posManager, bboxManager);
            if (!posManager.isOnBorder(child)) {
                g2d.addGroup("li", structure, bracket, child);
                this.theLinkageRenderer.paintInfo(new DefaultPaintable((Graphics2D)((Object)g2d)), link, node_bbox, node_bbox, child_bbox, child_border_bbox);
            }
            if (quantity <= 1) continue;
            this.paintQuantity(new DefaultPaintable((Graphics2D)((Object)g2d)), child, quantity, bboxManager);
        }
    }
}

