/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.analytical.misc;

import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserTree;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;

public class GlycoVisitorCountNodeType
implements GlycoVisitor {
    private int m_iSubstituentCount;
    private int m_iNonMonosaccharideCount;
    private int m_iCyclicCount;
    private int m_iMonosaccharideCount;
    private int m_iRepeatCount;
    private int m_iAlternativeCount;
    private int m_iUnvalidatedGlycoNode;
    private GlycoTraverser m_objTraverser;

    @Override
    public void visit(Monosaccharide a_objMonosaccharid) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            ++this.m_iMonosaccharideCount;
        }
    }

    @Override
    public void visit(NonMonosaccharide a_objResidue) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            ++this.m_iNonMonosaccharideCount;
        }
    }

    @Override
    public void visit(GlycoEdge a_objLinkage) throws GlycoVisitorException {
    }

    @Override
    public void visit(SugarUnitRepeat a_objRepeate) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            GlycoTraverser t_trav = this.m_objTraverser;
            this.m_objTraverser = this.getTraverser(this);
            this.m_objTraverser.traverseGraph(a_objRepeate);
            this.m_objTraverser = t_trav;
            ++this.m_iRepeatCount;
        }
    }

    @Override
    public GlycoTraverser getTraverser(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        return new GlycoTraverserTree(a_objVisitor);
    }

    @Override
    public void visit(Substituent a_objSubstituent) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            ++this.m_iSubstituentCount;
        }
    }

    @Override
    public void visit(SugarUnitCyclic a_objCyclic) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            ++this.m_iCyclicCount;
        }
    }

    @Override
    public void visit(SugarUnitAlternative a_objAlternative) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            ++this.m_iAlternativeCount;
        }
    }

    @Override
    public void visit(UnvalidatedGlycoNode a_objUnvalidated) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            ++this.m_iUnvalidatedGlycoNode;
        }
    }

    @Override
    public void clear() {
        this.m_iRepeatCount = 0;
        this.m_iMonosaccharideCount = 0;
        this.m_iNonMonosaccharideCount = 0;
        this.m_iCyclicCount = 0;
        this.m_iSubstituentCount = 0;
        this.m_iAlternativeCount = 0;
        this.m_iUnvalidatedGlycoNode = 0;
    }

    public int getNonMonosaccharideCount() {
        return this.m_iNonMonosaccharideCount;
    }

    public int getMonosaccharideCount() {
        return this.m_iMonosaccharideCount;
    }

    public int getSubstituentCount() {
        return this.m_iSubstituentCount;
    }

    public int getRepeatCount() {
        return this.m_iRepeatCount;
    }

    public int getAlternativeNodeCount() {
        return this.m_iAlternativeCount;
    }

    public int getCyclicCount() {
        return this.m_iCyclicCount;
    }

    public int getUnvalidatedNodeCount() {
        return this.m_iUnvalidatedGlycoNode;
    }

    @Override
    public void start(Sugar a_objSugar) throws GlycoVisitorException {
        this.clear();
        this.m_objTraverser = this.getTraverser(this);
        this.m_objTraverser.traverseGraph(a_objSugar);
    }

    public void start(GlycoNode a_objResidue) throws GlycoVisitorException {
        this.clear();
        this.m_objTraverser = this.getTraverser(this);
        this.m_objTraverser.traverse(a_objResidue);
    }
}

