/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.iupac;

import java.util.ArrayList;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.io.SugarImporterText;
import org.eurocarbdb.MolecularFramework.io.iupac.IupacSubTree;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;

public class SugarImporterIupacCondenced
extends SugarImporterText {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void start() throws SugarImporterException {
        try {
            this.clear();
            UnvalidatedGlycoNode t_objResiduumChild = new UnvalidatedGlycoNode();
            UnvalidatedGlycoNode t_objResiduumParent = new UnvalidatedGlycoNode();
            GlycoEdge t_objEdge = new GlycoEdge();
            Linkage t_objLinkage = new Linkage();
            int t_iStartPosition = this.m_iPosition;
            this.residue();
            String t_strResidueName = this.m_strText.substring(t_iStartPosition, this.m_iPosition);
            if (this.m_cToken != '(') {
                throw new SugarImporterException("IUPAC000", this.m_iPosition);
            }
            this.nextToken();
            t_objResiduumChild.setName(String.valueOf(this.anomer()) + t_strResidueName);
            this.m_objSugar.addNode(t_objResiduumChild);
            t_objLinkage.addChildLinkage(this.linkageposition());
            if (this.m_cToken == '-') {
                this.nextToken();
            } else if (this.m_cToken != '$') {
                throw new SugarImporterException("IUPAC005", this.m_iPosition);
            }
            block2: while (true) {
                if (this.m_cToken == '$') {
                    if (this.finished()) return;
                    throw new SugarImporterException("IUPAC002", this.m_iPosition);
                }
                t_objLinkage.addParentLinkage(this.linkageposition());
                t_objEdge.addGlycosidicLinkage(t_objLinkage);
                if (this.m_cToken != ')') {
                    throw new SugarImporterException("IUPAC001", this.m_iPosition);
                }
                this.nextToken();
                ArrayList<IupacSubTree> t_aIupacSubtree = new ArrayList<IupacSubTree>();
                while (true) {
                    if (this.m_cToken != '[') {
                        t_iStartPosition = this.m_iPosition;
                        this.residue();
                        t_strResidueName = this.m_strText.substring(t_iStartPosition, this.m_iPosition);
                        if (this.m_cToken == '(') break;
                        throw new SugarImporterException("IUPAC000", this.m_iPosition);
                    }
                    t_aIupacSubtree.add(this.subbranch());
                }
                this.nextToken();
                t_objResiduumParent.setName(String.valueOf(this.anomer()) + t_strResidueName);
                this.m_objSugar.addNode(t_objResiduumParent);
                this.m_objSugar.addEdge(t_objResiduumParent, t_objResiduumChild, t_objEdge);
                Iterator t_iterSubtree = t_aIupacSubtree.iterator();
                while (true) {
                    if (!t_iterSubtree.hasNext()) {
                        t_objResiduumChild = t_objResiduumParent;
                        t_objResiduumParent = new UnvalidatedGlycoNode();
                        t_objEdge = new GlycoEdge();
                        t_objLinkage = new Linkage();
                        t_objLinkage.addChildLinkage(this.linkageposition());
                        if (this.m_cToken != '-') break;
                        this.nextToken();
                        continue block2;
                    }
                    IupacSubTree t_objTree = (IupacSubTree)t_iterSubtree.next();
                    this.m_objSugar.addEdge(t_objResiduumParent, t_objTree.getGlycoNode(), t_objTree.getGlycoEdge());
                }
                if (this.m_cToken != '$') break;
            }
            throw new SugarImporterException("IUPAC005", this.m_iPosition);
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException("COMMON013", this.m_iPosition);
        }
    }

    private IupacSubTree subbranch() throws SugarImporterException, GlycoconjugateException {
        if (this.m_cToken != '[') {
            throw new SugarImporterException("IUPAC004", this.m_iPosition);
        }
        this.nextToken();
        IupacSubTree t_objTreeChild = this.fullresidue();
        this.m_objSugar.addNode(t_objTreeChild.getGlycoNode());
        while (this.m_cToken != ']') {
            ArrayList<IupacSubTree> t_aIupacSubtree = new ArrayList<IupacSubTree>();
            while (this.m_cToken == '[') {
                t_aIupacSubtree.add(this.subbranch());
            }
            IupacSubTree t_objTreeParent = this.fullresidue();
            this.m_objSugar.addNode(t_objTreeChild.getGlycoNode());
            this.m_objSugar.addEdge(t_objTreeParent.getGlycoNode(), t_objTreeChild.getGlycoNode(), t_objTreeChild.getGlycoEdge());
            for (IupacSubTree t_objTree : t_aIupacSubtree) {
                this.m_objSugar.addEdge(t_objTreeParent.getGlycoNode(), t_objTree.getGlycoNode(), t_objTree.getGlycoEdge());
            }
            t_objTreeChild = t_objTreeParent;
        }
        this.nextToken();
        return t_objTreeChild;
    }

    private IupacSubTree fullresidue() throws SugarImporterException, GlycoconjugateException {
        IupacSubTree t_objTree = new IupacSubTree();
        UnvalidatedGlycoNode t_objNode = new UnvalidatedGlycoNode();
        GlycoEdge t_objEdge = new GlycoEdge();
        Linkage t_objLinkage = new Linkage();
        int t_iStartPosition = this.m_iPosition;
        this.residue();
        String t_strResidueName = this.m_strText.substring(t_iStartPosition, this.m_iPosition);
        if (this.m_cToken != '(') {
            throw new SugarImporterException("IUPAC000", this.m_iPosition);
        }
        this.nextToken();
        t_objNode.setName(String.valueOf(this.anomer()) + t_strResidueName);
        this.m_objSugar.addNode(t_objNode);
        t_objLinkage.addChildLinkage(this.linkageposition());
        if (this.m_cToken != '-') {
            throw new SugarImporterException("IUPAC005", this.m_iPosition);
        }
        this.nextToken();
        t_objLinkage.addParentLinkage(this.linkageposition());
        if (this.m_cToken != ')') {
            throw new SugarImporterException("IUPAC001", this.m_iPosition);
        }
        this.nextToken();
        t_objEdge.addGlycosidicLinkage(t_objLinkage);
        t_objTree.setGlycoEdge(t_objEdge);
        t_objTree.setGlycoNode(t_objNode);
        return t_objTree;
    }

    private int linkageposition() throws SugarImporterException {
        if (this.m_cToken == '?') {
            this.nextToken();
            return -1;
        }
        return this.number();
    }

    private String anomer() throws SugarImporterException {
        if (this.m_cToken == 'a') {
            this.nextToken();
            return "a";
        }
        if (this.m_cToken == 'b') {
            this.nextToken();
            return "b";
        }
        if (this.m_cToken == '?') {
            this.nextToken();
            return "?";
        }
        if (this.m_cToken == 'o') {
            this.nextToken();
            return "o";
        }
        throw new SugarImporterException("IUPAC0003", this.m_iPosition);
    }

    private void residue() throws SugarImporterException {
        this.symbol();
        while (this.m_cToken != '(') {
            this.symbol();
        }
    }

    private void symbol() throws SugarImporterException {
        if (this.m_cToken == '?' || this.m_cToken == '-') {
            this.nextToken();
        } else {
            char t_iDigit = this.m_cToken;
            if (t_iDigit > '/' && t_iDigit < ':') {
                this.number();
            } else {
                this.character();
            }
        }
    }

    private void clear() {
    }
}

