/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato.glycan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.annotation.gelato.AnalyteMatcher;
import org.grits.toolbox.ms.annotation.gelato.GelatoUtils;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanMatcher;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanStructureAnnotation;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanStructureAnnotationMSProfile;
import org.grits.toolbox.ms.annotation.structure.GelatoAnalyte;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.GlycanFeature;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.data.ScansAnnotation;

public class GlycanMatcherMSProfile
extends GlycanMatcher {
    private static final Logger logger = Logger.getLogger(GlycanMatcherMSProfile.class);

    public GlycanMatcherMSProfile(int iCurScan, GlycanStructureAnnotation parent) {
        super(iCurScan, parent);
    }

    @Override
    protected void handleUnscoredPeak(Peak parentPeak) {
        Scan parentScan = (Scan)this.getData().getScans().get(this.getScanNum());
        try {
            Scan subScan = ((GlycanStructureAnnotationMSProfile)this.parent).getPhonySubScan(parentPeak, parentScan);
            int n = subScan.getScanNo();
        }
        catch (Exception ex) {
            logger.error((Object)"Error matching glycan structure to phony scan num.", (Throwable)ex);
        }
    }

    @Override
    public boolean scorePeakToFeature(Data data, double analyteMz, String analyteType, GelatoAnalyte analyte, Annotation annotation, ScansAnnotation scanAnnotation, Feature parentFeature, List<IonSettings> lParentAdducts, List<Integer> lParentAdductCounts, int iParentCharge, List<IonSettings> lParentIonExchanges, List<Integer> lParentExchangeCounts, int iParentExchangeCount, List<MoleculeSettings> lParentNeutralLosses, List<Integer> lParentNeutralLossCounts, int iParentNeutralLossCount, AnalyteSettings settings, Peak parentPeak, int iParentScanNum, String tempPath) {
        Scan parentScan = (Scan)this.getData().getScans().get(this.getScanNum());
        try {
            Scan subScan = ((GlycanStructureAnnotationMSProfile)this.parent).getPhonySubScan(parentPeak, parentScan);
            int iSubScanNum = subScan.getScanNo();
            GlycanFeature feature = new GlycanFeature();
            GelatoUtils.populateNewFeature((Feature)feature, data, analyte.getAnalyte().getAnalyteStringRepresentation(), parentPeak.getMz(), analyteMz, iParentCharge, analyteType, lParentAdducts, lParentAdductCounts, lParentIonExchanges, lParentExchangeCounts, lParentNeutralLosses, lParentNeutralLossCounts, iSubScanNum, parentPeak.getId(), annotation, parentFeature);
            logger.debug((Object)("\t\tFeature id: " + parentPeak.getId() + ", Feature mz: " + feature.getMz()));
            AnalyteMatcher.addAnnotationToScan(this.getData(), scanAnnotation, this.getScanNum(), annotation, (Feature)feature);
            this.calculateScores(scanAnnotation, annotation, (Feature)feature, iSubScanNum);
            if (this.getData().getAnnotatedScan().get(iSubScanNum) == null) {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(annotation.getStringId());
                this.getData().getAnnotatedScan().put(iSubScanNum, ids);
            } else {
                ((List)this.getData().getAnnotatedScan().get(iSubScanNum)).add(annotation.getStringId());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error matching glycan structure to phony scan num.", (Throwable)ex);
        }
        return true;
    }

    @Override
    protected boolean calculateScores(ScansAnnotation scanAnnotations, Annotation annotation, Feature feature, int iPrecursorScanNum) {
        annotation.getScores().put(Integer.toString(iPrecursorScanNum), -1.0);
        feature.getDoubleProp().put(GlycanStructureAnnotation.countingScoreData.getKey(), -1.0);
        feature.getDoubleProp().put(GlycanStructureAnnotation.intensityScoreData.getKey(), -1.0);
        feature.getDoubleProp().put(GlycanStructureAnnotation.rawCountingScoreData.getKey(), -1.0);
        feature.getDoubleProp().put(GlycanStructureAnnotation.rawIntensityScoreData.getKey(), -1.0);
        return true;
    }
}

