/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.analytical.misc;

import java.util.HashMap;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserTree;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;

public class GlycoVisitorSugarGraphComposition
implements GlycoVisitor {
    private HashMap<Substituent, Integer> m_hSubstituent = new HashMap();
    private HashMap<Monosaccharide, Integer> m_hMonosaccharide = new HashMap();
    private HashMap<NonMonosaccharide, Integer> m_hNonMonosaccharide = new HashMap();
    private GlycoTraverser m_objTraverser;

    @Override
    public void visit(Monosaccharide a_objMonosaccharid) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            if (!this.m_hMonosaccharide.containsKey(a_objMonosaccharid)) {
                this.m_hMonosaccharide.put(a_objMonosaccharid, 1);
            } else {
                this.m_hMonosaccharide.put(a_objMonosaccharid, this.m_hMonosaccharide.get(a_objMonosaccharid) + 1);
            }
        }
    }

    @Override
    public void visit(NonMonosaccharide a_objResidue) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            if (!this.m_hNonMonosaccharide.containsKey(a_objResidue)) {
                this.m_hNonMonosaccharide.put(a_objResidue, 1);
            } else {
                this.m_hNonMonosaccharide.put(a_objResidue, this.m_hNonMonosaccharide.get(a_objResidue) + 1);
            }
        }
    }

    @Override
    public void visit(GlycoEdge a_objLinkage) throws GlycoVisitorException {
    }

    @Override
    public void visit(SugarUnitRepeat a_objRepeate) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            GlycoTraverser t_trav = this.m_objTraverser;
            this.m_objTraverser = this.getTraverser(this);
            this.m_objTraverser.traverseGraph(a_objRepeate);
            this.m_objTraverser = t_trav;
        }
    }

    @Override
    public GlycoTraverser getTraverser(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        return new GlycoTraverserTree(a_objVisitor);
    }

    @Override
    public void visit(Substituent a_objSubstituent) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            if (!this.m_hSubstituent.containsKey(a_objSubstituent)) {
                this.m_hSubstituent.put(a_objSubstituent, 1);
            } else {
                this.m_hSubstituent.put(a_objSubstituent, this.m_hSubstituent.get(a_objSubstituent) + 1);
            }
        }
    }

    @Override
    public void visit(SugarUnitCyclic a_objCyclic) throws GlycoVisitorException {
    }

    @Override
    public void visit(SugarUnitAlternative a_objAlternative) throws GlycoVisitorException {
    }

    @Override
    public void visit(UnvalidatedGlycoNode a_objUnvalidated) throws GlycoVisitorException {
    }

    @Override
    public void clear() {
        this.m_hMonosaccharide.clear();
        this.m_hNonMonosaccharide.clear();
        this.m_hSubstituent.clear();
    }

    @Override
    public void start(Sugar a_objSugar) throws GlycoVisitorException {
        this.clear();
        this.m_objTraverser = this.getTraverser(this);
        this.m_objTraverser.traverseGraph(a_objSugar);
    }

    public void start(GlycoNode a_objResidue) throws GlycoVisitorException {
        this.clear();
        this.m_objTraverser = this.getTraverser(this);
        this.m_objTraverser.traverse(a_objResidue);
    }

    public HashMap<NonMonosaccharide, Integer> getNonMonosaccharides() {
        return this.m_hNonMonosaccharide;
    }

    public HashMap<Monosaccharide, Integer> getMonosaccharides() {
        return this.m_hMonosaccharide;
    }

    public HashMap<Substituent, Integer> getSubstituents() {
        return this.m_hSubstituent;
    }
}

