/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.sugar;

import java.util.ArrayList;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.Visitable;

public class GlycoEdge
implements Visitable {
    private GlycoNode m_objParent = null;
    private GlycoNode m_objChild = null;
    private ArrayList<Linkage> m_aLinkages = new ArrayList();

    public void setParent(GlycoNode a_objParent) {
        this.m_objParent = a_objParent;
    }

    public void setChild(GlycoNode a_objChild) {
        this.m_objChild = a_objChild;
    }

    public GlycoNode getChild() {
        return this.m_objChild;
    }

    public GlycoNode getParent() {
        return this.m_objParent;
    }

    public void setGlycosidicLinkages(ArrayList<Linkage> a_aLinkages) throws GlycoconjugateException {
        if (a_aLinkages == null) {
            throw new GlycoconjugateException("null is not a valide set of linkages.");
        }
        this.m_aLinkages.clear();
        Iterator<Linkage> t_iterLinkage = a_aLinkages.iterator();
        while (t_iterLinkage.hasNext()) {
            this.addGlycosidicLinkage(t_iterLinkage.next());
        }
        this.m_aLinkages = a_aLinkages;
    }

    public ArrayList<Linkage> getGlycosidicLinkages() {
        return this.m_aLinkages;
    }

    public boolean addGlycosidicLinkage(Linkage a_objLinkage) throws GlycoconjugateException {
        if (a_objLinkage == null) {
            throw new GlycoconjugateException("null linkage is not allowed");
        }
        if (!this.m_aLinkages.contains(a_objLinkage)) {
            return this.m_aLinkages.add(a_objLinkage);
        }
        return false;
    }

    public boolean removeGlycosidicLinkage(Linkage a_objLinkage) {
        if (this.m_aLinkages.contains(a_objLinkage)) {
            return this.m_aLinkages.remove(a_objLinkage);
        }
        return false;
    }

    @Override
    public void accept(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        a_objVisitor.visit(this);
    }

    public GlycoEdge copy() throws GlycoconjugateException {
        GlycoEdge t_objCopy = new GlycoEdge();
        Iterator<Linkage> t_iterEdges = this.m_aLinkages.iterator();
        while (t_iterEdges.hasNext()) {
            t_objCopy.addGlycosidicLinkage(t_iterEdges.next().copy());
        }
        return t_objCopy;
    }
}

