/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.glycam;

import java.util.ArrayList;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.io.SugarImporterText;
import org.eurocarbdb.MolecularFramework.io.iupac.IupacSubTree;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;

public class SugarImporterGlycamExt
extends SugarImporterText {
    @Override
    protected void start() throws SugarImporterException {
        try {
            this.clear();
            UnvalidatedGlycoNode t_objResiduumChild = new UnvalidatedGlycoNode();
            UnvalidatedGlycoNode t_objResiduumParent = new UnvalidatedGlycoNode();
            int t_iStartPosition = this.m_iPosition;
            this.residue();
            String t_strResidueName = this.m_strText.substring(t_iStartPosition, this.m_iPosition);
            t_objResiduumChild.setName(t_strResidueName);
            this.m_objSugar.addNode(t_objResiduumChild);
            while (this.m_cToken != '$') {
                GlycoEdge t_objEdge = this.linkage(t_objResiduumChild);
                if (this.m_cToken != '-') {
                    throw new SugarImporterException("IUPAC005", this.m_iPosition);
                }
                this.nextToken();
                ArrayList<IupacSubTree> t_aIupacSubtree = new ArrayList<IupacSubTree>();
                while (this.m_cToken == '[') {
                    t_aIupacSubtree.add(this.subbranch());
                }
                t_iStartPosition = this.m_iPosition;
                this.residue();
                t_strResidueName = this.m_strText.substring(t_iStartPosition, this.m_iPosition);
                t_objResiduumParent.setName(t_strResidueName);
                this.m_objSugar.addNode(t_objResiduumParent);
                this.m_objSugar.addEdge(t_objResiduumParent, t_objResiduumChild, t_objEdge);
                for (IupacSubTree t_objTree : t_aIupacSubtree) {
                    this.m_objSugar.addEdge(t_objResiduumParent, t_objTree.getGlycoNode(), t_objTree.getGlycoEdge());
                }
                t_objResiduumChild = t_objResiduumParent;
                t_objResiduumParent = new UnvalidatedGlycoNode();
            }
            if (!this.finished()) {
                throw new SugarImporterException("IUPAC002", this.m_iPosition);
            }
            GlycoVisitorNodeType t_visNodeType = new GlycoVisitorNodeType();
            for (GlycoNode t_node : this.m_objSugar.getRootNodes()) {
                UnvalidatedGlycoNode t_residue = t_visNodeType.getUnvalidatedNode(t_node);
                String t_strName = t_residue.getName();
                if (!t_strName.endsWith("-OH")) continue;
                t_residue.setName(t_strName.substring(0, t_strName.length() - 3));
            }
        }
        catch (GlycoVisitorException e) {
            throw new SugarImporterException("COMMON000", this.m_iPosition);
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException("COMMON013", this.m_iPosition);
        }
    }

    private GlycoEdge linkage(UnvalidatedGlycoNode a_nodeChild) throws SugarImporterException, GlycoconjugateException {
        Linkage t_objLinkage = new Linkage();
        if (this.m_cToken != '-') {
            throw new SugarImporterException("IUPAC005", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != '(') {
            throw new SugarImporterException("IUPAC000", this.m_iPosition);
        }
        this.nextToken();
        t_objLinkage.addChildLinkage(this.number());
        if (this.m_cToken != '-') {
            throw new SugarImporterException("IUPAC005", this.m_iPosition);
        }
        this.nextToken();
        t_objLinkage.addParentLinkage(this.number());
        GlycoEdge t_edge = new GlycoEdge();
        t_edge.addGlycosidicLinkage(t_objLinkage);
        if (this.m_cToken != ')') {
            throw new SugarImporterException("IUPAC001", this.m_iPosition);
        }
        this.nextToken();
        return t_edge;
    }

    private IupacSubTree subbranch() throws SugarImporterException, GlycoconjugateException {
        IupacSubTree t_objIupacResidue = new IupacSubTree();
        if (this.m_cToken != '[') {
            throw new SugarImporterException("IUPAC004", this.m_iPosition);
        }
        this.nextToken();
        int t_iStartPosition = this.m_iPosition;
        this.residue();
        String t_strResidueName = this.m_strText.substring(t_iStartPosition, this.m_iPosition);
        UnvalidatedGlycoNode t_node = new UnvalidatedGlycoNode();
        t_node.setName(t_strResidueName);
        GlycoEdge t_edge = this.linkage(t_node);
        t_objIupacResidue.setGlycoEdge(t_edge);
        t_objIupacResidue.setGlycoNode(t_node);
        while (this.m_cToken != ']') {
            ArrayList<IupacSubTree> t_aIupacSubtree = new ArrayList<IupacSubTree>();
            t_aIupacSubtree.add(t_objIupacResidue);
            if (this.m_cToken != '-') {
                throw new SugarImporterException("IUPAC005", this.m_iPosition);
            }
            this.nextToken();
            while (this.m_cToken == '[') {
                t_aIupacSubtree.add(this.subbranch());
            }
            t_iStartPosition = this.m_iPosition;
            this.residue();
            t_strResidueName = this.m_strText.substring(t_iStartPosition, this.m_iPosition);
            t_node = new UnvalidatedGlycoNode();
            t_node.setName(t_strResidueName);
            t_edge = this.linkage(t_node);
            this.m_objSugar.addNode(t_node);
            for (IupacSubTree t_objTree : t_aIupacSubtree) {
                this.m_objSugar.addEdge(t_node, t_objTree.getGlycoNode(), t_objTree.getGlycoEdge());
            }
            t_objIupacResidue = new IupacSubTree();
            t_objIupacResidue.setGlycoEdge(t_edge);
            t_objIupacResidue.setGlycoNode(t_node);
        }
        this.nextToken();
        return t_objIupacResidue;
    }

    private void residue() throws SugarImporterException {
        this.symbol();
        while (this.m_cToken != '(' && this.m_cToken != '$') {
            if (this.m_cToken == '-' && this.aheadToken(1) == '(') {
                return;
            }
            this.symbol();
        }
    }

    private void symbol() throws SugarImporterException {
        if (this.m_cToken == '?') {
            this.nextToken();
        } else if (this.m_cToken == '-') {
            this.nextToken();
        } else {
            char t_iDigit = this.m_cToken;
            if (t_iDigit > '/' && t_iDigit < ':') {
                this.number();
            } else {
                this.character();
            }
        }
    }

    private void clear() {
    }
}

