/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.part;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.part.ComponentTab;
import org.grits.toolbox.entry.sample.part.IAnalytePartTab;
import org.grits.toolbox.entry.sample.part.OverviewTab;
import org.grits.toolbox.entry.sample.property.SampleProperty;
import org.grits.toolbox.entry.sample.utilities.AnalyteFactory;
import org.grits.toolbox.entry.sample.utilities.UtilityFile;

public class AnalyteEntryPart {
    private static Logger logger = Logger.getLogger(AnalyteEntryPart.class);
    public static final String PART_ID = "org.grits.toolbox.partdescriptor.entry.analyte.default";
    private Entry analyteEntry = null;
    private File analyteFile = null;
    private Sample sample = null;
    private CTabFolder cTabFolder = null;
    private Map<CTabItem, IAnalytePartTab> cTabItemToPartTabMap = new HashMap<CTabItem, IAnalytePartTab>();
    @Inject
    private MDirtyable dirtyable = null;

    @Inject
    public AnalyteEntryPart(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Entry entry, IGritsDataModelService gritsDataModelService, @Named(value="workspace_location") @Named(value="workspace_location") String workspaceLocation) {
        try {
            if (entry != null && "org.grits.toolbox.property.sample".equals(entry.getProperty().getType())) {
                this.analyteEntry = entry;
                this.loadSample(gritsDataModelService, workspaceLocation);
            }
        }
        catch (IOException e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Loading Sample", (String)("Sample could not be loaded from the file.\n" + e.getMessage()));
        }
        catch (Exception ex) {
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Creating Part", (String)"Some unexpected error occurred while opening the editor. Please contact developers for further information/help.");
        }
    }

    @PostConstruct
    public void postConstruct(Composite parent, final MPart part) {
        logger.info((Object)"loading sample preference");
        part.getContext().set(Sample.class, (Object)this.sample);
        parent.setLayout((Layout)new FillLayout());
        logger.info((Object)"Creating tabs");
        this.cTabFolder = new CTabFolder(parent, 0);
        this.cTabFolder.setTabPosition(1024);
        this.cTabFolder.setSimple(false);
        part.getContext().set(CTabFolder.class, (Object)this.cTabFolder);
        try {
            this.createPartTabs(part);
            this.cTabFolder.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.changeTab(e);
                }

                private void changeTab(SelectionEvent e) {
                    int selectionIndex = AnalyteEntryPart.this.cTabFolder.getSelectionIndex();
                    logger.info((Object)("Tab changed to " + selectionIndex));
                    selectionIndex = selectionIndex < 0 ? 0 : selectionIndex;
                    IAnalytePartTab currentTab = (IAnalytePartTab)AnalyteEntryPart.this.cTabItemToPartTabMap.get(AnalyteEntryPart.this.cTabFolder.getSelection());
                    for (MToolBarElement toolBarElement : part.getToolbar().getChildren()) {
                        toolBarElement.setVisible(selectionIndex > 0 || "org.grits.toolbox.entry.sample.handledtoolitem.addcomponent".equals(toolBarElement.getElementId()));
                    }
                    part.getContext().set(IAnalytePartTab.class, (Object)currentTab);
                    AnalyteEntryPart.this.cTabFolder.getSelection().notifyListeners(13, new Event());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.changeTab(e);
                }
            });
            int selectionIndex = this.sample.getComponents().size() == 1 ? 1 : 0;
            this.cTabFolder.setSelection(selectionIndex);
            this.cTabFolder.notifyListeners(13, new Event());
        }
        catch (Exception e) {
            logger.fatal((Object)("Error while adding tabs to the analyte part.\n" + e.getMessage()), (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Creating Page", (String)"Some unexpected error occurred while opening the editor. Please contact developers for further information/help.");
            logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)"END   : Creating Analyte Entry Part. ");
    }

    private void createPartTabs(MPart part) {
        logger.info((Object)"Adding overview tabs");
        CTabItem cTabItem = new CTabItem(this.cTabFolder, 0);
        cTabItem.setText("Overview");
        cTabItem.setShowClose(false);
        OverviewTab overviewTab = (OverviewTab)ContextInjectionFactory.make(OverviewTab.class, (IEclipseContext)part.getContext());
        this.cTabItemToPartTabMap.put(cTabItem, overviewTab);
        logger.info((Object)"Adding remaining component tabs");
        for (Component component : this.sample.getComponents()) {
            this.addNewComponentTab(part, component);
        }
    }

    public ComponentTab addNewComponentTab(MPart part, Component component) {
        logger.info((Object)("Adding component tab for " + component.getLabel()));
        CTabItem cTabItem = new CTabItem(this.cTabFolder, 0);
        cTabItem.setText(component.getLabel());
        cTabItem.setShowClose(false);
        part.getContext().set(Component.class, (Object)component);
        part.getContext().set(CTabItem.class, (Object)cTabItem);
        ComponentTab componentTab = (ComponentTab)ContextInjectionFactory.make(ComponentTab.class, (IEclipseContext)part.getContext());
        this.cTabItemToPartTabMap.put(cTabItem, componentTab);
        return componentTab;
    }

    @Optional
    @Inject
    public void removeComponentTab(@UIEventTopic(value="analyte_part_remove_component_tab") Component component, MPart part, MDirtyable dirtyable) {
        if (component != null && part != null && this == part.getObject()) {
            logger.info((Object)("Removing component tab for : " + component.getLabel()));
            IAnalytePartTab partTabToRemove = null;
            for (IAnalytePartTab partTab : this.cTabItemToPartTabMap.values()) {
                if (component != partTab.getInput()) continue;
                partTabToRemove = partTab;
                break;
            }
            if (partTabToRemove != null) {
                CTabItem itemToRemove = null;
                for (CTabItem item : this.cTabItemToPartTabMap.keySet()) {
                    if (this.cTabItemToPartTabMap.get(item) != partTabToRemove) continue;
                    itemToRemove = item;
                    break;
                }
                ContextInjectionFactory.uninject((Object)component, (IEclipseContext)part.getContext());
                ContextInjectionFactory.uninject((Object)partTabToRemove, (IEclipseContext)part.getContext());
                this.cTabItemToPartTabMap.remove(itemToRemove);
                itemToRemove.dispose();
                this.cTabFolder.redraw();
                dirtyable.setDirty(true);
            }
            logger.info((Object)("Component tab removed for component : " + component.getLabel()));
        }
    }

    private void loadSample(IGritsDataModelService gritsDataModelService, String workspaceLocation) throws IOException {
        try {
            this.loadSampleFile(gritsDataModelService, workspaceLocation);
            FileInputStream inputStream = new FileInputStream(this.analyteFile.getAbsolutePath());
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Sample.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                this.sample = (Sample)unmarshaller.unmarshal((Reader)reader);
                for (Component component : this.sample.getComponents()) {
                    if (component.getComponentId() != null) continue;
                    component.setComponentId(this.sample.getNextAvailableComponentId());
                }
            }
            catch (JAXBException e) {
                logger.error((Object)("Error parsing the xml file.\n" + e.getMessage()), (Throwable)e);
            }
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            logger.error((Object)("Error loading the file from the file location. " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    private void loadSampleFile(IGritsDataModelService gritsDataModelService, String workspaceLocation) throws FileNotFoundException {
        logger.info((Object)"loading sample from file");
        SampleProperty sampleProperty = (SampleProperty)this.analyteEntry.getProperty();
        PropertyDataFile samplePropertyFile = sampleProperty.getSampleFile();
        if (samplePropertyFile != null && samplePropertyFile.getName() != null) {
            Entry projectEntry = gritsDataModelService.findParentByType(this.analyteEntry, "org.grits.toolbox.property.project");
            String samplesFolderLocation = String.valueOf(workspaceLocation) + File.separator + projectEntry.getDisplayName() + File.separator + "samples";
            String fileName = samplePropertyFile.getName();
            if ("older than grits 1.0".equals(fileName)) {
                try {
                    fileName = AnalyteFactory.createSampleFileForOldSample(projectEntry.getDisplayName(), this.analyteEntry.getDisplayName(), "");
                    sampleProperty.getSampleFile().setName(fileName);
                    ProjectFileHandler.saveProject((Entry)projectEntry);
                }
                catch (IOException iOException) {
                    ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot Create Entry", (Exception)new Exception());
                }
            }
            if (fileName != null && !fileName.isEmpty()) {
                String fileLocation = String.valueOf(samplesFolderLocation) + File.separator + fileName;
                this.analyteFile = new File(fileLocation);
            } else {
                String errorMessage = "Sample file name is null or empty";
                logger.error((Object)errorMessage);
                throw new FileNotFoundException(errorMessage);
            }
        }
    }

    @PreDestroy
    public void preDestroy(MPart part) {
        ContextInjectionFactory.uninject((Object)this.sample, (IEclipseContext)part.getContext());
        ContextInjectionFactory.uninject((Object)this.cTabFolder, (IEclipseContext)part.getContext());
    }

    @Focus
    public void onFocus() {
        this.cTabItemToPartTabMap.get(this.cTabFolder.getSelection()).setFocus();
    }

    @Persist
    public void save() {
        if (UtilityFile.updateSampleFile(this.sample, this.analyteEntry)) {
            this.dirtyable.setDirty(false);
        }
    }

    public Entry getAnalyteEntry() {
        return this.analyteEntry;
    }
}

