/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.projectexplorer.dialog;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.ProjectProperty;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.EntryLabelProvider;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.core.utilShare.sort.EntryComparator;

public class ExportEntryDialog
extends TitleAreaDialog {
    public static final String EXTENSION = ".GR";
    private static final String DEFAULT_FILENAME = "Projects.GR";
    private CheckboxTableViewer projectTableViewer = null;
    private List<Entry> selectedEntries = new ArrayList<Entry>();
    private String savingLocation = null;
    private Text locationText = null;
    private boolean userSelectedLocation = false;

    public ExportEntryDialog(Shell parentShell, List<Entry> selectedEntries) {
        super(parentShell);
        this.selectedEntries = selectedEntries;
    }

    public void create() {
        super.create();
        this.setTitle("Export Projects");
        this.setMessage("Export Projects in a Zip");
        this.getShell().setText("Export");
        this.getButton(0).setText("Export");
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(comp, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginBottom = 20;
        layout.verticalSpacing = 15;
        container.setLayout((Layout)layout);
        Table projectsTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 3;
        tableLayouData.heightHint = 200;
        projectsTable.setLayoutData((Object)tableLayouData);
        this.projectTableViewer = new CheckboxTableViewer(projectsTable, "Select");
        TableViewerColumn tableColumn2 = new TableViewerColumn((TableViewer)this.projectTableViewer, 4, 1);
        tableColumn2.getColumn().setText("Projects");
        tableColumn2.getColumn().setWidth(550);
        this.projectTableViewer.getTable().setHeaderVisible(true);
        this.projectTableViewer.getTable().setLinesVisible(true);
        this.projectTableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.projectTableViewer.setLabelProvider((IBaseLabelProvider)new EntryLabelProvider());
        this.projectTableViewer.setComparator(new EntryComparator());
        Entry workspaceEntry = PropertyHandler.getDataModel().getRoot();
        ArrayList<Entry> projectEntries = new ArrayList<Entry>();
        this.projectTableViewer.setInput(projectEntries);
        for (Entry child : workspaceEntry.getChildren()) {
            if (!(child.getProperty() instanceof ProjectProperty)) continue;
            projectEntries.add(child);
            this.projectTableViewer.add(child);
            this.projectTableViewer.setChecked(child, this.selectedEntries.contains(child));
        }
        Button selectAllButton = this.addAButton(container, "Select All", 1);
        selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (Entry selectedEntry : (List)ExportEntryDialog.this.projectTableViewer.getInput()) {
                    ExportEntryDialog.this.projectTableViewer.setChecked(selectedEntry, true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button deselectAllButton = this.addAButton(container, "Deselect All", 1);
        deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (Entry selectedEntry : (List)ExportEntryDialog.this.projectTableViewer.getInput()) {
                    ExportEntryDialog.this.projectTableViewer.setChecked(selectedEntry, false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.locationText = new Text(container, 2048);
        GridData textData = new GridData(4, 1, true, false);
        textData.horizontalSpan = 2;
        this.locationText.setLayoutData((Object)textData);
        this.locationText.setText(String.valueOf(System.getProperty("user.home")) + File.separator + DEFAULT_FILENAME);
        this.locationText.setEnabled(false);
        Button browseButton = this.addAButton(container, "Download Here", 128);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExportEntryDialog.this.setErrorMessage(null);
                FileDialog fileDialog = new FileDialog(ExportEntryDialog.this.getShell(), 8192);
                fileDialog.setText("Select File");
                fileDialog.setFilterExtensions(new String[]{ExportEntryDialog.EXTENSION});
                fileDialog.setFilterNames(new String[]{"Grits Export (.GR)"});
                fileDialog.setFileName(ExportEntryDialog.DEFAULT_FILENAME);
                fileDialog.setOverwrite(true);
                String selected = fileDialog.open();
                if (selected != null) {
                    ExportEntryDialog.this.locationText.setText(selected);
                    ExportEntryDialog.this.userSelectedLocation = true;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        browseButton.setFocus();
        container.setLayoutData((Object)new GridData(1808));
        comp.setLayoutData((Object)new GridData(1808));
        return comp;
    }

    private Button addAButton(Composite container, String label, int horizontalAlignment) {
        Button button = new Button(container, 8);
        button.setText(label);
        GridData buttonGridData = new GridData(horizontalAlignment);
        buttonGridData.horizontalSpan = 1;
        buttonGridData.widthHint = 150;
        button.setLayoutData((Object)buttonGridData);
        return button;
    }

    public List<Entry> getSelectedEntries() {
        return this.selectedEntries;
    }

    protected void okPressed() {
        if (this.projectTableViewer.getCheckedElements().length > 0) {
            this.setErrorMessage(null);
            if (this.locationText.getText().isEmpty()) {
                this.setErrorMessage("Choose a location to Save");
            } else if (!this.userSelectedLocation && new File(this.locationText.getText().trim()).exists() && !MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Overwrite File", (String)"Do you want to overwrite an existing export file?")) {
                this.setErrorMessage("A file with this name already exists. Select \"Yes\" to overwrite while exporting.");
            }
            if (this.getErrorMessage() != null) {
                return;
            }
            this.savingLocation = this.locationText.getText().trim();
            this.selectedEntries = new ArrayList<Entry>();
            String workspaceLocationFolder = PropertyHandler.getVariable("workspace_location");
            File workspaceFolder = new File(workspaceLocationFolder);
            if (workspaceFolder.exists()) {
                workspaceLocationFolder = workspaceLocationFolder.substring(0, workspaceLocationFolder.length());
                File[] fileArray = workspaceFolder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File childFile = fileArray[n2];
                    Object[] objectArray = this.projectTableViewer.getCheckedElements();
                    int n3 = objectArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object pj = objectArray[n4];
                        if (pj instanceof Entry) {
                            Entry projectEntry = (Entry)pj;
                            if (childFile.getName().equals(projectEntry.getDisplayName())) {
                                this.selectedEntries.add(projectEntry);
                                break;
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            super.okPressed();
        } else {
            this.setErrorMessage("No Entry selected for export.");
        }
    }

    public String getSavingLocation() {
        return this.savingLocation;
    }
}

