/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.utilShare;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.grits.toolbox.core.preference.IPreferenceUpdateListener;

public class UtilityPreference {
    private static final Logger logger = Logger.getLogger(UtilityPreference.class);

    public static void updateUIs(List<String> preferenceIds) {
        UtilityPreference.updateEditors(preferenceIds);
        UtilityPreference.updateViews(preferenceIds);
    }

    public static void updateEditors(List<String> preferenceIds) {
        if (preferenceIds != null) {
            IEditorPart editorPart = null;
            IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                try {
                    editorPart = editorReference.getEditor(false);
                    if (editorPart instanceof IPreferenceUpdateListener) {
                        ((IPreferenceUpdateListener)editorPart).preferenceUpdated(preferenceIds);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Error updating editor : " + editorReference + "\n" + e.getMessage()), (Throwable)e);
                }
                ++n2;
            }
        }
    }

    public static void updateViews(List<String> preferenceIds) {
        if (preferenceIds != null) {
            IViewPart viewPart = null;
            IViewReference[] iViewReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference viewReference = iViewReferenceArray[n2];
                try {
                    viewPart = viewReference.getView(false);
                    if (viewPart instanceof IPreferenceUpdateListener) {
                        ((IPreferenceUpdateListener)viewPart).preferenceUpdated(preferenceIds);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Error updating view : " + viewReference + "\n" + e.getMessage()), (Throwable)e);
                }
                ++n2;
            }
        }
    }
}

