/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridEditor;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.utilShare.ListenerFactory;
import org.grits.toolbox.core.utilShare.SelectionInterface;
import org.grits.toolbox.core.utilShare.TextFieldUtils;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanAnnotationPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanAnnotationSettingsPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.util.PreferenceUtils;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.MSGlycanAnnotationWizard;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.MassSpecChooserDialog;

public class GeneralInformationMulti
extends WizardPage
implements SelectionInterface {
    private static final Logger logger = Logger.getLogger(GeneralInformationMulti.class);
    protected final Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    private Composite container;
    private Text descriptionText;
    private Label descriptionLabel;
    private String description = "";
    private Grid massSpecGrid = null;
    private Button btnUp = null;
    private Button btnDown = null;
    private Label listLabel;
    private List<Entry> msEntryList = null;
    private HashMap<String, String> listEntries = new HashMap();
    private MassSpecChooserDialog massSpecChooser = null;
    private HashMap<String, MSPropertyDataFile> fileMap = new HashMap();
    private String annotationMethod;
    private Combo cmbSelectSetting;
    protected MSGlycanAnnotationSettingsPreference preferences;
    public static final String FILE_TYPE_GELATO = "GELATO";

    public GeneralInformationMulti(List<Entry> entries) {
        this(entries, "New MS Glycan Annotation", "Identify Glycans using GELATO.", FILE_TYPE_GELATO);
    }

    public GeneralInformationMulti(List<Entry> entries, String title, String description, String annotMethod) {
        super(title);
        this.setTitle(title);
        this.setDescription(description);
        this.msEntryList = entries == null ? new ArrayList<Entry>() : entries;
        this.annotationMethod = annotMethod;
    }

    public void loadPreferences(Class<? extends MSGlycanAnnotationSettingsPreference> preferenceClass, PreferenceEntity preferenceEntity) {
        try {
            this.preferences = PreferenceUtils.getMSGlycanAnnotationSettingsPreferences((PreferenceEntity)preferenceEntity, preferenceClass);
        }
        catch (UnsupportedVersionException e) {
            logger.error((Object)"Cannot load annotation setting preferences", (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)"Cannot load annotation setting preferences", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"Cannot load annotation setting preferences", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"Cannot load annotation setting preferences", (Throwable)e);
        }
    }

    public List<Entry> getMsEntryList() {
        return this.msEntryList;
    }

    public HashMap<String, String> getListEntries() {
        return this.listEntries;
    }

    public HashMap<String, MSPropertyDataFile> getFileMap() {
        return this.fileMap;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.setControl((Control)this.container);
        this.container.setLayout((Layout)new GridLayout(3, false));
        this.initGrid(this.container);
        this.createListHeader(this.container);
        this.createList(this.container);
        this.createAddAndDelButtons(this.container);
        this.createDescriptionHeader(this.container);
        this.createDescription(this.container);
        this.createPreferenceChooser(this.container);
    }

    private void createDescriptionHeader(Composite parent) {
        GridData descriptionData = new GridData();
        this.descriptionLabel = new Label(parent, 0);
        descriptionData.grabExcessHorizontalSpace = true;
        descriptionData.horizontalSpan = 7;
        this.descriptionLabel.setText("Description");
        this.descriptionLabel.setLayoutData((Object)descriptionData);
    }

    private void createDescription(Composite parent) {
        GridData descriptionTextData = new GridData(1808);
        descriptionTextData.minimumHeight = 80;
        descriptionTextData.grabExcessHorizontalSpace = true;
        descriptionTextData.horizontalSpan = 7;
        this.descriptionText = new Text(parent, 2562);
        this.descriptionText.setLayoutData((Object)descriptionTextData);
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneralInformationMulti.this.isReadyToFinish()) {
                    GeneralInformationMulti.this.setPageComplete(true);
                } else {
                    GeneralInformationMulti.this.setPageComplete(false);
                }
            }
        });
        this.descriptionText.addTraverseListener(ListenerFactory.getTabTraverseListener());
        this.descriptionText.addKeyListener(ListenerFactory.getCTRLAListener());
    }

    private void createPreferenceChooser(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 2, 1);
        Label lblSelectSetting = new Label(parent, 0);
        lblSelectSetting.setText("Preference Setting to Use");
        lblSelectSetting.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 5, 1);
        this.cmbSelectSetting = new Combo(parent, 0);
        this.cmbSelectSetting.setLayoutData((Object)gd2);
        this.initStoredSettingList();
        this.cmbSelectSetting.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralInformationMulti.this.cmbSelectSetting.getSelectionIndex() != -1) {
                    String preferenceName = GeneralInformationMulti.this.cmbSelectSetting.getItem(GeneralInformationMulti.this.cmbSelectSetting.getSelectionIndex());
                    if (GeneralInformationMulti.this.preferences != null && GeneralInformationMulti.this.preferences.getPreferenceList() != null) {
                        for (MSGlycanAnnotationPreference setting : GeneralInformationMulti.this.preferences.getPreferenceList()) {
                            if (!setting.getName().equals(preferenceName)) continue;
                            ((MSGlycanAnnotationWizard)GeneralInformationMulti.this.getWizard()).setPreferences(setting);
                            if (GeneralInformationMulti.this.isReadyToFinish()) {
                                GeneralInformationMulti.this.setPageComplete(true);
                                break;
                            }
                            GeneralInformationMulti.this.setPageComplete(false);
                            break;
                        }
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.cmbSelectSetting.getItemCount() > 0) {
            this.cmbSelectSetting.select(0);
        }
    }

    protected void initStoredSettingList() {
        this.cmbSelectSetting.removeAll();
        this.cmbSelectSetting.add("");
        if (this.preferences != null && this.preferences.getPreferenceList() != null) {
            for (MSGlycanAnnotationPreference setting : this.preferences.getPreferenceList()) {
                this.cmbSelectSetting.add(setting.getName());
            }
        }
    }

    private void initGrid(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 7;
        gridLayout.verticalSpacing = 10;
        parent.setLayout((Layout)gridLayout);
    }

    private void createListHeader(Composite parent) {
        GridData listLabelData = new GridData();
        this.listLabel = new Label(parent, 0);
        listLabelData.grabExcessHorizontalSpace = true;
        listLabelData.horizontalSpan = 7;
        this.listLabel.setText("Mass Spec Analyses to Process");
        this.listLabel.setLayoutData((Object)listLabelData);
        this.listLabel = this.setMandatoryLabel(this.listLabel);
    }

    private void createList(Composite parent) {
        this.massSpecGrid = new Grid(parent, 2048);
        this.massSpecGrid.setHeaderVisible(true);
        GridColumn gridColumn = new GridColumn(this.massSpecGrid, 0);
        gridColumn.setWidth(300);
        gridColumn.setText("Mass Spec Entry Name");
        GridColumn gridColumn2 = new GridColumn(this.massSpecGrid, 0);
        gridColumn2.setWidth(300);
        gridColumn2.setText("Annotation Result Name");
        GridColumn gridColumn3 = new GridColumn(this.massSpecGrid, 0);
        gridColumn3.setWidth(300);
        gridColumn3.setText("Annotation File");
        this.setListData();
        GridData gridData = new GridData(1808);
        gridData.minimumHeight = 80;
        gridData.horizontalSpan = 6;
        gridData.verticalSpan = 2;
        this.massSpecGrid.setLayoutData((Object)gridData);
        this.btnUp = new Button(parent, 2180);
        this.btnUp.setText("Up");
        GridData gdBtnUp = new GridData(0x1000008, 1, false, true);
        gdBtnUp.horizontalSpan = 1;
        this.btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GeneralInformationMulti.this.moveItem(128);
            }
        });
        this.btnUp.setLayoutData((Object)gdBtnUp);
        this.btnDown = new Button(parent, 3076);
        this.btnDown.setText("D");
        GridData gdBtnDown = new GridData(0x1000008, 0x1000008, false, true);
        gdBtnDown.horizontalSpan = 1;
        this.btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GeneralInformationMulti.this.moveItem(1024);
            }
        });
        this.btnDown.setLayoutData((Object)gdBtnDown);
        this.massSpecGrid.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                if (GeneralInformationMulti.this.isReadyToFinish()) {
                    GeneralInformationMulti.this.setPageComplete(true);
                } else {
                    GeneralInformationMulti.this.setPageComplete(false);
                }
            }
        });
        final GridEditor editor = new GridEditor(this.massSpecGrid);
        final GridEditor editor2 = new GridEditor(this.massSpecGrid);
        this.massSpecGrid.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Point pt = new Point(e.x, e.y);
                final GridItem item = GeneralInformationMulti.this.massSpecGrid.getItem(pt);
                final Point cell = GeneralInformationMulti.this.massSpecGrid.getCell(pt);
                if (item == null || cell == null) {
                    return;
                }
                if (cell.x == 0) {
                    return;
                }
                GeneralInformationMulti.this.massSpecGrid.deselect(cell.y);
                if (cell.x == 1) {
                    Control oldEditor = editor.getEditor();
                    if (oldEditor != null) {
                        oldEditor.dispose();
                    }
                    final Text newEditor = new Text((Composite)GeneralInformationMulti.this.massSpecGrid, 2052);
                    String curText = item.getText(cell.x);
                    newEditor.setText(curText);
                    editor.setEditor((Control)newEditor, item, cell.x);
                    editor.grabHorizontal = true;
                    editor.grabVertical = true;
                    newEditor.addKeyListener(new KeyListener(){

                        public void keyReleased(KeyEvent e) {
                            item.setText(cell.x, newEditor.getText());
                            GeneralInformationMulti.this.listEntries.put(item.getText(0), newEditor.getText());
                            if (GeneralInformationMulti.this.isReadyToFinish()) {
                                GeneralInformationMulti.this.setPageComplete(true);
                            } else {
                                GeneralInformationMulti.this.setPageComplete(false);
                            }
                        }

                        public void keyPressed(KeyEvent e) {
                        }
                    });
                    newEditor.forceFocus();
                    newEditor.setSelection(newEditor.getText().length());
                    newEditor.selectAll();
                } else if (cell.x == 2) {
                    Control oldEditor = editor2.getEditor();
                    if (oldEditor != null) {
                        oldEditor.dispose();
                    }
                    ComboViewer fileCombo = new ComboViewer((Composite)GeneralInformationMulti.this.massSpecGrid, 0);
                    fileCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
                    fileCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof MSPropertyDataFile) {
                                String fileName = ((MSPropertyDataFile)element).getName();
                                if (!fileName.isEmpty() && fileName.contains(File.separator)) {
                                    fileName = fileName.substring(fileName.lastIndexOf(File.separator) + 1);
                                }
                                return fileName;
                            }
                            return super.getText(element);
                        }
                    });
                    List fileList = GeneralInformationMulti.this.getAnnotationFilesForEntry(item.getText(0));
                    fileCombo.setInput((Object)fileList);
                    editor2.minimumWidth = 100;
                    editor2.grabHorizontal = true;
                    editor2.grabVertical = true;
                    editor2.setEditor((Control)fileCombo.getCombo(), item, cell.x);
                    fileCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                        public void selectionChanged(SelectionChangedEvent event) {
                            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                            if (selection.size() > 0) {
                                item.setText(cell.x, ((MSPropertyDataFile)selection.getFirstElement()).getName());
                                GeneralInformationMulti.this.fileMap.put(item.getText(0), (MSPropertyDataFile)selection.getFirstElement());
                            }
                            if (GeneralInformationMulti.this.isReadyToFinish()) {
                                GeneralInformationMulti.this.setPageComplete(true);
                            } else {
                                GeneralInformationMulti.this.setPageComplete(false);
                            }
                        }
                    });
                    fileCombo.setSelection((ISelection)new StructuredSelection(fileList.get(0)));
                }
            }
        });
    }

    private List<MSPropertyDataFile> getAnnotationFilesForEntry(String displayName) {
        ArrayList<MSPropertyDataFile> annotationFiles = new ArrayList<MSPropertyDataFile>();
        for (Entry e : this.msEntryList) {
            if (!e.getDisplayName().equals(displayName)) continue;
            Property prop = e.getProperty();
            if (!(prop instanceof MassSpecProperty)) break;
            List files = ((MassSpecProperty)prop).getMassSpecMetaData().getAnnotationFiles();
            for (MSPropertyDataFile propertyDataFile : files) {
                annotationFiles.add(propertyDataFile);
            }
        }
        return annotationFiles;
    }

    String[] getAnnotationFileNamesForEntry(String displayName) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (Entry e : this.msEntryList) {
            if (!e.getDisplayName().equals(displayName)) continue;
            Property prop = e.getProperty();
            if (!(prop instanceof MassSpecProperty)) break;
            List files = ((MassSpecProperty)prop).getMassSpecMetaData().getAnnotationFiles();
            for (MSPropertyDataFile propertyDataFile : files) {
                fileNames.add(propertyDataFile.getName());
            }
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    public static String getAnnotationPostfix(String annotationMethod) {
        long timeNow = System.currentTimeMillis();
        String secs = Long.toString(timeNow);
        secs = secs.substring(9);
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        int year = calendar.get(1);
        String stamp = String.valueOf(year) + "." + month + "." + day + "_" + secs;
        return "." + annotationMethod + "." + stamp;
    }

    private void setListData() {
        int i = 0;
        while (i < this.msEntryList.size()) {
            Entry entry = this.msEntryList.get(i);
            String displayName = entry.getDisplayName();
            String stamp = GeneralInformationMulti.getAnnotationPostfix(this.annotationMethod);
            String annotName = String.valueOf(displayName) + stamp;
            this.listEntries.put(displayName, annotName);
            GridItem item = new GridItem(this.massSpecGrid, 0);
            item.setText(0, displayName);
            item.setBackground(0, Display.getCurrent().getSystemColor(22));
            item.setText(1, annotName);
            List<MSPropertyDataFile> fileList = this.getAnnotationFilesForEntry(displayName);
            if (fileList != null && !fileList.isEmpty()) {
                String fileName = fileList.get(0).getName();
                if (!fileName.isEmpty() && fileName.contains(File.separator)) {
                    fileName = fileName.substring(fileName.lastIndexOf(File.separator) + 1);
                }
                item.setText(2, fileName);
                this.fileMap.put(displayName, fileList.get(0));
            }
            ++i;
        }
        if (this.isReadyToFinish()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private void moveItem(int direction) {
        int iFoundPos = this.massSpecGrid.getSelectionIndex();
        if (iFoundPos < 0) {
            return;
        }
        GridItem foundItem = this.massSpecGrid.getItem(iFoundPos);
        GridItem switchItem = null;
        int iSwitchInx = -1;
        if (direction == 128) {
            if (iFoundPos == 0) {
                return;
            }
            iSwitchInx = iFoundPos - 1;
        } else {
            if (iFoundPos == this.massSpecGrid.getItemCount() - 1) {
                return;
            }
            iSwitchInx = iFoundPos + 1;
        }
        switchItem = this.massSpecGrid.getItem(iSwitchInx);
        String s0 = switchItem.getText(0);
        String s1 = switchItem.getText(1);
        switchItem.setText(0, foundItem.getText(0));
        switchItem.setText(1, foundItem.getText(1));
        foundItem.setText(0, s0);
        foundItem.setText(1, s1);
        this.massSpecGrid.setSelection(iSwitchInx);
        Entry curEntry = this.msEntryList.remove(iFoundPos);
        this.msEntryList.add(iSwitchInx, curEntry);
        logger.debug((Object)"Done with move");
    }

    private void createAddAndDelButtons(Composite parent) {
        Label dummy = new Label(parent, 0);
        GridData gdDummy = new GridData();
        dummy.setLayoutData((Object)gdDummy);
        Label dummy2 = new Label(parent, 0);
        GridData gdDummy2 = new GridData();
        gdDummy2.horizontalSpan = 2;
        gdDummy2.grabExcessHorizontalSpace = true;
        dummy2.setLayoutData((Object)gdDummy2);
        Label dummy3 = new Label(parent, 0);
        GridData gdDummy3 = new GridData();
        dummy3.setLayoutData((Object)gdDummy3);
        GridData gdAddBtn = new GridData();
        gdAddBtn.grabExcessHorizontalSpace = false;
        gdAddBtn.horizontalAlignment = 3;
        gdAddBtn.horizontalSpan = 1;
        Button btnAddButton = new Button(parent, 8);
        btnAddButton.setText("  Add  ");
        this.massSpecChooser = new MassSpecChooserDialog("org.grits.toolbox.property.ms_annotation", "Select MS Entry", "Select an MS Entry", this.annotationMethod);
        this.massSpecChooser.setParent(parent);
        this.massSpecChooser.setList(this.massSpecGrid);
        this.massSpecChooser.setListEntries(this.listEntries);
        this.massSpecChooser.setEntries(this.msEntryList);
        btnAddButton.addSelectionListener((SelectionListener)this.massSpecChooser);
        btnAddButton.setLayoutData((Object)gdAddBtn);
        Button deleteButton = new Button(parent, 8);
        GridData gdDelBtn = new GridData();
        gdDelBtn.grabExcessHorizontalSpace = false;
        gdDelBtn.horizontalAlignment = 3;
        gdDelBtn.horizontalSpan = 1;
        deleteButton.setText("Delete");
        deleteButton.setLayoutData((Object)gdDelBtn);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int iRemoveInx = GeneralInformationMulti.this.massSpecGrid.getSelectionIndex();
                if (iRemoveInx == -1) {
                    return;
                }
                GeneralInformationMulti.this.fileMap.remove(GeneralInformationMulti.this.massSpecGrid.getItem(iRemoveInx).getText(0).trim());
                GeneralInformationMulti.this.msEntryList.remove(iRemoveInx);
                GeneralInformationMulti.this.massSpecGrid.remove(iRemoveInx);
                GeneralInformationMulti.this.listEntries.clear();
                int i = 0;
                while (i < GeneralInformationMulti.this.massSpecGrid.getItemCount()) {
                    String displayName = GeneralInformationMulti.this.massSpecGrid.getItem(i).getText(0).trim();
                    String alias = GeneralInformationMulti.this.massSpecGrid.getItem(i).getText(1).trim();
                    GeneralInformationMulti.this.listEntries.put(displayName, alias);
                    ++i;
                }
                if (GeneralInformationMulti.this.listEntries.isEmpty()) {
                    GeneralInformationMulti.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(parent, 0);
    }

    protected Label createSeparator(Composite container, int span) {
        GridData separatorData = new GridData();
        separatorData.grabExcessHorizontalSpace = true;
        separatorData.horizontalAlignment = 4;
        separatorData.horizontalSpan = span;
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)separatorData);
        return separator;
    }

    protected Label setMandatoryLabel(Label lable) {
        lable.setText(String.valueOf(lable.getText()) + "*");
        lable.setFont(this.boldFont);
        return lable;
    }

    public void setMassSpecEntryList(List<Entry> msEntryList) {
        this.msEntryList = msEntryList;
    }

    public static boolean isDuplicateDisplayName(String _sDisplayName, Entry root) {
        ArrayList<Entry> alStack = new ArrayList<Entry>();
        alStack.add(root);
        while (!alStack.isEmpty()) {
            Entry curEntry = (Entry)alStack.remove(0);
            if (curEntry.getDisplayName().trim().equals(_sDisplayName)) {
                return true;
            }
            List children = curEntry.getChildren();
            for (Entry child : children) {
                alStack.add(child);
            }
        }
        return false;
    }

    private boolean isReadyToFinish() {
        if (this.msEntryList == null || this.msEntryList.isEmpty() || this.listEntries == null || this.listEntries.isEmpty()) {
            this.setErrorMessage("Please select one or more MS entries for annotation.");
            return false;
        }
        Entry root = PropertyHandler.getDataModel().getRoot();
        Set<String> sKeys = this.listEntries.keySet();
        Iterator<String> itr = sKeys.iterator();
        ArrayList<String> newEntries = new ArrayList<String>();
        while (itr.hasNext()) {
            String sEntryName = itr.next();
            String sNameText = this.listEntries.get(sEntryName);
            MSPropertyDataFile file = this.fileMap.get(sEntryName);
            if (sNameText.trim().equals("")) {
                this.setErrorMessage("Please enter a name for entry: " + sEntryName);
                return false;
            }
            if (sNameText.trim().length() >= 128) {
                this.setErrorMessage("Name for entry: " + sEntryName + " must be less than 128 characters.");
                return false;
            }
            if (file == null || file.getName() == null || file.getName().isEmpty()) {
                if (this.getAnnotationFilesForEntry(sEntryName).isEmpty()) {
                    this.setErrorMessage("There are no files that can be used for annotation for entry: " + sEntryName + ". \nPlease go back to the entry and convert instrument files as necessary!");
                } else {
                    this.setErrorMessage("Please choose a file for annotation for entry: " + sEntryName);
                }
                return false;
            }
            if (GeneralInformationMulti.isDuplicateDisplayName(sNameText, root)) {
                this.setErrorMessage("Name for entry: " + sEntryName + " (" + sNameText + ") already exists.");
                return false;
            }
            newEntries.add(sNameText);
        }
        if (this.descriptionText != null && !TextFieldUtils.isEmpty((Text)this.descriptionText) && this.descriptionText.getText().trim().length() >= Integer.parseInt(PropertyHandler.getVariable((String)"descriptionLength"))) {
            this.setErrorMessage("Description must be less than 1024 characters.");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void save() {
        this.description = this.descriptionText.getText().trim();
    }

    public IWizardPage getNextPage() {
        this.save();
        return super.getNextPage();
    }

    public String getMSDescription() {
        return this.description;
    }

    public void setMSDescription(String description) {
        this.description = description;
    }

    public void updateComponent(SelectionAdapter adapter) {
    }
}

