/*
 * Decompiled with CFR 0.152.
 */
package com.apporiented.algorithm.clustering;

import com.apporiented.algorithm.clustering.Distance;
import java.util.ArrayList;
import java.util.List;

public class Cluster {
    private String name;
    private Cluster parent;
    private List<Cluster> children;
    private Distance distance = new Distance();

    public Distance getDistance() {
        return this.distance;
    }

    public Double getWeightValue() {
        return this.distance.getWeight();
    }

    public Double getDistanceValue() {
        return this.distance.getDistance();
    }

    public void setDistance(Distance distance) {
        this.distance = distance;
    }

    public List<Cluster> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<Cluster>();
        }
        return this.children;
    }

    public void setChildren(List<Cluster> children) {
        this.children = children;
    }

    public Cluster getParent() {
        return this.parent;
    }

    public void setParent(Cluster parent) {
        this.parent = parent;
    }

    public Cluster(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addChild(Cluster cluster) {
        this.getChildren().add(cluster);
    }

    public boolean contains(Cluster cluster) {
        return this.getChildren().contains(cluster);
    }

    public String toString() {
        return "Cluster " + this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean isLeaf() {
        return this.getChildren().size() == 0;
    }

    public int countLeafs() {
        return this.countLeafs(this, 0);
    }

    public int countLeafs(Cluster node, int count) {
        if (node.isLeaf()) {
            ++count;
        }
        for (Cluster child : node.getChildren()) {
            count += child.countLeafs();
        }
        return count;
    }

    public void toConsole(int indent) {
        int i = 0;
        while (i < indent) {
            System.out.print("  ");
            ++i;
        }
        String name = String.valueOf(this.getName()) + (this.isLeaf() ? " (leaf)" : "") + (this.distance != null ? "  distance: " + this.distance : "");
        System.out.println(name);
        for (Cluster child : this.getChildren()) {
            child.toConsole(indent + 1);
        }
    }

    public double getTotalDistance() {
        Double dist = this.getDistance() == null ? 0.0 : this.getDistance().getDistance();
        if (this.getChildren().size() > 0) {
            dist = dist + this.children.get(0).getTotalDistance();
        }
        return dist;
    }
}

