/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.dango;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eurocarbdb.application.glycanbuilder.Atom;
import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.FragmentCollection;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.Fragmenter;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.Molecule;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.grits.toolbox.ms.annotation.structure.AnalyteStructure;
import org.grits.toolbox.ms.annotation.structure.GlycanDatabase;
import org.grits.toolbox.ms.annotation.structure.GlycanPreDefinedOptions;
import org.grits.toolbox.ms.annotation.structure.GlycanStructure;
import org.grits.toolbox.ms.om.data.Fragment;
import org.grits.toolbox.ms.om.data.GlycanSettings;
import org.grits.toolbox.tools.gsl.util.analyze.glycan.GWBSequenceToComposition;
import org.grits.toolbox.tools.gsl.util.io.glycan.GlycanDatabaseFileHandler;
import org.grits.toolbox.tools.gsl.util.mass.AtomicMass;
import org.grits.toolbox.tools.gsl.util.mass.ChemicalComposition;

public class GlycanAnnotationUtils {
    public static final Logger logger = Logger.getLogger(GlycanAnnotationUtils.class);
    private static Map<String, String> mapGWBSeqToComposition = new HashMap<String, String>();

    public static List<String[]> generateGlycanFragments(String a_strGSeq, boolean a_bMono, String a_strPerDeriv, List<Fragment> a_lFragments, int a_nMaxClvg, int a_nMaxClvgCR) {
        ArrayList<String[]> t_lFragmentSeqs = new ArrayList<String[]>();
        new BuilderWorkspace((GlycanRenderer)new GlycanRendererAWT());
        Fragmenter t_fragmenter = new Fragmenter();
        t_fragmenter.setComputeBFragments(false);
        t_fragmenter.setComputeYFragments(false);
        t_fragmenter.setComputeCFragments(false);
        t_fragmenter.setComputeZFragments(false);
        t_fragmenter.setComputeAFragments(false);
        t_fragmenter.setComputeXFragments(false);
        t_fragmenter.setIterate_ion_combinations(false);
        for (Fragment fragment : a_lFragments) {
            if (fragment.getType().equals("B")) {
                t_fragmenter.setComputeBFragments(true);
                continue;
            }
            if (fragment.getType().equals("Y")) {
                t_fragmenter.setComputeYFragments(true);
                continue;
            }
            if (fragment.getType().equals("C")) {
                t_fragmenter.setComputeCFragments(true);
                continue;
            }
            if (fragment.getType().equals("Z")) {
                t_fragmenter.setComputeZFragments(true);
                continue;
            }
            if (fragment.getType().equals("A")) {
                t_fragmenter.setComputeAFragments(true);
                continue;
            }
            if (!fragment.getType().equals("X")) continue;
            t_fragmenter.setComputeXFragments(true);
        }
        t_fragmenter.setMaxNoCleavages(a_nMaxClvg);
        t_fragmenter.setMaxNoCrossRings(a_nMaxClvgCR);
        try {
            Glycan t_glycan = Glycan.fromString((String)a_strGSeq);
            GlycanAnnotationUtils.setMassOptions(t_glycan, a_bMono, a_strPerDeriv);
            FragmentCollection fc = t_fragmenter.computeAllFragments(t_glycan);
            for (FragmentEntry t_ent : (List)fc.getFragments()) {
                String[] t_strStructureAndFragType = new String[]{t_ent.getStructure(), t_ent.name};
                t_lFragmentSeqs.add(t_strStructureAndFragType);
            }
        }
        catch (Exception e) {
            logger.error((Object)"An error in glycan fragment generation", (Throwable)e);
        }
        return t_lFragmentSeqs;
    }

    public static String generateGlycanComposition(String a_strGSeq) {
        if (a_strGSeq == null || a_strGSeq.isEmpty()) {
            return "";
        }
        if (!mapGWBSeqToComposition.containsKey(a_strGSeq)) {
            GWBSequenceToComposition t_exchange = new GWBSequenceToComposition();
            mapGWBSeqToComposition.put(a_strGSeq, t_exchange.getCompositionString(a_strGSeq));
        }
        return mapGWBSeqToComposition.get(a_strGSeq);
    }

    public static double calculateGlycanMass(String a_strGSeq, boolean a_bMono, String t_strPerDerivType) {
        Glycan t_glycan = Glycan.fromString((String)a_strGSeq);
        GlycanAnnotationUtils.setMassOptions(t_glycan, a_bMono, t_strPerDerivType);
        double t_dGMass = t_glycan.computeMass();
        String[] t_strCleavages = new String[]{"S/#lcleavage", "P/#lcleavage"};
        int t_nCleavages = 0;
        String[] stringArray = t_strCleavages;
        int n = t_strCleavages.length;
        int n2 = 0;
        while (n2 < n) {
            String t_strCleavage = stringArray[n2];
            if (a_strGSeq.contains(t_strCleavage)) {
                int t_iSize = a_strGSeq.length();
                int t_iReplaced = a_strGSeq.replace(t_strCleavage, "").length();
                t_nCleavages += (t_iSize - t_iReplaced) / t_strCleavage.length();
            }
            ++n2;
        }
        return t_dGMass -= 18.0105646844 * (double)t_nCleavages;
    }

    public static ChemicalComposition calculateGlycanChemicalComposition(String a_strGSeq, boolean a_bMono, String t_strPerDerivType) {
        Glycan t_glycan = Glycan.fromString((String)a_strGSeq);
        GlycanAnnotationUtils.setMassOptions(t_glycan, a_bMono, t_strPerDerivType);
        try {
            ChemicalComposition t_cc = new ChemicalComposition();
            Molecule m = t_glycan.computeMolecule();
            for (Map.Entry a : m.getAtoms()) {
                t_cc.addNumberOfElements(AtomicMass.forSymbol(((Atom)a.getKey()).getSymbol()), (Integer)a.getValue());
            }
            return t_cc;
        }
        catch (Exception e) {
            logger.error((Object)"Cannot calculate chemical composition from Glycan.", (Throwable)e);
            return null;
        }
    }

    public static List<String[]> getGWBSequencesAndGlycanID(GlycanSettings a_gSettings) {
        ArrayList<String[]> t_lGWBSeqIDs = new ArrayList<String[]>();
        GlycanDatabase t_gDB = GlycanDatabaseFileHandler.getGlycanDatabase(a_gSettings.getFilter().getDatabase());
        if (t_gDB != null) {
            boolean t_bHasDuplicated = false;
            HashMap t_mapIdToStructures = new HashMap();
            for (AnalyteStructure t_gStructure : t_gDB.getStructures()) {
                if (!t_mapIdToStructures.containsKey(t_gStructure.getId())) {
                    t_mapIdToStructures.put(t_gStructure.getId(), new ArrayList());
                }
                ((List)t_mapIdToStructures.get(t_gStructure.getId())).add(t_gStructure);
                if (t_bHasDuplicated || ((List)t_mapIdToStructures.get(t_gStructure.getId())).size() <= 1) continue;
                t_bHasDuplicated = true;
            }
            if (t_bHasDuplicated) {
                for (String t_strId : t_mapIdToStructures.keySet()) {
                    List t_lStructures = (List)t_mapIdToStructures.get(t_strId);
                    if (t_lStructures.size() == 1) continue;
                    int i = 1;
                    for (AnalyteStructure t_gStructure : t_lStructures) {
                        t_gStructure.setId(String.valueOf(t_strId) + "." + i++);
                    }
                }
            }
            for (AnalyteStructure t_gStructure : t_gDB.getStructures()) {
                String[] t_GWBSeqID = new String[]{((GlycanStructure)t_gStructure).getGWBSequence(), t_gStructure.getId()};
                t_lGWBSeqIDs.add(t_GWBSeqID);
            }
        }
        return t_lGWBSeqIDs;
    }

    public static boolean isPermethylated(String a_strPerDerivForGRITS) {
        return a_strPerDerivForGRITS.equals(GlycanPreDefinedOptions.DERIVITIZATION_PERMETHYLATED);
    }

    public static boolean canConnectReducingEnd(String a_strGSeq) {
        return a_strGSeq.startsWith("freeEnd");
    }

    public static void setMassOptions(Glycan a_glycan, boolean a_bIsMono, String a_strPerDerivForGRITS) {
        MassOptions t_massOptions = new MassOptions();
        String t_strDerivTypeForMassOption = a_strPerDerivForGRITS.equals(GlycanPreDefinedOptions.DERIVITIZATION_PERMETHYLATED) ? "perMe" : (a_strPerDerivForGRITS.equals(GlycanPreDefinedOptions.DERIVITIZATION_HEAVYPERMETHYLATION) ? "perMe(C^13)" : (a_strPerDerivForGRITS.equals(GlycanPreDefinedOptions.DERIVITIZATION_PERDMETHYLATED) ? "perDMe" : (a_strPerDerivForGRITS.equals(GlycanPreDefinedOptions.DERIVITIZATION_PERACETYLATED) ? "perAc" : (a_strPerDerivForGRITS.equals(GlycanPreDefinedOptions.DERIVITIZATION_PERDACETYLATED) ? "perDAc" : "Und"))));
        t_massOptions.setDerivatization(t_strDerivTypeForMassOption);
        if (a_bIsMono) {
            t_massOptions.setIsotope("MONO");
        } else {
            t_massOptions.setIsotope("AVG");
        }
        t_massOptions.ION_CLOUD = new IonCloud();
        t_massOptions.NEUTRAL_EXCHANGES = new IonCloud();
        t_massOptions.setReducingEndType(ResidueDictionary.findResidueType((String)"freeEnd"));
        a_glycan.setMassOptions(t_massOptions);
    }
}

