/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.img.ImageShare;
import org.grits.toolbox.entry.archive.editor.ArchiveEntryEditor;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.FileArchivePage;
import org.grits.toolbox.entry.archive.model.ArchivedFile;

public class DeleteArchivedFile
extends Action {
    private Logger logger = Logger.getLogger(DeleteArchivedFile.class);
    public static final ImageDescriptor DELETE_ICON = ImageShare.DELETE_ICON;
    private FileArchivePage page = null;

    public DeleteArchivedFile(FileArchivePage fileArchivePage) {
        this.page = fileArchivePage;
        this.setText("Delete");
        this.setToolTipText("Delete the File");
        ImageDescriptor imageDesc = DELETE_ICON;
        Image image = imageDesc.createImage();
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
    }

    public void run() {
        TreeViewer treeViewer = this.page.getLeftSideTreeViewer();
        TreeSelection treeSelection = (TreeSelection)treeViewer.getSelection();
        if (treeSelection.isEmpty()) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"No File Selected", (String)"Please select a file to delete.");
        } else if (treeSelection.getFirstElement() instanceof ArchivedFile) {
            int selectionIndex = treeViewer.getTree().indexOf(treeViewer.getTree().getSelection()[0]);
            List inputArchivedFiles = (List)treeViewer.getInput();
            ArchivedFile archivedFileToDelete = (ArchivedFile)treeSelection.getFirstElement();
            boolean delete = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Delete Archive", (String)("Are you sure you want to delete this file \"" + archivedFileToDelete.getTypicalArchivedFile().getFileName() + "\" from the archive?"));
            ArchiveEntryEditor archiveEntryEditor = this.page.getEditor();
            if (delete) {
                boolean deleted = false;
                try {
                    File archiveFolder = archiveEntryEditor.getArchiveFolder();
                    File fileArchive = new File(archiveFolder, archivedFileToDelete.getTypicalArchivedFile().getFileName());
                    new FileInputStream(fileArchive).close();
                    this.logger.debug((Object)("Deleting File from the archive : \n" + fileArchive.getName()));
                    Files.delete(fileArchive.toPath());
                    deleted = true;
                }
                catch (FileNotFoundException ex) {
                    this.logger.error((Object)("The file was not found in the archive.\n" + ex.getMessage()), (Throwable)ex);
                    deleted = true;
                }
                catch (NoSuchFileException ex) {
                    this.logger.error((Object)("The file was not found in the archive.\n" + ex.getMessage()), (Throwable)ex);
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Delete Error", (String)"The file was not found in the archive.");
                    deleted = true;
                }
                catch (DirectoryNotEmptyException ex) {
                    this.logger.error((Object)("Error deleting non empty folder.\n" + ex.getMessage()), (Throwable)ex);
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Delete Error", (String)"The folder is not empty and could not be deleted from archive.");
                }
                catch (Exception ex) {
                    this.logger.error((Object)("Error deleting file to archive.\n" + ex.getMessage()), (Throwable)ex);
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Delete Error", (String)"The file could not be deleted from GRITS. Please report this error to the development team");
                }
                if (deleted) {
                    try {
                        inputArchivedFiles.remove(archivedFileToDelete);
                        archiveEntryEditor.removeArchivedFile(archivedFileToDelete);
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)("Error removing entry from archive.\n" + ex.getMessage()), (Throwable)ex);
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Delete Error", (String)"Error removing entry from archive. Please report this error to the development team");
                    }
                }
                treeViewer.refresh();
                selectionIndex = Math.max(0, selectionIndex - 1);
                if (selectionIndex >= 0 && selectionIndex < inputArchivedFiles.size()) {
                    treeViewer.getTree().select(treeViewer.getTree().getItem(selectionIndex));
                    treeViewer.setSelection(treeViewer.getSelection());
                } else {
                    this.page.setSelection(null);
                }
            }
        }
        this.logger.debug((Object)"End - Deleting  Archived File");
    }
}

