/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.pages.rightside.category;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.category.AddDescriptorGroupToCategoryAction;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.category.AddDescriptorToCategoryAction;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.category.DeleteDescriptorFromCategoryAction;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.category.DeleteDescriptorGroupFromCategoryAction;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.general.CheckboxTableUtility;
import org.grits.toolbox.editor.samplemanager.pages.general.SectionUtility;
import org.grits.toolbox.editor.samplemanager.pages.rightside.RightSideSection;
import org.grits.toolbox.editor.samplemanager.pages.rightside.category.CategoryDescriptorGroupMembersContentProvider;
import org.grits.toolbox.editor.samplemanager.pages.rightside.category.CategoryDescriptorMembersContentProvider;
import org.grits.toolbox.editor.samplemanager.pages.rightside.category.CategoryMemberLabelProvider;
import org.grits.toolbox.editor.samplemanager.util.TableColumnTextComparator;
import org.grits.toolbox.entry.sample.model.Category;

public class RightSideCategorySection
extends RightSideSection {
    private Logger logger = Logger.getLogger(RightSideCategorySection.class);
    private Category selectedCategory;
    private String labelForCategory = null;
    private HashMap<String, String> uriLabelMap;
    private AddDescriptorToCategoryAction addDescriptorToCategoryAction;
    private DeleteDescriptorFromCategoryAction deleteDescriptorFromCategoryAction;
    private Composite descriptorListSectionComposite;
    private CheckboxTableViewer tableViewer;
    private Section descriptorListSection;
    private Section descriptorGroupListSection;
    private CheckboxTableViewer dgTableViewer;
    private AddDescriptorGroupToCategoryAction addDescriptorGroupToCategoryAction;
    private DeleteDescriptorGroupFromCategoryAction deleteDescriptorGroupFromCategoryAction;
    private Composite descriptorGroupListSectionComposite;

    public RightSideCategorySection(AbstractManagementPage page, HashMap<String, String> uriLabelMap) {
        super(page);
        this.uriLabelMap = uriLabelMap;
    }

    @Override
    protected void createLineForLabel(Composite rightSideComposite) {
        this.labelLabel = this.toolkit.createLabel(rightSideComposite, "Label*");
        this.labelLabel.setFont(this.boldFont);
        GridData labelGridData = new GridData();
        labelGridData.widthHint = 178;
        this.labelLabel.setLayoutData((Object)labelGridData);
        this.labelForCategory = this.uriLabelMap.get(this.selectedCategory.getUri());
        this.labelText = this.toolkit.createText(rightSideComposite, this.labelForCategory, 76);
        GridData textGridData = new GridData(2);
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.widthHint = 550;
        textGridData.horizontalSpan = 3;
        textGridData.verticalSpan = 3;
        this.labelText.setLayoutData((Object)textGridData);
    }

    @Override
    protected void createDescriptionLine(Composite rightSideComposite) {
    }

    @Override
    protected void createSpecificPart() {
        this.logger.debug((Object)"- START : Creating specific part in right side category section.");
        try {
            this.createDescriptorTableSection();
            this.createDescriptorGroupTableSection();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Creating specific part in right side category section.");
    }

    @Override
    public void reset() {
        this.logger.debug((Object)"- START : Resetting right side Category section for the selection.");
        try {
            this.rightSideSection.setClient((Control)this.rightSideComposite);
            this.rightSideSection.setExpanded(false);
            this.labelForCategory = this.uriLabelMap.get(this.selectedCategory.getUri());
            this.rightSideSection.setText("General Info : " + this.labelForCategory);
            this.labelText.setText(this.labelForCategory);
            this.rightSideSection.setExpanded(true);
            this.rightSideSection.update();
            this.resetSpecificPart();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Resetting right side Category section for the selection.");
    }

    @Override
    protected void resetSpecificPart() {
        this.tableViewer.setInput((Object)this.selectedCategory);
        this.dgTableViewer.setInput((Object)this.selectedCategory);
    }

    private void createDescriptorTableSection() {
        this.descriptorListSection = SectionUtility.createSectionForCategory(this.toolkit, this.page.getRightComposite(), "Descriptors");
        this.descriptorListSectionComposite = SectionUtility.getCompositeInsideSection(this.toolkit, this.descriptorListSection, 1, 10, 2, 2);
        this.tableViewer = CheckboxTableUtility.createCheckboxTableViewer(this.page, this.descriptorListSectionComposite, 0, "Descriptors");
        this.tableViewer.setContentProvider((IContentProvider)new CategoryDescriptorMembersContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new CategoryMemberLabelProvider());
        this.tableViewer.setComparator((ViewerComparator)new TableColumnTextComparator());
        final TableColumn column0 = this.tableViewer.getTable().getColumn(0);
        column0.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RightSideCategorySection.this.tableViewer.getTable().setSortColumn(column0);
                int direction = RightSideCategorySection.this.tableViewer.getTable().getSortDirection() == 128 ? 1024 : 128;
                RightSideCategorySection.this.tableViewer.getTable().setSortDirection(direction);
                RightSideCategorySection.this.tableViewer.refresh();
            }
        });
        this.tableViewer.setInput((Object)this.selectedCategory);
        TableWrapData tData = new TableWrapData();
        tData.heightHint = 200;
        this.tableViewer.getTable().setLayoutData((Object)tData);
        ToolBarManager toolBarManager = new ToolBarManager(4096);
        this.addDescriptorToCategoryAction = new AddDescriptorToCategoryAction(this.page, (TableViewer)this.tableViewer);
        toolBarManager.add((IAction)this.addDescriptorToCategoryAction);
        this.deleteDescriptorFromCategoryAction = new DeleteDescriptorFromCategoryAction(this.page, (TableViewer)this.tableViewer);
        toolBarManager.add((IAction)this.deleteDescriptorFromCategoryAction);
        ToolBar toolbar = toolBarManager.createControl((Composite)this.descriptorListSection);
        this.descriptorListSection.setTextClient((Control)toolbar);
        this.descriptorListSection.update();
    }

    private void createDescriptorGroupTableSection() {
        this.descriptorGroupListSection = SectionUtility.createSectionForCategory(this.toolkit, this.page.getRightComposite(), "Descriptor Groups");
        this.descriptorGroupListSectionComposite = SectionUtility.getCompositeInsideSection(this.toolkit, this.descriptorGroupListSection, 1, 10, 2, 2);
        this.dgTableViewer = CheckboxTableUtility.createCheckboxTableViewer(this.page, this.descriptorGroupListSectionComposite, 0, "Descriptor Groups");
        this.dgTableViewer.setContentProvider((IContentProvider)new CategoryDescriptorGroupMembersContentProvider());
        this.dgTableViewer.setLabelProvider((IBaseLabelProvider)new CategoryMemberLabelProvider());
        this.dgTableViewer.setComparator((ViewerComparator)new TableColumnTextComparator());
        final TableColumn column0 = this.dgTableViewer.getTable().getColumn(0);
        column0.setText("Descriptor Group");
        column0.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RightSideCategorySection.this.dgTableViewer.getTable().setSortColumn(column0);
                int direction = RightSideCategorySection.this.dgTableViewer.getTable().getSortDirection() == 128 ? 1024 : 128;
                RightSideCategorySection.this.dgTableViewer.getTable().setSortDirection(direction);
                RightSideCategorySection.this.dgTableViewer.refresh();
            }
        });
        this.dgTableViewer.setInput((Object)this.selectedCategory);
        TableWrapData tData = new TableWrapData();
        tData.heightHint = 200;
        this.dgTableViewer.getTable().setLayoutData((Object)tData);
        ToolBarManager toolBarManager = new ToolBarManager(4096);
        this.addDescriptorGroupToCategoryAction = new AddDescriptorGroupToCategoryAction(this.page, (TableViewer)this.dgTableViewer);
        toolBarManager.add((IAction)this.addDescriptorGroupToCategoryAction);
        this.deleteDescriptorGroupFromCategoryAction = new DeleteDescriptorGroupFromCategoryAction(this.page, (TableViewer)this.dgTableViewer);
        toolBarManager.add((IAction)this.deleteDescriptorGroupFromCategoryAction);
        ToolBar toolbar = toolBarManager.createControl((Composite)this.descriptorGroupListSection);
        this.descriptorGroupListSection.setTextClient((Control)toolbar);
        this.descriptorGroupListSection.update();
    }

    public void setSelectedObject(Category selectedCategory) {
        this.logger.debug((Object)"- START : Setting Category for the right side.");
        try {
            this.selectedCategory = selectedCategory;
            if (this.labelLabel == null) {
                this.createGeneralPart();
            }
            this.reset();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Setting Category for the right side.");
    }
}

