/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table.merge;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.entry.qrtpcr.editor.IQrtPCRPart;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.model.merge.MergeTableData;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRMergeTablePreferenceLoader;
import org.grits.toolbox.entry.qrtpcr.table.QrtPCRNatTable;
import org.grits.toolbox.entry.qrtpcr.table.merge.MergeReportColumnPropertyAccessor;

public class MergeNatTable
extends QrtPCRNatTable {
    List<String> aliasList;
    private ArrayList<Integer> alFirstGroupIndices;

    public MergeNatTable(Composite parent) {
        super(parent);
    }

    public MergeNatTable(Composite parent, IQrtPCRPart editor, List<List<GRITSColumnHeader>> columnList, List<String> aliasList) {
        super(parent, editor, columnList);
        this.aliasList = aliasList;
    }

    @Override
    protected void initColumnPropertyAccessor() {
        this.columnPropertyAccessor = new MergeReportColumnPropertyAccessor((List)this.columnList.get(this.columnList.size() - 1), this.aliasList);
    }

    @Override
    public boolean isSelected(TableData gene) {
        int i = 0;
        while (i < this.treeList.size()) {
            Gene fromRow;
            TableData tableData = (TableData)this.treeList.get(i);
            if (tableData instanceof MergeTableData && (fromRow = ((MergeTableData)tableData).getGene()).equals(gene)) {
                int rowPosition = LayerUtil.convertRowPosition((ILayer)this.bodyDataLayer, (int)i, (IUniqueIndexLayer)this.selectionLayer);
                return this.selectionLayer.isRowPositionSelected(rowPosition);
            }
            ++i;
        }
        return false;
    }

    public void selectGene(Gene gene) {
        int i = 0;
        while (i < this.treeList.size()) {
            Gene fromRow;
            TableData tableData = (TableData)this.treeList.get(i);
            if (tableData instanceof MergeTableData && (fromRow = ((MergeTableData)tableData).getGene()).getGeneIdentifier().equals(gene.getGeneIdentifier())) {
                int rowPosition = LayerUtil.convertRowPosition((ILayer)this.bodyDataLayer, (int)i, (IUniqueIndexLayer)this.selectionLayer);
                this.selectionLayer.selectRow(0, rowPosition, false, true);
            }
            ++i;
        }
    }

    @Override
    public void initializePreferences() {
        this.setTablePreference(QrtPCRMergeTablePreferenceLoader.getTableViewerPreference());
    }

    @Override
    public TableViewerColumnSettings getPreferenceSettingsFromCurrentView() {
        if (this.columnGroupModel == null || this.columnGroupModel.isEmpty()) {
            return super.getPreferenceSettingsFromCurrentView();
        }
        if (this.getFirstGroupIndices() == null) {
            this.discoverGroups(this.columnGroupModel);
        }
        TableViewerColumnSettings newEntity = new TableViewerColumnSettings();
        if (this.getFirstGroupIndices().size() < 2) {
            logger.log((Priority)Level.WARN, (Object)"Not enough column groups to update visibility");
            return newEntity;
        }
        int iPos = 0;
        int i = 0;
        while (i < 2) {
            ColumnGroupModel.ColumnGroup group = this.columnGroupModel.getColumnGroupByIndex(this.getFirstGroupIndices().get(i).intValue());
            List members = group.getMembers();
            int j = 0;
            while (j < members.size()) {
                int iColLayerInx = (Integer)members.get(j);
                int iColLayerPos = this.columnHeaderDataLayer.getColumnPositionByIndex(iColLayerInx);
                String headerLabel = (String)this.columnHeaderDataLayer.getDataValueByPosition(iColLayerPos, 0);
                GRITSColumnHeader header = new GRITSColumnHeader(headerLabel, this.columnHeaderDataProvider.getDataKey(iColLayerPos, 0));
                newEntity.setVisColInx(header, Integer.valueOf(iPos++));
                ++j;
            }
            ++i;
        }
        return newEntity;
    }

    @Override
    public boolean updateViewFromPreferenceSettings() {
        boolean bTotalSuccess;
        block13: {
            block12: {
                bTotalSuccess = true;
                if (this.columnGroupModel == null || this.columnGroupModel.isEmpty()) {
                    super.updateViewFromPreferenceSettings();
                    return bTotalSuccess;
                }
                if (this.columnHeaderDataLayer != null && this.columnHeaderDataLayer.getColumnCount() != 0) break block12;
                return false;
            }
            int iNumCols = this.columnHeaderDataLayer.getColumnCount();
            if (iNumCols != 0) break block13;
            return false;
        }
        try {
            this.columnHideShowLayer.showAllColumns();
            ArrayList<Integer> alHiddenCols = new ArrayList<Integer>();
            if (this.getFirstGroupIndices() == null) {
                this.discoverGroups(this.columnGroupModel);
            }
            int i = 0;
            while (i < this.getFirstGroupIndices().size()) {
                ColumnGroupModel.ColumnGroup group = this.columnGroupModel.getColumnGroupByIndex(this.getFirstGroupIndices().get(i).intValue());
                List members = group.getMembers();
                int j = 0;
                while (j < members.size()) {
                    int iColLayerInx = (Integer)members.get(j);
                    int iColLayerPos = this.columnHeaderDataLayer.getColumnPositionByIndex(iColLayerInx);
                    String sHeaderKey = this.columnHeaderDataProvider.getDataKey(iColLayerPos, 0);
                    int iColShowLayerPos = LayerUtil.convertColumnPosition((ILayer)this.columnHeaderDataLayer, (int)iColLayerPos, (IUniqueIndexLayer)this.columnHideShowLayer);
                    if (this.getTablePreference().getPreferenceSettings().hasColumn(sHeaderKey)) {
                        int iPrefColPos = this.getTablePreference().getPreferenceSettings().getVisColInx(sHeaderKey);
                        if (iPrefColPos == -1) {
                            alHiddenCols.add(iColShowLayerPos);
                        }
                    } else {
                        alHiddenCols.add(iColShowLayerPos);
                        logger.warn((Object)("Header: " + sHeaderKey + " not found in preferences!"));
                    }
                    ++j;
                }
                ++i;
            }
            this.columnHideShowLayer.hideColumnPositions(alHiddenCols);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        if (!bTotalSuccess) {
            logger.error((Object)"There is an error in the preference settings.");
            ErrorUtils.createErrorMessageBox((Shell)this.getShell(), (String)"Column preference settings were invalid. You may want to reconfigure them");
            this.updatePreferenceSettingsFromCurrentView();
            this.getTablePreference().writePreference();
        }
        return bTotalSuccess;
    }

    @Override
    public void updatePreferenceSettingsFromCurrentView() {
        if (this.columnGroupModel == null || this.columnGroupModel.isEmpty()) {
            super.updatePreferenceSettingsFromCurrentView();
            return;
        }
        if (this.columnHeaderDataLayer == null || this.columnHeaderDataLayer.getColumnCount() == 0) {
            return;
        }
        if (this.getFirstGroupIndices() == null) {
            this.discoverGroups(this.columnGroupModel);
        }
        this.setVisibilityOfGroups(this.columnHeaderDataLayer, this.columnHideShowLayer, this.columnGroupModel, 0);
        this.setVisibilityOfGroups(this.columnHeaderDataLayer, this.columnHideShowLayer, this.columnGroupModel, 1);
    }

    private void setVisibilityOfGroups(DataLayer columnLayer, ColumnHideShowLayer columnShowLayer, ColumnGroupModel groupModel, int iGroupNum) {
        int iAdder = iGroupNum > 0 ? groupModel.getColumnGroupByIndex(0).getSize() : 0;
        ColumnGroupModel.ColumnGroup group = groupModel.getColumnGroupByIndex(this.getFirstGroupIndices().get(iGroupNum).intValue());
        List members = group.getMembers();
        int iNewNumCols = 0;
        int iMemInx = 0;
        while (iMemInx < members.size()) {
            int iColInx = (Integer)members.get(iMemInx);
            boolean bHidden = columnShowLayer.isColumnIndexHidden(iColInx);
            if (!bHidden) {
                ++iNewNumCols;
            }
            ++iMemInx;
        }
        int iToPos = iAdder;
        int iVisPos = 0;
        while (iVisPos < iNewNumCols) {
            int iColPos = LayerUtil.convertColumnPosition((ILayer)this.columnHideShowLayer, (int)(iVisPos + iAdder), (IUniqueIndexLayer)this.columnHeaderDataLayer);
            String sHeaderKey = this.columnHeaderDataProvider.getDataKey(iColPos, 0);
            if (this.getTablePreference().getPreferenceSettings().hasColumn(sHeaderKey)) {
                GRITSColumnHeader header = this.getTablePreference().getPreferenceSettings().getColumnHeader(sHeaderKey);
                this.getTablePreference().getPreferenceSettings().setVisColInx(header, Integer.valueOf(iToPos++));
            }
            ++iVisPos;
        }
        int iMemInx2 = 0;
        while (iMemInx2 < members.size()) {
            int iColInx = (Integer)members.get(iMemInx2);
            boolean bHidden = columnShowLayer.isColumnIndexHidden(iColInx);
            if (bHidden) {
                int iColPos = this.columnHeaderDataLayer.getColumnPositionByIndex(iColInx);
                String sHeaderKey = this.columnHeaderDataProvider.getDataKey(iColPos, 0);
                if (this.getTablePreference().getPreferenceSettings().hasColumn(sHeaderKey)) {
                    GRITSColumnHeader header = this.getTablePreference().getPreferenceSettings().getColumnHeader(sHeaderKey);
                    this.getTablePreference().getPreferenceSettings().setVisColInx(header, Integer.valueOf(-1));
                }
            }
            ++iMemInx2;
        }
    }

    public ArrayList<Integer> getFirstGroupIndices() {
        return this.alFirstGroupIndices;
    }

    public void discoverGroups(ColumnGroupModel groupModel) {
        this.alFirstGroupIndices = new ArrayList();
        if (groupModel == null || groupModel.isEmpty()) {
            return;
        }
        ColumnGroupModel.ColumnGroup prevGroup = null;
        int iTotalGroups = groupModel.size();
        int iGrpCnt = 0;
        int i = 0;
        while (iGrpCnt < iTotalGroups) {
            ColumnGroupModel.ColumnGroup group = groupModel.getColumnGroupByIndex(i++);
            if (prevGroup != null && prevGroup.equals(group)) continue;
            prevGroup = group;
            ++iGrpCnt;
            this.alFirstGroupIndices.add(i - 1);
        }
    }
}

