/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.dialogs;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.dialog.ProjectExplorerDialog;
import org.grits.toolbox.entry.qrtpcr.dialogs.UploadDataWizard;
import org.grits.toolbox.entry.qrtpcr.dialogs.UploadqrtPCRDataDialogPageOne;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRPreferencePage;

public class QrtPCRDataEntryPage
extends WizardPage {
    String entryName;
    Entry parentEntry;
    Text sampleNameText;
    private Text nameText;
    private ControlDecoration dec;
    Double threshold = QrtPCRPreferencePage.THRESHOLD_PREFERENCE;
    Double stDevCutOff = QrtPCRPreferencePage.STDEVCUTOFF_PREFERENCE;
    private ControlDecoration dec2;

    protected QrtPCRDataEntryPage(String pageName) {
        super(pageName);
    }

    public QrtPCRDataEntryPage(String string, Entry sampleEntry) {
        this(string);
        this.parentEntry = sampleEntry;
    }

    public void createControl(final Composite parent) {
        this.setTitle("Create QrtPCR Entry");
        this.setMessage("Please select the sample and provide a name for the entry");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.verticalSpacing = 10;
        Composite content = new Composite(parent, 0);
        this.setControl((Control)content);
        content.setLayout((Layout)gridLayout);
        GridData sampleNameData = new GridData();
        Label sampleNameLabel = new Label(content, 0);
        sampleNameLabel.setText("Sample");
        sampleNameLabel.setLayoutData((Object)sampleNameData);
        GridData projectnameTextData = new GridData();
        projectnameTextData.grabExcessHorizontalSpace = true;
        projectnameTextData.horizontalAlignment = 4;
        projectnameTextData.horizontalSpan = 1;
        this.sampleNameText = new Text(content, 2048);
        this.sampleNameText.setTextLimit(80);
        this.sampleNameText.setLayoutData((Object)projectnameTextData);
        if (this.parentEntry != null) {
            this.sampleNameText.setText(this.parentEntry.getDisplayName());
        }
        this.sampleNameText.setEditable(false);
        GridData browseButtonData = new GridData();
        Button button = new Button(content, 8);
        button.setText("Browse");
        button.setLayoutData((Object)browseButtonData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Entry selected;
                Shell newShell = new Shell(parent.getShell(), 0x10008000);
                ProjectExplorerDialog dlg = new ProjectExplorerDialog(newShell);
                dlg.addFilter("org.grits.toolbox.property.sample");
                dlg.setTitle("Sample Selection");
                dlg.setMessage("Choose a sample");
                if (dlg.open() == 0 && (selected = dlg.getEntry()) != null) {
                    QrtPCRDataEntryPage.this.parentEntry = selected;
                    QrtPCRDataEntryPage.this.sampleNameText.setText(QrtPCRDataEntryPage.this.parentEntry.getDisplayName());
                    if (QrtPCRDataEntryPage.this.nameText != null && QrtPCRDataEntryPage.this.nameText.getText() != null && !QrtPCRDataEntryPage.this.nameText.getText().trim().isEmpty()) {
                        QrtPCRDataEntryPage.this.setPageComplete(true);
                    } else {
                        QrtPCRDataEntryPage.this.setPageComplete(false);
                    }
                }
            }
        });
        this.createSeparator(content, 4);
        GridData nameData = new GridData();
        Label nameLabel = new Label(content, 16384);
        nameLabel.setText("Name");
        nameLabel.setLayoutData((Object)nameData);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        this.nameText = new Text(content, 2048);
        this.nameText.setLayoutData((Object)gridData);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QrtPCRDataEntryPage.this.setEntryName(QrtPCRDataEntryPage.this.nameText.getText());
                if (!QrtPCRDataEntryPage.this.nameText.getText().trim().isEmpty() && QrtPCRDataEntryPage.this.parentEntry != null) {
                    QrtPCRDataEntryPage.this.setPageComplete(true);
                } else {
                    QrtPCRDataEntryPage.this.setPageComplete(false);
                }
            }
        });
        this.nameText.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    QrtPCRDataEntryPage.this.setEntryName(QrtPCRDataEntryPage.this.nameText.getText());
                    if (!QrtPCRDataEntryPage.this.nameText.getText().trim().isEmpty() && QrtPCRDataEntryPage.this.parentEntry != null) {
                        QrtPCRDataEntryPage.this.setPageComplete(true);
                    } else {
                        QrtPCRDataEntryPage.this.setPageComplete(false);
                    }
                }
            }
        });
        this.createSeparator(content, 4);
        Label thresholdLabel = new Label(content, 16384);
        thresholdLabel.setText("Maximum Cycles");
        Text thresholdText = new Text(content, 2048);
        thresholdText.setLayoutData((Object)gridData);
        thresholdText.setText("" + QrtPCRPreferencePage.THRESHOLD_PREFERENCE);
        this.dec = new ControlDecoration((Control)thresholdText, 16512);
        Image image = JFaceResources.getImage((String)"dialog_message_error_image");
        this.dec.setImage(image);
        this.dec.setDescriptionText("Should enter a floating point number");
        this.dec.hide();
        thresholdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text newText = (Text)e.widget;
                String newValue = newText.getText();
                if (newValue != null) {
                    newValue = newValue.trim();
                }
                try {
                    QrtPCRDataEntryPage.this.threshold = Double.parseDouble(newValue);
                    QrtPCRDataEntryPage.this.dec.hide();
                }
                catch (NumberFormatException numberFormatException) {
                    QrtPCRDataEntryPage.this.dec.show();
                }
            }
        });
        Label stDevLabel = new Label(content, 16384);
        stDevLabel.setText("Maximum Standard Deviation");
        stDevLabel.setToolTipText("Standard deviation cut-off value. Entries having standard deviations more than this cutoff will be highlighted");
        Text stDevCutoffText = new Text(content, 2048);
        stDevCutoffText.setLayoutData((Object)gridData);
        stDevCutoffText.setText("" + QrtPCRPreferencePage.STDEVCUTOFF_PREFERENCE);
        this.dec2 = new ControlDecoration((Control)stDevCutoffText, 16512);
        this.dec2.setImage(image);
        this.dec2.setDescriptionText("Should enter a floating point number");
        this.dec2.hide();
        stDevCutoffText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text newText = (Text)e.widget;
                String newValue = newText.getText();
                if (newValue != null) {
                    newValue = newValue.trim();
                }
                try {
                    QrtPCRDataEntryPage.this.stDevCutOff = Double.parseDouble(newValue);
                    QrtPCRDataEntryPage.this.dec2.hide();
                }
                catch (NumberFormatException numberFormatException) {
                    QrtPCRDataEntryPage.this.dec2.show();
                }
            }
        });
        this.setPageComplete(false);
    }

    protected Label createSeparator(Composite parent, int span) {
        GridData separatorData = new GridData();
        separatorData.grabExcessHorizontalSpace = true;
        separatorData.horizontalAlignment = 4;
        separatorData.horizontalSpan = span;
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)separatorData);
        return separator;
    }

    public IWizardPage getNextPage() {
        UploadqrtPCRDataDialogPageOne pageOne = (UploadqrtPCRDataDialogPageOne)this.getWizard().getPage("Plate and Gene Info");
        pageOne.setSampleEntry(this.parentEntry);
        ((UploadDataWizard)this.getWizard()).setSampleEntry(this.parentEntry);
        return pageOne;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public Entry getParentEntry() {
        return this.parentEntry;
    }

    public void setParentEntry(Entry parentEntry) {
        this.parentEntry = parentEntry;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public Double getStDevCutOff() {
        return this.stDevCutOff;
    }
}

