/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.commands;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.qrtpcr.commands.ExportQrtPCRTable;
import org.grits.toolbox.entry.qrtpcr.editor.QrtPCRTableEditor;
import org.grits.toolbox.entry.qrtpcr.model.CtHistory;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneData;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRRun;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRTable;
import org.grits.toolbox.entry.qrtpcr.property.QrtPCRProperty;
import org.grits.toolbox.entry.qrtpcr.util.FileUtils;
import org.grits.toolbox.entry.qrtpcr.util.GeneUtils;

public class EvaluateData {
    private static final Logger logger = Logger.getLogger(ExportQrtPCRTable.class);
    public static final String COMMAND_ID = "org.grits.toolbox.entry.qrtpcr.evaluateData";
    public static final String DATAOPTION = "org.grits.toolbox.entry.qrtpcr.commandparameter.dataOption";
    @Inject
    private static IGritsDataModelService gritsDataModelService = null;

    @Execute
    public Object execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object object, @Named(value="e4ActivePart") @Named(value="e4ActivePart") MPart part, @Named(value="activeShell") @Named(value="activeShell") Shell shell, @Optional @Named(value="org.grits.toolbox.entry.qrtpcr.commandparameter.dataOption") @Named(value="org.grits.toolbox.entry.qrtpcr.commandparameter.dataOption") String dataOptionParam) throws ExecutionException {
        int dataOption = 0;
        if (dataOptionParam != null) {
            try {
                dataOption = Integer.parseInt(dataOptionParam);
            }
            catch (NumberFormatException numberFormatException) {
                dataOption = 0;
            }
        }
        QrtPCRRun pcrRun = null;
        QrtPCRTableEditor editor = null;
        if (part != null && part.getObject() instanceof QrtPCRTableEditor) {
            editor = (QrtPCRTableEditor)part.getObject();
            pcrRun = (QrtPCRRun)part.getContext().get(QrtPCRRun.class);
        }
        if (pcrRun != null) {
            for (Integer runId : pcrRun.getRunIdTableMap().keySet()) {
                QrtPCRTable table = pcrRun.getRun(runId);
                Map<String, QrtPCRData> plateMap = table.getPlateDataMap();
                Boolean original = table.getOriginal();
                for (String plateId : plateMap.keySet()) {
                    EvaluateData.applyRules(plateMap.get(plateId), dataOption, pcrRun.getThreshold(), pcrRun.getStDevCutOff());
                    if (runId > 0) {
                        editor.updateFirstRun(plateMap.get(plateId), runId);
                    }
                    if (original != null && !original.booleanValue()) continue;
                    editor.addPlatePage(runId, plateId, table.getInstrumentFileMap().get(plateId), false);
                    table.setOriginal(false);
                }
                part.getContext().set(QrtPCRRun.class, (Object)pcrRun);
                editor.refreshInput(pcrRun);
                editor.markDirty();
            }
        } else {
            Entry selectedEntry = null;
            if (object instanceof Entry) {
                selectedEntry = (Entry)object;
            } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
                selectedEntry = (Entry)((StructuredSelection)object).getFirstElement();
            }
            if (selectedEntry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
                selectedEntry = (Entry)gritsDataModelService.getLastSelection().getFirstElement();
            }
            if (!(selectedEntry == null || selectedEntry.getProperty() != null && "org.grits.toolbox.property.qrtpcr".equals(selectedEntry.getProperty().getType()))) {
                selectedEntry = null;
            }
            if (selectedEntry != null) {
                if (editor != null) {
                    if (editor.isDirty()) {
                        MessageDialog.openWarning((Shell)shell, (String)"Unsaved content", (String)"You have unsaved data in the editor. Please make sure to save it before \"Evaluate\"");
                        return null;
                    }
                    QrtPCRProperty prop = (QrtPCRProperty)selectedEntry.getProperty();
                    String filename = prop.getFilename();
                    try {
                        QrtPCRRun run = FileUtils.loadQrtPCRRun(selectedEntry, filename);
                        for (Integer runId : run.getRunIdTableMap().keySet()) {
                            QrtPCRTable table = run.getRun(runId);
                            Boolean original = table.getOriginal();
                            Map<String, QrtPCRData> plateMap = table.getPlateDataMap();
                            for (String plateId : plateMap.keySet()) {
                                EvaluateData.applyRules(plateMap.get(plateId), dataOption, run.getThreshold(), run.getStDevCutOff());
                                if (runId > 0) {
                                    editor.updateFirstRun(plateMap.get(plateId), runId);
                                }
                                if (original != null && !original.booleanValue()) continue;
                                editor.addPlatePage(runId, plateId, table.getInstrumentFileMap().get(plateId), false);
                                table.setOriginal(false);
                            }
                            editor.markDirty();
                        }
                    }
                    catch (JAXBException e) {
                        logger.error((Object)"Error loading qrtPCR Data", (Throwable)e);
                        ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Error loading qrtPCR Data", (Exception)((Object)e));
                    }
                    catch (FileNotFoundException e) {
                        logger.error((Object)"Error locating qrtPCR Data", (Throwable)e);
                        ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Error loading qrtPCR Data", (Exception)e);
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.error((Object)"Error loading qrtPCR Data", (Throwable)e);
                        ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Error loading qrtPCR Data", (Exception)e);
                    }
                }
            } else {
                MessageDialog.openError((Shell)shell, (String)"No Selection", (String)"Please select a qrt-PCR entry from the list first!");
                return null;
            }
        }
        return null;
    }

    public static boolean applyRules(QrtPCRData data, int dataOption, Double lowerThreshold, Double stDevCutOff) {
        try {
            List<GeneData> geneDataList;
            List<Gene> genes = data.getGenes();
            if (dataOption == 1) {
                for (Gene gene : genes) {
                    geneDataList = gene.getDataMap().get(0);
                    for (GeneData geneData : geneDataList) {
                        CtHistory originalValue = null;
                        List<CtHistory> previousValues = geneData.getPreviousValues();
                        if (previousValues != null && !previousValues.isEmpty()) {
                            originalValue = previousValues.get(0);
                            geneData.getPreviousValues().clear();
                        }
                        if (originalValue == null) continue;
                        geneData.setCt(originalValue.getCt());
                    }
                }
            } else if (dataOption == 2) {
                for (Gene gene : genes) {
                    geneDataList = gene.getDataMap().get(0);
                    for (GeneData geneData : geneDataList) {
                        Double toKeep = geneData.getCt();
                        List<CtHistory> previousValues = geneData.getPreviousValues();
                        ArrayList<CtHistory> toBeRemoved = new ArrayList<CtHistory>();
                        if (previousValues == null || previousValues.isEmpty()) continue;
                        Double previousCt = previousValues.get(previousValues.size() - 1).getCt();
                        int i = previousValues.size() - 1;
                        while (i >= 0) {
                            CtHistory ctHistory = previousValues.get(i);
                            if (ctHistory.getReasonCode().equals(CtHistory.Reason.USERCHANGE.getReason())) break;
                            if (ctHistory.getReasonCode().equals(CtHistory.Reason.AVERAGE.getReason())) {
                                toKeep = previousCt;
                                previousCt = ctHistory.getCt();
                                toBeRemoved.add(ctHistory);
                            }
                            --i;
                        }
                        previousValues.removeAll(toBeRemoved);
                        geneData.setCt(toKeep);
                    }
                }
            }
            for (Gene gene : genes) {
                gene.setShouldRerun(false);
            }
            boolean modified = false;
            block8: for (Gene gene : genes) {
                gene.setNumOfReplicates(data.getNumberOfReplicates());
                double stdev = gene.getStandardDeviation(0, lowerThreshold);
                if (!(stdev >= stDevCutOff)) continue;
                gene.checkAndMarkForRerun(0, lowerThreshold, stDevCutOff);
                if (!gene.getShouldRerun().booleanValue()) {
                    List<GeneData> modifiedList = GeneUtils.findBestValuesAndReplace(gene.getDataMap().get(0), data.getNumberOfReplicates(), lowerThreshold, stDevCutOff);
                    if (modifiedList == null) {
                        modified = true;
                        gene.setShouldRerun(true);
                        continue;
                    }
                    int k = 0;
                    List<GeneData> original = gene.getDataMap().get(0);
                    for (GeneData geneData2 : original) {
                        GeneData geneDataNew;
                        if (!geneData2.equals(geneDataNew = modifiedList.get(k))) {
                            if (geneData2.getCt() != null) {
                                geneData2.addPreviousValue(geneData2.getCt(), CtHistory.Reason.AVERAGE.getReason());
                            }
                            geneData2.setCt(geneDataNew.getCt());
                            modified = true;
                            continue block8;
                        }
                        ++k;
                    }
                    continue;
                }
                modified = true;
            }
            data.calculateNormValue();
            return modified;
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Erorr", (String)("Error evaluating data. Reason: " + e.getMessage()));
            logger.error((Object)"Exception evaluating data. ", (Throwable)e);
            return false;
        }
    }
}

