/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.annotation.gelato.Analyte;
import org.grits.toolbox.ms.annotation.structure.AnalyteStructure;
import org.grits.toolbox.ms.annotation.structure.GelatoAnalyte;
import org.grits.toolbox.ms.annotation.structure.GelatoAnalyteCache;
import org.grits.toolbox.ms.file.FileReaderUtils;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.FeatureSelection;
import org.grits.toolbox.ms.om.data.IonAdduct;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.Molecule;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;

public class GelatoUtils {
    private static final Logger logger = Logger.getLogger(GelatoUtils.class);

    public static void determineIonSettingSets(Boolean bIsPositive, Object lSettingsToConsider, int iMaxTotalCount, Object lSettingsToAnalyze, List<List<Integer>> lSettingsToAnalyzeCounts) {
        try {
            if (lSettingsToConsider == null || ((List)lSettingsToConsider).isEmpty()) {
                return;
            }
            boolean bDone = false;
            int iStartLevel = 0;
            int[] iCurChargeCnts = new int[((List)lSettingsToConsider).size()];
            ArrayList<String> sProcessed = new ArrayList<String>();
            while (!bDone) {
                ArrayList<Molecule> lCurSet = new ArrayList<Molecule>();
                ArrayList<Integer> lCurCounts = new ArrayList<Integer>();
                int iTotalCount = 0;
                int iLevelCnt = 0;
                String sCombo = "";
                for (iLevelCnt = 0; iLevelCnt <= iStartLevel; ++iLevelCnt) {
                    Molecule curSetting = (Molecule)((List)lSettingsToConsider).get(iLevelCnt);
                    int iCurCount = iCurChargeCnts[iLevelCnt] + 1;
                    if (curSetting instanceof IonSettings) {
                        if (bIsPositive != null && (((IonSettings)curSetting).getPolarity().booleanValue() && !bIsPositive.booleanValue() || !((IonSettings)curSetting).getPolarity().booleanValue() && bIsPositive.booleanValue())) continue;
                        iCurCount *= ((IonSettings)curSetting).getCharge().intValue();
                    }
                    if (iMaxTotalCount >= 0 && iTotalCount + iCurCount > iMaxTotalCount) continue;
                    iTotalCount += iCurCount;
                    sCombo = sCombo + "[" + iLevelCnt + ", " + iCurCount + "+]";
                    lCurSet.add(curSetting);
                    lCurCounts.add(iCurChargeCnts[iLevelCnt] + 1);
                }
                if (!(iMaxTotalCount >= 0 && iTotalCount > iMaxTotalCount || sProcessed.contains(sCombo))) {
                    ((List)lSettingsToAnalyze).add(lCurSet);
                    lSettingsToAnalyzeCounts.add(lCurCounts);
                    sProcessed.add(sCombo);
                }
                if (++iStartLevel == iCurChargeCnts.length) {
                    for (int j = iCurChargeCnts.length - 1; j >= 0 && iStartLevel == iCurChargeCnts.length; --j) {
                        Molecule curSetting = (Molecule)((List)lSettingsToConsider).get(j);
                        int iCurCnt = iCurChargeCnts[j] + 1;
                        int iMaxCnt = -1;
                        iMaxCnt = curSetting instanceof IonSettings ? ((Integer)((IonSettings)curSetting).getCounts().get(0)).intValue() : ((MoleculeSettings)curSetting).getCount().intValue();
                        if (iCurCnt < iMaxCnt) {
                            int n = j;
                            iCurChargeCnts[n] = iCurChargeCnts[n] + 1;
                            iStartLevel = j;
                            continue;
                        }
                        iCurChargeCnts[j] = 0;
                    }
                }
                bDone = iStartLevel == iCurChargeCnts.length;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in determineIonSettingSets", (Throwable)e);
        }
    }

    public static void determineFragmentIonSettingSets(Object lParentSettingsToConsider, List<Integer> lParentSettingsCounts, int iMaxTotalCount, Object lSettingsToAnalyze, List<List<Integer>> lSettingsToAnalyzeCounts) {
        try {
            if (lParentSettingsToConsider == null || ((List)lParentSettingsToConsider).isEmpty()) {
                return;
            }
            boolean bDone = false;
            int iStartLevel = 0;
            int[] iCurChargeCnts = new int[((List)lParentSettingsToConsider).size()];
            ArrayList<String> sProcessed = new ArrayList<String>();
            while (!bDone) {
                ArrayList<Molecule> lCurSet = new ArrayList<Molecule>();
                ArrayList<Integer> lCurCounts = new ArrayList<Integer>();
                int iTotalCharge = 0;
                int iLevelCnt = 0;
                String sCombo = "";
                for (iLevelCnt = 0; iLevelCnt <= iStartLevel; ++iLevelCnt) {
                    Molecule curSetting = (Molecule)((List)lParentSettingsToConsider).get(iLevelCnt);
                    int iCurCount = iCurChargeCnts[iLevelCnt] + 1;
                    if (curSetting instanceof IonSettings) {
                        iCurCount *= ((IonSettings)curSetting).getCharge().intValue();
                    }
                    if (iTotalCharge + iCurCount > iMaxTotalCount) continue;
                    iTotalCharge += iCurCount;
                    sCombo = sCombo + "[" + iLevelCnt + ", " + iCurCount + "+]";
                    lCurSet.add(curSetting);
                    lCurCounts.add(iCurChargeCnts[iLevelCnt] + 1);
                }
                if (iTotalCharge <= iMaxTotalCount && !sProcessed.contains(sCombo)) {
                    ((List)lSettingsToAnalyze).add(lCurSet);
                    lSettingsToAnalyzeCounts.add(lCurCounts);
                    sProcessed.add(sCombo);
                }
                if (++iStartLevel == iCurChargeCnts.length) {
                    for (int j = iCurChargeCnts.length - 1; j >= 0 && iStartLevel == iCurChargeCnts.length; --j) {
                        int iCurCnt = iCurChargeCnts[j] + 1;
                        int iMaxCnt = lParentSettingsCounts.get(j);
                        if (iCurCnt < iMaxCnt) {
                            int n = j;
                            iCurChargeCnts[n] = iCurChargeCnts[n] + 1;
                            iStartLevel = j;
                            continue;
                        }
                        iCurChargeCnts[j] = 0;
                    }
                }
                bDone = iStartLevel == iCurChargeCnts.length;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in determineIonSettingSets", (Throwable)e);
        }
    }

    public static double getTargetAccuracy(Method _method, double _dMz, boolean _bIsPrecursor) {
        double targetAccuracy = 0.0;
        targetAccuracy = _bIsPrecursor ? (_method.getAccuracyPpm().booleanValue() ? _method.getAccuracy() / 1000000.0 * _dMz : _method.getAccuracy()) : (_method.getFragAccuracyPpm() != false ? _method.getFragAccuracy() / 1000000.0 * _dMz : _method.getFragAccuracy());
        return targetAccuracy;
    }

    public static List<Integer> getMatchingSubScans(Data data, Scan scan, int iPeakInx) {
        Peak peak = (Peak)scan.getPeaklist().get(iPeakInx);
        List iSubScans = scan.getSubScans();
        ArrayList<Integer> iMatchingScans = new ArrayList<Integer>();
        for (int i = 0; i < iSubScans.size(); ++i) {
            Scan subScan = (Scan)data.getScans().get(iSubScans.get(i));
            if (subScan.getPrecursor().getMz() != peak.getPrecursorMz()) continue;
            iMatchingScans.add(subScan.getScanNo());
        }
        return iMatchingScans;
    }

    public static int[] getMatchingPeak(Scan scan, int iPeakInx, double glycanMz, Method method, boolean _bIsPrecursor) {
        try {
            boolean bGo;
            Peak peak = (Peak)scan.getPeaklist().get(iPeakInx);
            if (peak == null || peak.getMz() == null || peak.getIntensity() == null) {
                return null;
            }
            double peakMz = peak.getMz() + method.getShift();
            double targetAccuracy = GelatoUtils.getTargetAccuracy(method, glycanMz, _bIsPrecursor);
            double dMaxInt = -1.0;
            int iMaxPeakInx = -1;
            boolean bl = bGo = Math.abs(peakMz - glycanMz) <= targetAccuracy;
            while (bGo) {
                if (peak.getIntensity() > dMaxInt) {
                    dMaxInt = peak.getIntensity();
                    iMaxPeakInx = iPeakInx;
                }
                if (++iPeakInx < scan.getPeaklist().size()) {
                    peak = (Peak)scan.getPeaklist().get(iPeakInx);
                    if (peak == null || peak.getMz() == null || peak.getIntensity() == null) continue;
                    peakMz = peak.getMz() + method.getShift();
                    bGo = Math.abs(peakMz - glycanMz) <= targetAccuracy;
                    continue;
                }
                bGo = false;
            }
            return new int[]{iPeakInx, iMaxPeakInx};
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
            return null;
        }
    }

    public static List<Integer> getSubScanForPrecursor(Data data, int iParentScanNum, Peak parentPeak) {
        ArrayList<Integer> lScans = new ArrayList<Integer>();
        Scan scan = (Scan)data.getScans().get(iParentScanNum);
        double dMult = 100.0;
        for (Integer iSubScanNum : scan.getSubScans()) {
            try {
                Scan subScan = (Scan)data.getScans().get(iSubScanNum);
                if (subScan.getPrecursor().getPrecursorMz() == null || Math.round(subScan.getPrecursor().getPrecursorMz()) != Math.round(parentPeak.getMz())) continue;
                lScans.add(iSubScanNum);
                logger.debug((Object)("\t\t\tSubscan: " + subScan.getScanNo() + ", precursor m/z: " + subScan.getPrecursor().getPrecursorMz() + ". Parent peak m/z: " + parentPeak.getMz()));
            }
            catch (NullPointerException ex) {
                logger.error((Object)"Null subscan or precursor value in getSubScanForPrecursor", (Throwable)ex);
            }
        }
        return lScans;
    }

    public static double getAdductMass(IonSettings adduct) {
        return adduct.getMass();
    }

    public static double getChargeFromAdducts(int count, IonSettings adduct) {
        return (double)adduct.getCharge().intValue() * (double)count;
    }

    public static double getIonExchange(IonSettings ionExchange, int count) {
        return ionExchange.getMass() * (double)count - (double)count;
    }

    public static double getNeutralLoss(MoleculeSettings nuetralLoss, int count) {
        return nuetralLoss.getMass() * (double)count;
    }

    public static double getAnalyteStructureMz(double mass, double z, double dAdductMass) {
        if (z == 0.0) {
            z = 1.0;
        }
        return (mass + dAdductMass) / z;
    }

    public static double[] getAnalyteMzAndCharge(Analyte analyte, AnalyteSettings analyteSettings, List<IonSettings> lAdductsToAnalyze, List<Integer> lAdductsToAnalyzeCounts, List<IonSettings> lExchangesToAnalyze, List<Integer> lExchangesToAnalyzeCounts, List<MoleculeSettings> lNeutralLossesToAnalyze, List<Integer> lNeutralLossesToAnalyzeCounts) {
        double dMass = 0.0;
        try {
            dMass = analyte.computeMass();
        }
        catch (Exception e) {
            dMass = analyte.computeMass();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        double dSumExchanges = 0.0;
        if (lExchangesToAnalyze != null) {
            for (int i = 0; i < lExchangesToAnalyze.size(); ++i) {
                IonSettings ionExchange = lExchangesToAnalyze.get(i);
                int iCnt = lExchangesToAnalyzeCounts.get(i);
                double dMassChange = GelatoUtils.getIonExchange(ionExchange, iCnt);
                dMass += dMassChange;
                dSumExchanges += (double)iCnt;
            }
        }
        double dSumLosses = 0.0;
        if (lNeutralLossesToAnalyze != null) {
            for (int i = 0; i < lNeutralLossesToAnalyze.size(); ++i) {
                MoleculeSettings neutralLoss = lNeutralLossesToAnalyze.get(i);
                int iCnt = lNeutralLossesToAnalyzeCounts.get(i);
                double dMassChange = GelatoUtils.getNeutralLoss(neutralLoss, iCnt);
                dMass += dMassChange;
                dSumLosses += (double)iCnt;
            }
        }
        double dSumCharge = 0.0;
        double dSumMass = 0.0;
        for (int i = 0; i < lAdductsToAnalyze.size(); ++i) {
            IonSettings adduct = lAdductsToAnalyze.get(i);
            int iCnt = lAdductsToAnalyzeCounts.get(i);
            double z = GelatoUtils.getChargeFromAdducts(iCnt, adduct);
            dSumCharge += z;
            dSumMass += (double)iCnt * adduct.getMass();
        }
        double dAnalyteMz = GelatoUtils.getAnalyteStructureMz(dMass, dSumCharge, dSumMass);
        return new double[]{dAnalyteMz, dSumCharge, dSumExchanges, dSumLosses};
    }

    public static void populateNewFeature(Feature feature, Data _data, String sFeatureSequence, double dPeakMz, double glycanMz, double charge, String fragmentType, List<IonSettings> lAdductsToAnalyze, List<Integer> lAdductsToAnalyzeCounts, List<IonSettings> lExchangesToAnalyze, List<Integer> lExchangesToAnalyzeCounts, List<MoleculeSettings> lNeutralLossesToAnalyze, List<Integer> lNeutralLossesToAnalyzeCounts, Integer scanNum, int index, Annotation annotation, Feature parentFeature) {
        int i;
        feature.setId(Integer.toString(_data.getNextFeatureIndex()));
        feature.setSequence(sFeatureSequence);
        feature.setCharge(Integer.valueOf((int)charge));
        double deviation = Math.abs(dPeakMz - glycanMz) / glycanMz * 1000000.0;
        feature.setDeviation(Double.valueOf(deviation));
        feature.setFragmentType(fragmentType);
        if (lAdductsToAnalyze != null) {
            for (i = 0; i < lAdductsToAnalyze.size(); ++i) {
                IonSettings adduct = lAdductsToAnalyze.get(i);
                int count = lAdductsToAnalyzeCounts.get(i);
                IonAdduct ion = new IonAdduct();
                ion.setCharge(adduct.getCharge());
                ion.setCount(Integer.valueOf(count));
                ion.setLabel(adduct.getLabel());
                ion.setMass(adduct.getMass());
                ion.setName(adduct.getName());
                feature.getIons().add(ion);
            }
        }
        if (lExchangesToAnalyze != null) {
            for (i = 0; i < lExchangesToAnalyze.size(); ++i) {
                IonSettings ionExchange = lExchangesToAnalyze.get(i);
                int exchangeCount = lExchangesToAnalyzeCounts.get(i);
                IonAdduct exchange = new IonAdduct();
                exchange.setCharge(ionExchange.getCharge());
                exchange.setCount(Integer.valueOf(exchangeCount));
                exchange.setLabel(ionExchange.getLabel());
                exchange.setName(ionExchange.getName());
                exchange.setMass(ionExchange.getMass());
                feature.getNeutralexchange().add(exchange);
            }
        }
        if (lNeutralLossesToAnalyze != null) {
            for (i = 0; i < lNeutralLossesToAnalyze.size(); ++i) {
                MoleculeSettings neutralLoss = lNeutralLossesToAnalyze.get(i);
                int neutralLossCount = lNeutralLossesToAnalyzeCounts.get(i);
                MoleculeSettings featureNeutralLoss = new MoleculeSettings();
                featureNeutralLoss.setCount(Integer.valueOf(neutralLossCount));
                featureNeutralLoss.setLabel(neutralLoss.getLabel());
                featureNeutralLoss.setMass(neutralLoss.getMass());
                featureNeutralLoss.setName(neutralLoss.getName());
                feature.getNeutralLoss().add(featureNeutralLoss);
            }
        }
        feature.setMz(Double.valueOf(glycanMz));
        String rowId = Feature.getRowId((Integer)index, (Integer)scanNum, (boolean)true);
        FeatureSelection fSelection = new FeatureSelection();
        fSelection.setRowId(rowId);
        feature.getFeatureSelections().add(fSelection);
        feature.setAnnotationId(annotation.getId());
        feature.setPrecursor(Integer.valueOf(-1));
        if (parentFeature != null) {
            feature.setParentId(parentFeature.getId());
        }
    }

    public static Analyte getAnalyteFromGelatoCache(AnalyteStructure structure) {
        try {
            if (!GelatoAnalyteCache.hmGelatoAnalytesByStructureId.containsKey(structure.getId())) {
                throw new Exception("Could not find Glycan object for structure: " + structure.getId());
            }
            GelatoAnalyte gelatoAnalyte = GelatoAnalyteCache.hmGelatoAnalytesByStructureId.get(structure.getId());
            if (gelatoAnalyte == null || gelatoAnalyte.getAnalyte() == null) {
                throw new Exception("Could not find Glycan object for structure: " + structure.getId());
            }
            return gelatoAnalyte.getAnalyte();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HashMap<Integer, Scan> listToHashMap(List<Scan> scans, double dFragCutoff, String sFragCutoffType, double dPreCutoff, String sPreCutoffType) {
        HashMap scanHash = null;
        String sFragType = sFragCutoffType != null ? sFragCutoffType : "Absolute Value";
        double dFragVal = sFragCutoffType != null ? dFragCutoff : 0.0;
        String sPreType = sPreCutoffType != null ? sPreCutoffType : "Absolute Value";
        double dPreVal = sPreCutoffType != null ? dPreCutoff : 0.0;
        scanHash = FileReaderUtils.listToFilteredHashMap(scans, (double)dFragVal, (String)sFragType, (double)dPreVal, (String)sPreType);
        return scanHash;
    }
}

