/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.report.handler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.GeneralSettings;
import org.grits.toolbox.core.datamodel.SettingEntry;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.property.ReportsProperty;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.core.utils.SettingsHandler;
import org.grits.toolbox.entry.ms.annotation.glycan.property.MSGlycanAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.glycan.report.dialog.MSGlycanAnnotationReportDialog;
import org.grits.toolbox.entry.ms.annotation.glycan.report.process.loader.MSGlycanAnnotationReportTableDataProcessorUtil;
import org.grits.toolbox.entry.ms.annotation.glycan.report.property.MSGlycanAnnotationReportProperty;
import org.grits.toolbox.entry.ms.annotation.glycan.report.property.datamodel.MSGlycanAnnotationReportMetaData;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantAlias;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantFileToAlias;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.grits.toolbox.merge.action.MergeReportGenerator;
import org.grits.toolbox.merge.om.data.ExperimentAnnotation;
import org.grits.toolbox.merge.om.data.MergeReport;
import org.grits.toolbox.merge.xml.Deserialize;
import org.grits.toolbox.merge.xml.Serializer;
import org.grits.toolbox.ms.om.data.CustomExtraData;
import org.grits.toolbox.widgets.processDialog.ProgressDialog;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;
import org.grits.toolbox.widgets.progress.ProgressThread;

public class MSGlycanAnnotationReportAnnotationHandler {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationReportAnnotationHandler.class);
    private static final String WARNINGDIALOGSETTING = "Merge Report Warning Dialog";
    @Inject
    private static IGritsDataModelService gritsDataModelService = null;
    @Inject
    static IGritsUIService gritsUIService = null;
    private MergeReport report = null;
    boolean canceled = false;

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object object, IEventBroker eventBroker, @Named(value="activeShell") @Named(value="activeShell") Shell shell, EPartService partService) {
        StructuredSelection to = null;
        Entry selectedEntry = null;
        if (object instanceof Entry) {
            selectedEntry = (Entry)object;
        } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
            to = (StructuredSelection)object;
        }
        if (selectedEntry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
            to = gritsDataModelService.getLastSelection();
        }
        if (to == null) {
            if (selectedEntry != null && selectedEntry.getProperty().getType().equals(this.getAnnotationPropertyType())) {
                ArrayList<Entry> entries = new ArrayList<Entry>();
                entries.add(selectedEntry);
                this.createSimianMergeDialog(shell, entries, eventBroker, partService);
            } else {
                this.createSimianMergeDialog(shell, null, eventBroker, partService);
            }
        } else {
            boolean correctEntries = true;
            ArrayList<Entry> entries = new ArrayList<Entry>();
            Entry projectEntry = null;
            List selList = to.toList();
            int i = 0;
            while (i < selList.size()) {
                Entry simEntry = (Entry)selList.get(i);
                if (simEntry.getProperty().getType().equals(this.getAnnotationPropertyType())) {
                    if (projectEntry == null) {
                        projectEntry = DataModelSearch.findParentByType((Entry)simEntry, (String)"org.grits.toolbox.property.project");
                        entries.add(simEntry);
                    } else {
                        if (!projectEntry.equals(DataModelSearch.findParentByType((Entry)simEntry, (String)"org.grits.toolbox.property.project"))) {
                            correctEntries = false;
                            break;
                        }
                        entries.add(simEntry);
                    }
                } else {
                    correctEntries = false;
                    break;
                }
                ++i;
            }
            if (correctEntries) {
                this.createSimianMergeDialog(shell, entries, eventBroker, partService);
            } else {
                this.createSimianMergeDialog(shell, null, eventBroker, partService);
            }
        }
    }

    protected String getAnnotationPropertyType() {
        return "org.grits.toolbox.property.ms_annotation.glycan";
    }

    public MergeReport readDataFromFile(Shell activeShell, final String sSourceFile) {
        ProgressDialog dialog = new ProgressDialog(activeShell, 2);
        ProgressThread worker = new ProgressThread(){

            public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
                ((ProgressDialog)a_progressThreadHandler).setProcessMessageLabel("Reading Merge report");
                Job job = new Job("Reading archive..."){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            Deserialize des = new Deserialize();
                            logger.debug((Object)("Reading archive: " + sSourceFile));
                            MSGlycanAnnotationReportAnnotationHandler.this.report = des.deserialize(sSourceFile);
                            return Status.OK_STATUS;
                        }
                        catch (Exception ex) {
                            logger.error((Object)ex.getMessage(), (Throwable)ex);
                            return Status.CANCEL_STATUS;
                        }
                    }
                };
                job.schedule();
                while (!(job.getState() != 2 && job.getState() != 4 || a_progressThreadHandler.isCanceled())) {
                    Thread.sleep(1000L);
                }
                return job.getResult() == Status.OK_STATUS;
            }

            public void cancelWork() {
            }
        };
        dialog.setWorker(worker);
        dialog.open();
        return this.report;
    }

    private void addExternalQuantAliasInfo(List<Entry> expEntries, List<CustomExtraData> peakCustomExtraData, MSGlycanAnnotationReportMetaData metaData) {
        MSAnnotationMetaData expMetaData;
        MSGlycanAnnotationProperty t_property;
        Entry entry;
        HashMap mExtQuantToKnownKeyToAliasPrefixes = new HashMap();
        int i = 0;
        while (i < expEntries.size()) {
            entry = expEntries.get(i);
            t_property = null;
            t_property = (MSGlycanAnnotationProperty)entry.getProperty();
            expMetaData = t_property.getMSAnnotationMetaData();
            for (String sQuantType : expMetaData.getQuantTypeToExternalQuant().keySet()) {
                HashMap<String, String> mKnownKeyToAliasPrefixes = new HashMap<String, String>();
                mExtQuantToKnownKeyToAliasPrefixes.put(sQuantType, mKnownKeyToAliasPrefixes);
                ExternalQuantFileToAlias extQuantInfo = expMetaData.getExternalQuantToAliasByQuantType(sQuantType);
                for (String sFileName : extQuantInfo.getSourceDataFileNameToAlias().keySet()) {
                    ExternalQuantAlias alias = (ExternalQuantAlias)extQuantInfo.getSourceDataFileNameToAlias().get(sFileName);
                    for (CustomExtraData ced : peakCustomExtraData) {
                        if (!ced.getKey().startsWith(String.valueOf(alias.getKey()) + "_quant") || !ced.getLabel().startsWith(String.valueOf(alias.getAlias()) + " ")) continue;
                        mKnownKeyToAliasPrefixes.put(ced.getKey(), alias.getAlias());
                    }
                }
            }
            ++i;
        }
        if (mExtQuantToKnownKeyToAliasPrefixes.isEmpty()) {
            return;
        }
        i = 0;
        while (i < expEntries.size()) {
            entry = expEntries.get(i);
            t_property = null;
            t_property = (MSGlycanAnnotationProperty)entry.getProperty();
            expMetaData = t_property.getMSAnnotationMetaData();
            String sKey1 = expMetaData.getAnnotationId();
            ExternalQuantFileToAlias eqfa = null;
            if (metaData.getExpToExternalQuant().containsKey(sKey1)) {
                eqfa = metaData.getExpToExternalQuant().get(sKey1);
            } else {
                eqfa = new ExternalQuantFileToAlias();
                metaData.getExpToExternalQuant().put(sKey1, eqfa);
            }
            if (eqfa.getSourceDataFileNameToAlias() == null) {
                eqfa.setSourceDataFileNameToAlias(new HashMap());
            }
            for (CustomExtraData ced : peakCustomExtraData) {
                for (String sExtQuantType : mExtQuantToKnownKeyToAliasPrefixes.keySet()) {
                    HashMap mKnownKeyToAliasPrefixes = (HashMap)mExtQuantToKnownKeyToAliasPrefixes.get(sExtQuantType);
                    if (!mKnownKeyToAliasPrefixes.containsKey(ced.getKey())) continue;
                    CustomExtraData defKey = MassSpecUISettings.getDefaultExternalQuantCED((String)sExtQuantType, (String)ced.getKey());
                    if (!expMetaData.getQuantTypeToExternalQuant().isEmpty()) {
                        boolean bFound = false;
                        if (expMetaData.getQuantTypeToExternalQuant().containsKey(sExtQuantType)) {
                            ExternalQuantFileToAlias extQuantInfo = expMetaData.getExternalQuantToAliasByQuantType(sExtQuantType);
                            for (String sHeaderKey : extQuantInfo.getSourceDataFileNameToAlias().keySet()) {
                                ExternalQuantAlias alias = (ExternalQuantAlias)extQuantInfo.getSourceDataFileNameToAlias().get(sHeaderKey);
                                if (alias == null || !ced.getKey().startsWith(String.valueOf(alias.getKey()) + "_quant")) continue;
                                String sFixedKey = ced.getKey();
                                String sFixedAlias = (String)mKnownKeyToAliasPrefixes.get(sFixedKey);
                                String sNewAlias = ced.getLabel().replace(sFixedAlias, alias.getAlias());
                                ExternalQuantAlias newEQA = new ExternalQuantAlias();
                                newEQA.setAlias(sNewAlias);
                                newEQA.setKey(sFixedKey);
                                eqfa.getSourceDataFileNameToAlias().put(sFixedKey, newEQA);
                                bFound = true;
                            }
                        }
                        if (bFound) continue;
                        String sFixedKey = ced.getKey();
                        ExternalQuantAlias newEQA = new ExternalQuantAlias();
                        newEQA.setAlias("Unused " + defKey.getLabel());
                        newEQA.setKey(sFixedKey);
                        eqfa.getSourceDataFileNameToAlias().put(sFixedKey, newEQA);
                        continue;
                    }
                    String sFixedKey = ced.getKey();
                    ExternalQuantAlias newEQA = new ExternalQuantAlias();
                    newEQA.setAlias(defKey.getLabel());
                    newEQA.setKey(sFixedKey);
                    eqfa.getSourceDataFileNameToAlias().put(sFixedKey, newEQA);
                }
            }
            ++i;
        }
    }

    private Object createSimianMergeDialog(Shell activeShell, List<Entry> entries, IEventBroker eventBroker, EPartService partService) {
        block30: {
            MSGlycanAnnotationReportDialog dialog;
            MessageDialogWithToggle warningDialog;
            GeneralSettings settings = null;
            try {
                settings = SettingsHandler.readSettings();
            }
            catch (Exception exception) {
                logger.warn((Object)"Settings file does not exist yet");
            }
            if ((settings == null || !settings.isHiddenDialog(WARNINGDIALOGSETTING)) && (warningDialog = MessageDialogWithToggle.openWarning((Shell)activeShell, (String)"Warning", (String)"Some quantitative information may be unavailable for experiments if you haven't already applied external quantification files for them through \"Tools->MS Glycan Annotation->External Quantification\"", (String)"Do not show again", (boolean)false, null, null)).getToggleState()) {
                if (settings == null) {
                    settings = new GeneralSettings();
                }
                SettingEntry se = new SettingEntry();
                se.setId(WARNINGDIALOGSETTING);
                se.setName(WARNINGDIALOGSETTING);
                se.setDescription("Dialog warning about merging experiments without applying external quantification first");
                settings.addHiddenDialog(se);
                try {
                    SettingsHandler.writeSettings((GeneralSettings)settings);
                }
                catch (Exception e) {
                    logger.warn((Object)"Could not update settings file", (Throwable)e);
                }
            }
            if ((dialog = this.getReportDialog(PropertyHandler.getModalDialog((Shell)activeShell), entries)).open() == 0) {
                File reportsFolder;
                Shell modalDialog = PropertyHandler.getModalDialog((Shell)new Shell());
                String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
                Entry projectEntry = DataModelSearch.findParentByType((Entry)dialog.getAnnotationEntryList().get(0), (String)"org.grits.toolbox.property.project");
                String projectName = projectEntry.getDisplayName();
                Entry reportsEntry = null;
                for (Entry child : projectEntry.getChildren()) {
                    if (!child.getProperty().getType().equals("org.grits.toolbox.property.reports")) continue;
                    reportsEntry = child;
                }
                if (reportsEntry == null) {
                    reportsEntry = new Entry();
                    reportsEntry.setDisplayName("reports");
                    reportsEntry.setProperty((Property)new ReportsProperty());
                    try {
                        PropertyHandler.getDataModel().setShow(false);
                        gritsDataModelService.addEntry(projectEntry, reportsEntry);
                        try {
                            ProjectFileHandler.saveProject((Entry)projectEntry);
                        }
                        catch (IOException e) {
                            logger.error((Object)("Something went wrong while saving project entry \n" + e.getMessage()), (Throwable)e);
                            logger.fatal((Object)("Closing project entry \"" + projectEntry.getDisplayName() + "\""));
                            gritsDataModelService.closeProject(projectEntry);
                            throw e;
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        ErrorUtils.createErrorMessageBox((Shell)modalDialog, (String)e.getMessage(), (Exception)e);
                        return null;
                    }
                }
                if (!(reportsFolder = new File(String.valueOf(workspaceLocation) + projectName + "/" + ReportsProperty.getFolder())).exists() && !reportsFolder.mkdirs()) {
                    logger.error((Object)("Cannot create the folder: " + reportsFolder.getAbsolutePath()));
                    ErrorUtils.createWarningMessageBox((Shell)modalDialog, (String)"Error While Creating A Folder", (String)("Cannot create the folder: " + reportsFolder.getAbsolutePath()));
                    return null;
                }
                File mergeFolder = new File(reportsFolder + "/" + this.getMergeFolder());
                if (!mergeFolder.exists() && !mergeFolder.mkdirs()) {
                    logger.error((Object)("Cannot create the folder: " + mergeFolder.getAbsolutePath()));
                    ErrorUtils.createWarningMessageBox((Shell)modalDialog, (String)"Error While Creating A Folder", (String)("Cannot create the folder: " + mergeFolder.getAbsolutePath()));
                    return null;
                }
                String entryId = MSGlycanAnnotationReportProperty.getRandomId();
                File imgFolder = new File(mergeFolder + "/" + entryId);
                while (imgFolder.exists()) {
                    entryId = MSGlycanAnnotationReportProperty.getRandomId();
                    imgFolder = new File(mergeFolder + "/" + entryId);
                }
                if (!imgFolder.mkdir()) {
                    logger.error((Object)("cannot create the folder: " + imgFolder.getAbsolutePath()));
                    ErrorUtils.createWarningMessageBox((Shell)modalDialog, (String)"Error", (String)("cannot create the folder: " + imgFolder.getAbsolutePath()));
                    return null;
                }
                try {
                    ArrayList<ExperimentAnnotation> experimentAnnotations = new ArrayList<ExperimentAnnotation>();
                    int i = 0;
                    while (i < dialog.getAnnotationEntryList().size()) {
                        Entry entry = dialog.getAnnotationEntryList().get(i);
                        MSGlycanAnnotationProperty t_property = null;
                        t_property = (MSGlycanAnnotationProperty)entry.getProperty();
                        String msAnnotationFolder = String.valueOf(workspaceLocation) + projectName + File.separator + t_property.getArchiveFolder();
                        String reportFile = String.valueOf(msAnnotationFolder) + File.separator + t_property.getMSAnnotationMetaData().getAnnotationId() + t_property.getArchiveExtension();
                        ExperimentAnnotation expAnnotation = new ExperimentAnnotation();
                        expAnnotation.setAnnotationEntryId(Integer.valueOf(Integer.parseInt(t_property.getMSAnnotationMetaData().getAnnotationId())));
                        expAnnotation.setAnnotationFileArchive(reportFile);
                        String displayName = MSGlycanAnnotationReportTableDataProcessorUtil.getDisplayNameByEntryName(t_property.getMSAnnotationMetaData().getAnnotationId());
                        String sUserInfo = dialog.getAnnotationInfo(displayName);
                        expAnnotation.setAnnotationDisplayName(displayName);
                        expAnnotation.setAnnotationShortName(sUserInfo);
                        experimentAnnotations.add(expAnnotation);
                        ++i;
                    }
                    int iResult = this.generateMergeReport(activeShell, experimentAnnotations, dialog.getInterval(), dialog.getAccuracyType(), imgFolder + File.separator + entryId + ".xml");
                    if (iResult == 256 || this.canceled) {
                        this.deleteDirectory(imgFolder);
                        break block30;
                    }
                    if (iResult == 32) {
                        Entry repEntry = dialog.createEntry();
                        MSGlycanAnnotationReportProperty repProperty = (MSGlycanAnnotationReportProperty)repEntry.getProperty();
                        MSGlycanAnnotationReportMetaData metaData = repProperty.getMsGlycanAnnotReportMetaData();
                        metaData.setReportId(entryId);
                        String metaDataFileName = String.valueOf(metaData.getReportId()) + File.separator + repProperty.getMetaDataFileName();
                        PropertyDataFile msMetaData = MSGlycanAnnotationReportProperty.getNewSettingsFile(metaDataFileName, metaData);
                        repProperty.getDataFiles().add(msMetaData);
                        String sReportFile = repProperty.getFullyQualifiedXMLFileName(projectEntry);
                        String reportFileName = String.valueOf(metaData.getReportId()) + File.separator + repProperty.getArchiveFile();
                        this.readDataFromFile(activeShell, sReportFile);
                        if (this.report != null && this.report.getPeakCustomExtraData() != null) {
                            this.addExternalQuantAliasInfo(dialog.getAnnotationEntryList(), this.report.getPeakCustomExtraData(), metaData);
                        }
                        String sFileName = repProperty.getFullyQualifiedMetaDataFileName(projectEntry);
                        MSGlycanAnnotationReportProperty.marshallSettingsFile(sFileName, metaData);
                        File file = new File(sReportFile);
                        PropertyDataFile pdf = null;
                        if (file.exists()) {
                            pdf = new PropertyDataFile(reportFileName, "1.0", "file");
                        }
                        if (pdf == null) {
                            throw new UnsupportedVersionException("Expecting an archive file or folder. Not found.", "Preversion");
                        }
                        repProperty.getDataFiles().add(pdf);
                        PropertyHandler.getDataModel().setShow(true);
                        gritsDataModelService.addEntry(reportsEntry, repEntry);
                        try {
                            ProjectFileHandler.saveProject((Entry)projectEntry);
                        }
                        catch (IOException e) {
                            logger.error((Object)("Something went wrong while saving project entry \n" + e.getMessage()), (Throwable)e);
                            logger.fatal((Object)("Closing project entry \"" + projectEntry.getDisplayName() + "\""));
                            gritsDataModelService.closeProject(projectEntry);
                            throw e;
                        }
                        PropertyHandler.getDataModel().setShow(true);
                        if (repEntry != null) {
                            eventBroker.send("grits_entry_selected", (Object)repEntry);
                            gritsUIService.setPartService(partService);
                            gritsUIService.openEntryInPart(repEntry);
                        }
                        break block30;
                    }
                    if (iResult != 256) {
                        logger.error((Object)"Sorry, but an error occurred merging the reports.");
                        ErrorUtils.createErrorMessageBox((Shell)modalDialog, (String)"Sorry, but an error occurred merging the reports.");
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    ErrorUtils.createErrorMessageBox((Shell)modalDialog, (String)e.getMessage(), (Exception)e);
                    return null;
                }
            }
        }
        return null;
    }

    protected MSGlycanAnnotationReportDialog getReportDialog(Shell parentShell, List<Entry> entries) {
        return new MSGlycanAnnotationReportDialog(parentShell, entries);
    }

    protected String getMergeFolder() {
        return "merge";
    }

    private void deleteDirectory(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.deleteDirectory(f);
                ++n2;
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    protected int generateMergeReport(Shell activeShell, final List<ExperimentAnnotation> _lExperimentAnnotations, final double _dInterval, final String _sAccuracyType, final String _sResultFile) {
        ProgressDialog dialog = new ProgressDialog(activeShell, 2);
        ProgressThread worker = new ProgressThread(){

            public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
                ((ProgressDialog)a_progressThreadHandler).setProcessMessageLabel("Generating Merge report");
                Job job = new Job("Generating merge report."){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            MergeReport report = new MergeReport();
                            MergeReportGenerator generator = null;
                            Serializer ser = new Serializer();
                            generator = new MergeReportGenerator(_lExperimentAnnotations, _dInterval, _sAccuracyType);
                            report = generator.generateReport();
                            ser.serialize(report, _sResultFile);
                            return Status.OK_STATUS;
                        }
                        catch (Exception ex) {
                            logger.error((Object)ex.getMessage(), (Throwable)ex);
                            return Status.CANCEL_STATUS;
                        }
                    }
                };
                job.schedule();
                while (!(job.getState() != 2 && job.getState() != 4 || a_progressThreadHandler.isCanceled())) {
                    Thread.sleep(1000L);
                }
                return job.getResult() == Status.OK_STATUS;
            }

            public void cancelWork() {
                MSGlycanAnnotationReportAnnotationHandler.this.canceled = true;
            }
        };
        dialog.setWorker(worker);
        int iRes = dialog.open();
        return iRes;
    }
}

