/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.validation;

import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraphAlternative;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserNodes;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;

public class GlycoVisitorContainsNode
implements GlycoVisitor {
    private int m_iMonosaccharide = 0;
    private int m_iNonMonosaccharide = 0;
    private int m_iNonTerminalNonMonosaccharide = 0;
    private int m_iSubstituent = 0;
    private int m_iRepeat = 0;
    private int m_iUnvalidated = 0;
    private int m_iUnderdetermined = 0;
    private int m_iAlternative = 0;
    private int m_iCyclic = 0;
    private boolean m_bDescent = true;
    private boolean m_bDescentUnderdeterminded = true;
    private String m_strNonMSnames = "";
    private SugarUnitRepeat m_objRepeat = null;

    public String getNonMsNames() {
        return this.m_strNonMSnames;
    }

    public void setDescent(boolean a_bDescent) {
        this.m_bDescent = a_bDescent;
    }

    public void setDescentUnderdeterminded(boolean a_bDescent) {
        this.m_bDescentUnderdeterminded = a_bDescent;
    }

    public int getMonosaccharideCount() {
        return this.m_iMonosaccharide;
    }

    public int getNonMonosaccharideCount() {
        return this.m_iNonMonosaccharide;
    }

    public int getNonTerminalNonMonosaccharideCount() {
        return this.m_iNonTerminalNonMonosaccharide;
    }

    public int getSubstituentCount() {
        return this.m_iSubstituent;
    }

    public int getRepeatCount() {
        return this.m_iRepeat;
    }

    public int getUnvalidatedCount() {
        return this.m_iUnvalidated;
    }

    public int getUnderdetermindedCount() {
        return this.m_iUnderdetermined;
    }

    public int getAlternativeCount() {
        return this.m_iAlternative;
    }

    public int getCyclicCount() {
        return this.m_iCyclic;
    }

    @Override
    public void visit(Monosaccharide arg0) throws GlycoVisitorException {
        ++this.m_iMonosaccharide;
    }

    @Override
    public void visit(NonMonosaccharide a_objNonMS) throws GlycoVisitorException {
        ++this.m_iNonMonosaccharide;
        if (this.m_objRepeat != null) {
            GlycoEdge t_objEdge = this.m_objRepeat.getRepeatLinkage();
            if (a_objNonMS == t_objEdge.getParent() || a_objNonMS == t_objEdge.getChild()) {
                ++this.m_iNonTerminalNonMonosaccharide;
            } else if (this.childInRepeat(a_objNonMS, t_objEdge.getParent())) {
                ++this.m_iNonTerminalNonMonosaccharide;
            }
        }
    }

    private boolean childInRepeat(GlycoNode a_objResidue, GlycoNode a_objRepeatOut) {
        for (GlycoEdge t_objEdge : a_objResidue.getChildEdges()) {
            if (t_objEdge.getChild() == a_objRepeatOut) {
                return true;
            }
            if (!this.childInRepeat(t_objEdge.getChild(), a_objRepeatOut)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(GlycoEdge arg0) throws GlycoVisitorException {
    }

    @Override
    public void visit(SugarUnitRepeat a_objRepeat) throws GlycoVisitorException {
        ++this.m_iRepeat;
        this.m_iUnderdetermined += a_objRepeat.getUndeterminedSubTrees().size();
        if (this.m_bDescent) {
            SugarUnitRepeat t_objBefore = this.m_objRepeat;
            GlycoTraverser t_objTraverser = this.getTraverser(this);
            this.m_objRepeat = a_objRepeat;
            t_objTraverser.traverseGraph(a_objRepeat);
            this.m_objRepeat = t_objBefore;
            if (this.m_bDescentUnderdeterminded) {
                Iterator<UnderdeterminedSubTree> t_iterUnder = a_objRepeat.getUndeterminedSubTrees().iterator();
                while (t_iterUnder.hasNext()) {
                    t_objTraverser = this.getTraverser(this);
                    t_objTraverser.traverseGraph(t_iterUnder.next());
                }
            }
        }
    }

    @Override
    public GlycoTraverser getTraverser(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        return new GlycoTraverserNodes(a_objVisitor);
    }

    @Override
    public void clear() {
        this.m_iMonosaccharide = 0;
        this.m_iNonMonosaccharide = 0;
        this.m_iRepeat = 0;
        this.m_iSubstituent = 0;
        this.m_iUnvalidated = 0;
        this.m_iUnderdetermined = 0;
        this.m_iAlternative = 0;
        this.m_iCyclic = 0;
        this.m_iNonTerminalNonMonosaccharide = 0;
        this.m_strNonMSnames = "";
        this.m_objRepeat = null;
    }

    @Override
    public void visit(Substituent a_objSubstituent) throws GlycoVisitorException {
        ++this.m_iSubstituent;
    }

    @Override
    public void visit(SugarUnitCyclic a_objCyclic) throws GlycoVisitorException {
        ++this.m_iCyclic;
    }

    @Override
    public void visit(SugarUnitAlternative a_objAlternative) throws GlycoVisitorException {
        ++this.m_iAlternative;
        if (this.m_bDescent) {
            for (GlycoGraphAlternative t_objAlternative : a_objAlternative.getAlternatives()) {
                GlycoTraverser t_objTraverser = this.getTraverser(this);
                t_objTraverser.traverseGraph(t_objAlternative);
            }
        }
    }

    @Override
    public void visit(UnvalidatedGlycoNode a_objUnvalidated) throws GlycoVisitorException {
        ++this.m_iUnvalidated;
    }

    @Override
    public void start(Sugar a_objSugar) throws GlycoVisitorException {
        this.clear();
        this.m_iUnderdetermined += a_objSugar.getUndeterminedSubTrees().size();
        GlycoTraverser t_objTraverser = this.getTraverser(this);
        t_objTraverser.traverseGraph(a_objSugar);
        if (this.m_bDescentUnderdeterminded) {
            Iterator<UnderdeterminedSubTree> t_iterUnder = a_objSugar.getUndeterminedSubTrees().iterator();
            while (t_iterUnder.hasNext()) {
                t_objTraverser = this.getTraverser(this);
                t_objTraverser.traverseGraph(t_iterUnder.next());
            }
        }
    }

    public void start(SugarUnitRepeat a_objRepeat) throws GlycoVisitorException {
        this.clear();
        this.m_objRepeat = a_objRepeat;
        GlycoTraverser t_objTraverser = this.getTraverser(this);
        t_objTraverser.traverseGraph(a_objRepeat);
        this.m_iUnderdetermined += a_objRepeat.getUndeterminedSubTrees().size();
        if (this.m_bDescentUnderdeterminded) {
            Iterator<UnderdeterminedSubTree> t_iterUnder = a_objRepeat.getUndeterminedSubTrees().iterator();
            while (t_iterUnder.hasNext()) {
                t_objTraverser = this.getTraverser(this);
                t_objTraverser.traverseGraph(t_iterUnder.next());
            }
        }
    }

    public void start(SugarUnitAlternative a_objAlternative) throws GlycoVisitorException {
        this.clear();
        for (GlycoGraphAlternative t_objAlternative : a_objAlternative.getAlternatives()) {
            GlycoTraverser t_objTraverser = this.getTraverser(this);
            t_objTraverser.traverseGraph(t_objAlternative);
        }
    }
}

