/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.views.tabbed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.editor.EntryEditorPart;
import org.grits.toolbox.core.editor.IEntryEditorPart;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.display.control.table.process.TableDataProcessorRunner;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessorDialogRunner;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationTable;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.SharedCheckboxWidget;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.IMSAnnotationPeaksViewer;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationEntityScroller;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationPeaksView;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationSelectionView;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessor;
import org.grits.toolbox.entry.ms.tablehelpers.MassSpecTable;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecPeaksView;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecTableBase;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;

public class MSAnnotationDetails
extends EntryEditorPart
implements IMSAnnotationPeaksViewer {
    private static final Logger logger = Logger.getLogger(MSAnnotationDetails.class);
    public static final String VIEW_ID = "ms.annotation.glycan.views.MSAnnotationDetails";
    protected MSAnnotationEntityScroller entityScroller = null;
    protected SashForm sashForm = null;
    protected Composite compositeTop = null;
    protected Composite compositeBottom = null;
    protected MSAnnotationEntityProperty msEntityProperty = null;
    protected List<Feature> lFeatures = null;
    protected HashMap<Feature, Peak> htFeatureToPeak = null;
    protected List<MSAnnotationPeaksView> lPeaksViews = null;
    protected List<Composite> lPeakComposites = null;
    protected int iCurView = -1;
    protected MSAnnotationMultiPageViewer parentViewer = null;
    protected int iMinMSLevel = -1;
    protected MSAnnotationTable parentSubsetTableData = null;
    protected String parentViewRowId = null;
    protected int parentViewScanNum = -1;
    protected int parentViewRowIndex = -1;
    protected MPart part;

    @Inject
    public MSAnnotationDetails(MSAnnotationMultiPageViewer parentViewer, Entry entry, Property msEntityProperty, @Named(value="MinMSLevelContext") @Named(value="MinMSLevelContext") int iMinMSLevel) {
        this.entry = entry;
        this.msEntityProperty = (MSAnnotationEntityProperty)msEntityProperty;
        this.iMinMSLevel = iMinMSLevel;
        this.parentViewer = parentViewer;
    }

    @PostConstruct
    public void postConstruct(MPart part) {
        this.part = part;
        this.setParentSubsetTableData();
    }

    public MPart getPart() {
        return this.part;
    }

    public int getParentViewRowIndex() {
        return this.parentViewRowIndex;
    }

    public String getParentViewRowId() {
        return this.parentViewRowId;
    }

    public int getParentViewScanNum() {
        return this.parentViewScanNum;
    }

    public MSAnnotationTable getParentSubsetTable() {
        return this.parentSubsetTableData;
    }

    public void setParentSubsetTableData() {
        MSAnnotationMultiPageViewer viewer = this.getParentMultiPageViewer();
        if (viewer != null) {
            IEntryEditorPart activePage = viewer.getPageItem(viewer.getActivePage());
            MassSpecPeaksView peaksView = null;
            if (activePage instanceof MSAnnotationPeaksView) {
                peaksView = (MassSpecPeaksView)viewer.getPeaksView().get(0);
            } else if (activePage instanceof MSAnnotationDetails) {
                MSAnnotationDetails detailsView = viewer.getDetailsView();
                peaksView = detailsView.getCurrentPeaksView();
            }
            MassSpecTableBase tableBase = peaksView.getViewBase();
            MassSpecTable natTable = tableBase.getNatTable();
            this.parentSubsetTableData = ((MSAnnotationTable)natTable).getCurrentSubsetTable();
            this.parentViewRowId = this.parentSubsetTableData.getParentTableRowId();
            this.parentViewRowIndex = this.parentSubsetTableData.getParentTableRowIndex();
            this.parentViewScanNum = this.parentSubsetTableData.getParentTableParentScanNum();
            logger.debug((Object)("Opening new viewer. Parent peak id: " + this.parentViewRowId));
        }
    }

    public void setParentSubsetTableData(MSAnnotationTable parentSubsetTableData, int parentViewRowIndex, int parentViewScanNum, String parentViewRowId) {
        this.parentSubsetTableData = parentSubsetTableData;
        this.parentViewRowId = parentViewRowId;
        this.parentViewRowIndex = parentViewRowIndex;
        this.parentViewScanNum = parentViewScanNum;
    }

    public void reInitializeView() {
    }

    public String toString() {
        return "MSAnnotationDetails (" + this.entry + ")";
    }

    public List<Composite> getPeakComposites() {
        return this.lPeakComposites;
    }

    public int getMinMSLevel() {
        return this.iMinMSLevel;
    }

    public void setMinMSLevel(int iMinMSLevel) {
        this.iMinMSLevel = iMinMSLevel;
    }

    public void setCurViewIndex(int iCurView) {
        this.iCurView = iCurView;
    }

    public int getCurViewIndex() {
        return this.iCurView;
    }

    public MSAnnotationEntityProperty getMsEntityProperty() {
        return this.msEntityProperty;
    }

    public int getNumFeatures() {
        return this.lFeatures.size();
    }

    public MSAnnotationPeaksView getCurrentPeaksView() {
        return this.lPeaksViews.get(this.iCurView);
    }

    public List<MSAnnotationPeaksView> getPeaksViews() {
        return this.lPeaksViews;
    }

    public MSAnnotationEntityScroller getEntityScroller() {
        return this.entityScroller;
    }

    private void updateView() {
        try {
            if (this.compositeBottom != null) {
                this.compositeBottom.setVisible(false);
            }
            if (this.iCurView < 0) {
                return;
            }
            this.compositeBottom = this.lPeakComposites.get(this.iCurView);
            this.compositeBottom.setVisible(true);
            this.entityScroller.reDraw();
        }
        catch (Exception e) {
            logger.error((Object)"Failed attempt to update view.", (Throwable)e);
        }
    }

    public void goNext() {
        try {
            ++this.iCurView;
            if (this.iCurView >= this.lPeakComposites.size()) {
                this.iCurView = 0;
            }
            this.updateView();
            this.sashForm.layout(true);
        }
        catch (Exception e) {
            logger.error((Object)"Attempted to go to next page when at end of list", (Throwable)e);
        }
    }

    public void goPrev() {
        try {
            --this.iCurView;
            if (this.iCurView < 0) {
                this.iCurView = this.lPeakComposites.size() - 1;
            }
            this.updateView();
            this.sashForm.layout(true);
        }
        catch (Exception e) {
            logger.error((Object)"Attempted to go to prev page when at end of list", (Throwable)e);
        }
    }

    protected MSAnnotationPeaksView getNewPeaksView(Entry entry, MSAnnotationEntityProperty msEntityProperty) {
        this.getPart().getContext().set("MinMSLevelContext", (Object)this.getMinMSLevel());
        this.getPart().getContext().set(Property.class, (Object)msEntityProperty);
        this.getPart().getContext().set(Entry.class, (Object)entry);
        MSAnnotationPeaksView view = (MSAnnotationPeaksView)ContextInjectionFactory.make(MSAnnotationPeaksView.class, (IEclipseContext)this.getPart().getContext());
        return view;
    }

    protected int[] getSashWeights() {
        int[] dWeights = new int[this.lPeaksViews.size() + 1];
        int dPrefTopWeight = this.getPrefEntityScrollerWeight();
        int dPrefBotWeight = 1000 - dPrefTopWeight;
        int iInx = 0;
        dWeights[iInx++] = dPrefTopWeight;
        int i = 0;
        while (i < this.lPeaksViews.size()) {
            dWeights[iInx++] = dPrefBotWeight;
            ++i;
        }
        return dWeights;
    }

    protected int getPrefEntityScrollerWeight() {
        if (this.entityScroller.compositeTop == null) {
            return 1;
        }
        int iTopHeight = this.entityScroller.compositeTop.getSize().y;
        int iFormHeight = this.sashForm.getSize().y;
        int iTopWeight = (int)Math.ceil((double)iTopHeight / (double)iFormHeight * 1000.0) + 30;
        return iTopWeight;
    }

    protected int[] getWeights(int[] iPrefWeights) {
        int[] iWeights = new int[this.lFeatures.size() + 1];
        iWeights[0] = iPrefWeights[0];
        int i = 0;
        while (i < this.lFeatures.size()) {
            iWeights[i + 1] = iPrefWeights[1];
            ++i;
        }
        return iWeights;
    }

    protected int openReadWriteDialog(Integer processType) {
        TableDataProcessorRunner progressDialog = new TableDataProcessorRunner((TableDataProcessor)((MassSpecTableDataProcessor)this.getTableDataProcessor()));
        try {
            this.getTableDataProcessor().setProcessType(processType);
            int iStatus = progressDialog.startJob();
            return iStatus;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    protected HashMap<Feature, Peak> loadFeatures(MSAnnotationEntityProperty msProp) {
        TableDataProcessor proc = ((MassSpecPeaksView)this.parentViewer.getPeaksView().get(0)).getTableDataProcessor();
        MSAnnotationTableDataProcessorDialogRunner progressDialog = new MSAnnotationTableDataProcessorDialogRunner(proc);
        try {
            ((MSAnnotationTableDataProcessor)proc).setCurEntityProperty(msProp);
            proc.setProcessType(MSAnnotationTableDataProcessor.READ_FEATURES);
            int iStatus = progressDialog.startJob();
            if (iStatus == GRITSProcessStatus.OK) {
                return progressDialog.getScanFeatures();
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public int getStatus() {
        if (this.lPeaksViews == null || this.lPeaksViews.isEmpty()) {
            return GRITSProcessStatus.ERROR;
        }
        for (MSAnnotationPeaksView view : this.lPeaksViews) {
            if (view.getStatus() != GRITSProcessStatus.CANCEL) continue;
            return GRITSProcessStatus.CANCEL;
        }
        return GRITSProcessStatus.OK;
    }

    protected void initPeakViews() {
        try {
            MSAnnotationTableDataProcessor proc = (MSAnnotationTableDataProcessor)((MassSpecPeaksView)this.parentViewer.getPeaksView().get(0)).getTableDataProcessor();
            this.htFeatureToPeak = this.loadFeatures(this.msEntityProperty);
            if (this.htFeatureToPeak.isEmpty()) {
                return;
            }
            this.lFeatures = new ArrayList<Feature>();
            this.lPeaksViews = new ArrayList<MSAnnotationPeaksView>();
            this.lPeakComposites = new ArrayList<Composite>();
            String sDialogText = this.parentViewer.getThreadedDialog().getMajorProgressBarListener().getCurText();
            int iFeatureCnt = 0;
            int iNumFeatures = this.htFeatureToPeak.size();
            int iDialogValue = this.parentViewer.getThreadedDialog().getMajorProgressBarListener().getCurValue();
            for (Feature curFeature : this.htFeatureToPeak.keySet()) {
                if (this.msEntityProperty.getMsLevel() > 3 && this.msEntityProperty.getAnnotationId() != null && !this.msEntityProperty.getAnnotationId().equals(curFeature.getAnnotationId())) continue;
                Composite comp = new Composite((Composite)this.sashForm, 2048);
                comp.setVisible(false);
                comp.setLayout((Layout)new FillLayout());
                this.lPeakComposites.add(comp);
                MSAnnotationEntityProperty msProp = (MSAnnotationEntityProperty)((Object)this.msEntityProperty.clone());
                int iAnnotId = curFeature.getAnnotationId();
                msProp.setAnnotationId(iAnnotId);
                msProp.setParentScanNum(msProp.getScanNum());
                msProp.setFeatureId(curFeature.getId());
                MSAnnotationPeaksView peaksView = this.getNewPeaksView(this.entry, msProp);
                peaksView.setTableDataProcessor(this.parentViewer.getThreadedDialog());
                ((MSAnnotationTableDataProcessor)peaksView.getTableDataProcessor()).setCurScanFeature(proc.getCurScanFeature());
                ((MSAnnotationTableDataProcessor)peaksView.getTableDataProcessor()).setCurEntityProperty(msProp);
                this.parentViewer.getThreadedDialog().getMajorProgressBarListener().setProgressMessage(String.valueOf(sDialogText) + ", Feature " + (iFeatureCnt + 1) + " of " + iNumFeatures);
                this.parentViewer.getThreadedDialog().getMajorProgressBarListener().setProgressValue(iDialogValue + iFeatureCnt++);
                peaksView.createPartControl(comp);
                this.lPeaksViews.add(peaksView);
                if (peaksView.getStatus() == GRITSProcessStatus.CANCEL) {
                    return;
                }
                if (iAnnotId == this.msEntityProperty.getAnnotationId()) {
                    this.iCurView = this.lFeatures.size();
                }
                this.lFeatures.add(curFeature);
            }
            this.parentViewer.getThreadedDialog().getMajorProgressBarListener().setProgressValue(iDialogValue + iFeatureCnt);
            assert (this.iCurView >= 0);
        }
        catch (Exception e) {
            logger.error((Object)"Error initializing peak views", (Throwable)e);
        }
    }

    @Optional
    @Inject
    public void peakViewChanged(@UIEventTopic(value="peaksView_modified_in_a_tab") MSAnnotationPeaksView peaksView) {
        if (this.lPeaksViews.contains(peaksView)) {
            this.setDirty(peaksView.isDirty());
        }
    }

    protected MSAnnotationEntityScroller getNewMSAnnotationEntityScroller() {
        MSAnnotationEntityScroller es = new MSAnnotationEntityScroller(this.compositeTop, 0, this);
        return es;
    }

    protected void addScrollerListeners(MSAnnotationEntityScroller es) {
        es.getPrevButton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MSAnnotationDetails.this.goPrev();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        es.getNextButton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MSAnnotationDetails.this.goNext();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected void createView() {
    }

    protected void updateProjectProperty() {
    }

    protected void savePreference() {
    }

    protected Composite getParent() {
        return this.parentViewer.getContainer();
    }

    public void createPartControl(Composite parent) {
        this.sashForm = new SashForm(parent, 512);
        this.sashForm.SASH_WIDTH = 5;
        this.compositeTop = new Composite((Composite)this.sashForm, 2048);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginLeft = -50;
        this.compositeTop.setLayout((Layout)rowLayout);
        this.initPeakViews();
        this.entityScroller = this.getNewMSAnnotationEntityScroller();
        this.entityScroller.createPartControl(this.compositeTop);
        this.addScrollerListeners(this.entityScroller);
        this.updateView();
        this.compositeTop.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                MSAnnotationDetails.this.setWeights();
                MSAnnotationDetails.this.compositeTop.removePaintListener((PaintListener)this);
            }
        });
        this.sashForm.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                MSAnnotationDetails.this.setWeights();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    public List<Feature> getFeatures() {
        return this.lFeatures;
    }

    public Peak getPeakFromFeature(Feature feature) {
        return this.htFeatureToPeak.get(feature);
    }

    protected void setWeights() {
        int[] dWeights = this.getSashWeights();
        this.sashForm.setWeights(dWeights);
    }

    @Focus
    public void setFocus() {
    }

    public MassSpecTableBase getViewBase() {
        return this.getCurrentPeaksView().getViewBase();
    }

    @Override
    public Composite getSelectionArea() {
        return this.getCurrentPeaksView().getSelectionArea();
    }

    @Override
    public MSAnnotationSelectionView getCurrentSelectionView() {
        return this.getCurrentPeaksView().getCurrentSelectionView();
    }

    @Override
    public void initNewSelectionView() {
        this.getCurrentPeaksView().initNewSelectionView();
    }

    @Override
    public Feature getFeature(int iRowNum) {
        return this.lFeatures.get(iRowNum);
    }

    public void setDirty(boolean d) {
        super.setDirty(d);
    }

    public boolean isDirty() {
        return super.isDirty();
    }

    @Persist
    public void doSave(IProgressMonitor monitor) {
        for (MSAnnotationPeaksView pv : this.lPeaksViews) {
            if (!pv.isDirty()) continue;
            pv.doSave(monitor);
        }
    }

    public TableDataProcessor getTableDataProcessor() {
        return null;
    }

    protected MSAnnotationMultiPageViewer getParentMultiPageViewer() {
        Entry parentEntry = this.getEntry().getParent();
        MSAnnotationMultiPageViewer viewer = MSAnnotationMultiPageViewer.getActiveViewerForEntry(this.context, parentEntry);
        return viewer;
    }

    protected SharedCheckboxWidget getParentSharedCheckboxWidget() {
        SharedCheckboxWidget scw = this.parentSubsetTableData.getSharedCheckboxWidget();
        return scw;
    }

    public void toggleParentSelectedRow(String sKey) {
        MSAnnotationMultiPageViewer parentViewer = this.getParentMultiPageViewer();
        if (parentViewer != null) {
            MassSpecPeaksView peakView = null;
            if (parentViewer.getAnnotationDetails() == null) {
                peakView = (MassSpecPeaksView)parentViewer.getPeaksView().get(0);
            } else {
                int iCurViewInx = parentViewer.getAnnotationDetails().getCurViewIndex();
                peakView = parentViewer.getAnnotationDetails().getPeaksViews().get(iCurViewInx);
            }
            MSAnnotationTable parentTable = (MSAnnotationTable)peakView.getViewBase().getNatTable();
            if (!parentTable.getCurrentRowId().equals(this.getParentViewRowId())) {
                MSAnnotationMultiPageViewer.showRowSelection(this.context, parentViewer.getEntry(), parentTable, this.getParentViewRowIndex(), this.getParentViewScanNum(), this.getParentViewRowId());
                parentTable.setCurrentRowId(this.getParentViewRowId());
            }
            parentTable.getCurrentSubsetTable().toggleSubsetTableRowsForClickedItem(sKey);
            boolean bDirty = parentTable.startUpdateHiddenRowsAfterEdit(parentTable.getCurrentSubsetTable());
            parentTable.finishUpdateHiddenRowsAfterEdit(bDirty);
        }
    }

    public void reLoadView() {
    }

    public static String getLabelForCheckbox(String sAnnotDesc, String sFeatureId, int iMSLevel) {
        if (iMSLevel > 3) {
            return String.valueOf(sAnnotDesc) + "-" + sFeatureId;
        }
        return sAnnotDesc;
    }

    @Optional
    @Inject
    void refreshCheckboxes(@UIEventTopic(value="Value_Modified_for_Checkboxes") Entry parentEntry) {
        if (this.getEntry().getParent() != null && this.getEntry().getParent().equals(parentEntry) && this.getPeaksViews() != null) {
            MSAnnotationEntityScroller entityScroller = this.getEntityScroller();
            entityScroller.reDrawLabel();
        }
    }
}

