/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.RepeatInterface;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.util.GlyContainerOptimizer;
import org.glycoinfo.GlycanFormatconverter.util.SubstituentUtility;
import org.glycoinfo.GlycanFormatconverter.util.exchange.GlyContainerToWURCSGraph.GlyContainerEdgeAnalyzer;
import org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer.BackboneToNode;
import org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer.MAPAnalyzer;
import org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer.ModAltToUndUnit;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.util.graph.comparator.WURCSEdgeComparatorSimple;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorCollectSequence;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorException;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.LinkagePosition;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationAlternative;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationRepeat;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSComponent;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;

public class WURCSGraphToGlyContainer {
    private Backbone root = null;
    private GlyContainer glyCo;
    private ArrayList<ModificationAlternative> antennae;
    private ArrayList<ModificationAlternative> undefinedLinkages;
    private ArrayList<ModificationAlternative> undefinedSubstituents;
    private final LinkedList<Backbone> sortedList;
    private final HashMap<WURCSComponent, Node> backbone2node = new HashMap();

    public WURCSGraphToGlyContainer() {
        this.glyCo = new GlyContainer();
        this.antennae = new ArrayList();
        this.undefinedLinkages = new ArrayList();
        this.undefinedSubstituents = new ArrayList();
        this.sortedList = new LinkedList();
    }

    public ArrayList<Node> getSortedList() {
        ArrayList<Node> ret = new ArrayList<Node>();
        for (Backbone bb : this.sortedList) {
            ret.add(this.backbone2node.get(bb));
        }
        return ret;
    }

    public GlyContainer getGlycan() {
        return this.glyCo;
    }

    public void start(WURCSGraph _graph) throws WURCSException, GlycanException {
        Backbone root;
        this.sortNodes(_graph);
        this.root = root = this.sortedList.getFirst();
        BackboneToNode b2n = new BackboneToNode();
        for (Backbone backbone : this.sortedList) {
            this.backbone2node.put((WURCSComponent)backbone, b2n.start(backbone));
        }
        ModAltToUndUnit gfParser = new ModAltToUndUnit(this.glyCo, this.backbone2node);
        gfParser.start(this.sortedList);
        this.antennae = gfParser.getAntennae();
        this.undefinedLinkages = gfParser.getUndefinedLinkages();
        this.undefinedSubstituents = gfParser.getUndefinedSubstituents();
        this.glyCo = gfParser.getGlycan();
        if (this.isCompositions(_graph)) {
            for (Backbone bb : _graph.getBackbones()) {
                this.compositionToUndefinedUnit(bb);
            }
            this.glyCo.setNumberOfUndefinedLinkages(this.undefinedLinkages.size());
            for (ModificationAlternative modAlt : this.undefinedSubstituents) {
                this.compositionToUndefinedUnitForSubstituent(modAlt);
            }
        } else {
            if (this.glyCo.getNodes().isEmpty()) {
                this.glyCo.addNode(this.backbone2node.get(root));
            }
            for (Backbone bb : this.sortedList) {
                this.WURCSEdgeToLinkage(bb);
            }
            GlyContainerEdgeAnalyzer glyContainerEdgeAnalyzer = new GlyContainerEdgeAnalyzer(this.glyCo);
            glyContainerEdgeAnalyzer.start(this.backbone2node, root);
        }
        GlyContainerOptimizer glyContainerOptimizer = new GlyContainerOptimizer();
        this.glyCo = glyContainerOptimizer.start(this.glyCo);
    }

    private void WURCSEdgeToLinkage(Backbone _backbone) throws GlycanException, WURCSFormatException {
        for (WURCSEdge cEdge : _backbone.getChildEdges()) {
            Modification mod = cEdge.getModification();
            if (mod.isRing() || mod instanceof ModificationAlternative || this.isSubstituentEdge(cEdge)) continue;
            if (!(mod instanceof ModificationRepeat)) {
                this.extractSimpleLinkage(_backbone, cEdge);
            }
            if (mod instanceof ModificationRepeat) {
                this.extractRpeatingUnit(_backbone, mod);
            }
            if (!this.isCyclicNodeByEdge(cEdge)) continue;
            this.extractCyclicUnit(_backbone, cEdge, mod);
        }
    }

    private void extractSimpleLinkage(Backbone _backbone, WURCSEdge _donorEdge) throws GlycanException, WURCSFormatException {
        Backbone ccBackbone = null;
        Backbone cpBackbone = null;
        LinkedList donor = null;
        LinkedList acceptor = null;
        Substituent sub = SubstituentUtility.MAPToSubstituent(_donorEdge.getModification());
        for (WURCSEdge cc : _donorEdge.getNextComponent().getChildEdges()) {
            if (_backbone.equals(cc.getBackbone())) continue;
            ccBackbone = cc.getBackbone();
            acceptor = cc.getLinkages();
        }
        for (Object cp : _donorEdge.getNextComponent().getParentEdges()) {
            if (_backbone.equals(cp.getBackbone())) continue;
            cpBackbone = cp.getBackbone();
            donor = cp.getLinkages();
        }
        if (ccBackbone == null && cpBackbone == null) {
            return;
        }
        if (cpBackbone != null) {
            if (this.isCyclicNode(_backbone) || this.isCyclicNode(cpBackbone)) {
                return;
            }
            if (this.haveChild(this.backbone2node.get(_backbone), this.backbone2node.get(cpBackbone), sub)) {
                return;
            }
            if (this.antennae.contains(_backbone)) {
                return;
            }
            if (this.isAntennaeAnchor(cpBackbone)) {
                return;
            }
            acceptor = _donorEdge.getLinkages();
        }
        if (ccBackbone != null) {
            if (this.haveChild(this.backbone2node.get(ccBackbone), this.backbone2node.get(_backbone), sub)) {
                return;
            }
            donor = _donorEdge.getLinkages();
        }
        Edge edge = null;
        if (ccBackbone != null) {
            edge = this.WURCSEdgeToEdge(donor, acceptor);
        }
        if (cpBackbone != null) {
            edge = this.WURCSEdgeToEdge(acceptor, donor);
        }
        if (sub != null) {
            sub.setFirstPosition(new Linkage());
            sub.setSecondPosition(new Linkage());
        }
        for (LinkagePosition lp : donor) {
            if (lp.getModificationPosition() == 0) continue;
            sub.getSecondPosition().addChildLinkage(lp.getModificationPosition());
        }
        for (LinkagePosition lp : acceptor) {
            if (lp.getModificationPosition() == 0) continue;
            sub.getFirstPosition().addChildLinkage(lp.getModificationPosition());
        }
        edge.setSubstituent(sub);
        if (this.glyCo.containsAntennae(this.backbone2node.get(_backbone))) {
            GlycanUndefinedUnit und = this.glyCo.getUndefinedUnitWithIndex(this.backbone2node.get(_backbone));
            if (ccBackbone != null) {
                und.addNode(this.backbone2node.get(_backbone), edge, this.backbone2node.get(ccBackbone));
            }
            if (cpBackbone != null) {
                und.addNode(this.backbone2node.get(_backbone), edge, this.backbone2node.get(cpBackbone));
            }
        } else {
            if (ccBackbone != null && !this.isDefinedLinkage(_backbone, edge, ccBackbone)) {
                this.glyCo.addNode(this.backbone2node.get(_backbone), edge, this.backbone2node.get(ccBackbone));
            }
            if (cpBackbone != null && !this.isDefinedLinkage(_backbone, edge, cpBackbone)) {
                this.glyCo.addNode(this.backbone2node.get(_backbone), edge, this.backbone2node.get(cpBackbone));
            }
        }
    }

    private void extractRpeatingUnit(Backbone _backbone, Modification _mod) throws GlycanException, WURCSFormatException {
        Node current = this.backbone2node.get(_backbone);
        LinkedList donor = ((WURCSEdge)_mod.getParentEdges().getLast()).getLinkages();
        LinkedList acceptor = ((WURCSEdge)_mod.getParentEdges().getFirst()).getLinkages();
        Node end = this.backbone2node.get(((WURCSEdge)_mod.getParentEdges().getLast()).getBackbone());
        Node start = this.backbone2node.get(((WURCSEdge)_mod.getParentEdges().getFirst()).getBackbone());
        if (!current.equals(end)) {
            return;
        }
        if (!this.isStandardRepeatEdgeOrder((ModificationRepeat)_mod)) {
            LinkedList linkTemp = donor;
            donor = acceptor;
            acceptor = linkTemp;
            Node temp = end;
            end = start;
            start = temp;
        }
        Edge parentEdge = this.WURCSEdgeToEdge(donor, acceptor);
        parentEdge.setSubstituent(this.makeSubstituentWithRepeat(_mod));
        for (Edge edge : end.getChildEdges()) {
            if (!start.equals(edge.getChild())) continue;
            return;
        }
        this.glyCo.addNode(end, parentEdge, start);
    }

    private boolean isStandardRepeatEdgeOrder(ModificationRepeat _rep) throws GlycanException {
        WURCSEdgeComparatorSimple t_comp;
        int t_iComp;
        Boolean t_bLastIsAnom;
        boolean t_bLastIsParent;
        boolean t_bFirstIsParent;
        Backbone t_bbLast;
        if (_rep.getParentEdges().size() != 2) {
            throw new GlycanException("Illegal repeat connections.");
        }
        WURCSEdge t_edgeFirst = (WURCSEdge)_rep.getParentEdges().getFirst();
        WURCSEdge t_edgeLast = (WURCSEdge)_rep.getParentEdges().getLast();
        Backbone t_bbFirst = t_edgeFirst.getBackbone();
        if (!t_bbFirst.equals(t_bbLast = t_edgeLast.getBackbone()) && (t_bFirstIsParent = this.checkParentToChild(t_bbFirst, t_bbLast)) != (t_bLastIsParent = this.checkParentToChild(t_bbLast, t_bbFirst))) {
            return t_bFirstIsParent;
        }
        Boolean t_bFirstIsAnom = this.isAnomericEdge(t_edgeFirst);
        if (t_bFirstIsAnom != (t_bLastIsAnom = this.isAnomericEdge(t_edgeLast))) {
            if (t_bFirstIsAnom != null && t_bFirstIsAnom.booleanValue()) {
                return true;
            }
            if (t_bLastIsAnom != null && t_bLastIsAnom.booleanValue()) {
                return false;
            }
            if (t_bFirstIsAnom == null) {
                return true;
            }
            if (t_bLastIsAnom == null) {
                return false;
            }
        }
        if ((t_iComp = (t_comp = new WURCSEdgeComparatorSimple()).compare(t_edgeFirst, t_edgeLast)) != 0) {
            return t_iComp < 0;
        }
        return true;
    }

    private boolean checkParentToChild(Backbone _bb1, Backbone _bb2) {
        LinkedList<Backbone> t_lChildrenQueue = new LinkedList<Backbone>();
        t_lChildrenQueue.add(_bb1);
        while (!t_lChildrenQueue.isEmpty()) {
            Backbone t_bb = (Backbone)t_lChildrenQueue.removeFirst();
            for (WURCSEdge t_edgeChild : t_bb.getChildEdges()) {
                Modification t_mod = t_edgeChild.getModification();
                if (t_mod instanceof RepeatInterface) continue;
                for (WURCSEdge t_edgeChildChild : t_mod.getChildEdges()) {
                    Backbone t_bbChild = t_edgeChildChild.getBackbone();
                    if (!_bb2.equals(t_bbChild)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Boolean isAnomericEdge(WURCSEdge _oEdge) {
        if (_oEdge.getLinkages().size() > 1) {
            return false;
        }
        int t_iAnomPos = _oEdge.getBackbone().getAnomericPosition();
        if (t_iAnomPos == 0 || t_iAnomPos == -1) {
            return null;
        }
        if (((LinkagePosition)_oEdge.getLinkages().getFirst()).getBackbonePosition() != t_iAnomPos) {
            return false;
        }
        return true;
    }

    private void extractCyclicUnit(Backbone _backbone, WURCSEdge _cEdge, Modification _mod) throws GlycanException, WURCSFormatException {
        if (!_cEdge.getNextComponent().getChildEdges().isEmpty()) {
            return;
        }
        if (_mod instanceof ModificationRepeat) {
            return;
        }
        Node start = this.backbone2node.get(_backbone);
        Object end = null;
        Edge cyclicEdge = new Edge();
        Linkage lin = new Linkage();
        block0: for (WURCSEdge edge : _backbone.getChildEdges()) {
            if (edge.getModification().isRing() || edge.getModification() instanceof ModificationRepeat) continue;
            if (!edge.getModification().getMAPCode().equals("")) break;
            for (WURCSEdge cp : edge.getNextComponent().getParentEdges()) {
                if (_backbone.equals(cp.getBackbone())) continue;
                end = this.backbone2node.get(cp.getBackbone());
            }
            if (end == null) continue;
            for (WURCSEdge cc : edge.getNextComponent().getChildEdges()) {
                if (!end.equals(this.backbone2node.get(cc.getBackbone()))) continue;
                end = null;
                continue block0;
            }
        }
        if (end == null) {
            return;
        }
        for (WURCSEdge cpEdge : _cEdge.getNextComponent().getParentEdges()) {
            for (LinkagePosition lp : cpEdge.getLinkages()) {
                if (cpEdge.getBackbone().getAnomericPosition() == lp.getBackbonePosition()) {
                    lin.addChildLinkage(lp.getBackbonePosition());
                    continue;
                }
                lin.addParentLinkage(lp.getBackbonePosition());
            }
        }
        if (lin.getChildLinkages().isEmpty() || lin.getParentLinkages().isEmpty()) {
            return;
        }
        cyclicEdge.addGlycosidicLinkage(lin);
        cyclicEdge.setSubstituent(this.makeSubstituentWithRepeat(_mod));
        if (!end.equals(start)) {
            this.glyCo.addNode((Node)end, cyclicEdge, start);
        }
    }

    private void compositionToUndefinedUnitForSubstituent(ModificationAlternative _modAlt) throws GlycanException, WURCSFormatException {
        Substituent sub = SubstituentUtility.MAPToSubstituent((Modification)_modAlt);
        sub.setFirstPosition(new Linkage());
        sub.setSecondPosition(new Linkage());
        sub.getFirstPosition().addParentLinkage(-1);
        sub.getFirstPosition().addChildLinkage(1);
        if (sub.getSubstituent() instanceof BaseCrossLinkedTemplate) {
            sub.getSecondPosition().addParentLinkage(-1);
            sub.getSecondPosition().addChildLinkage(1);
        }
        Edge edge = new Edge();
        edge.setSubstituent(sub);
        sub.addParentEdge(edge);
        GlycanUndefinedUnit t_und = new GlycanUndefinedUnit();
        t_und.setConnection(edge);
        this.glyCo.addGlycanUndefinedUnitForSubstituent(t_und);
    }

    private void compositionToUndefinedUnit(Backbone _backbone) throws GlycanException {
        Node current = this.backbone2node.get(_backbone);
        GlycanUndefinedUnit und = new GlycanUndefinedUnit();
        und.addNode(current);
        this.glyCo.addGlycanUndefinedUnit(und);
    }

    private Edge WURCSEdgeToEdge(LinkedList<LinkagePosition> _donor, LinkedList<LinkagePosition> _acceptor) throws GlycanException {
        Edge edge = new Edge();
        Linkage lin = new Linkage();
        for (LinkagePosition lp : _acceptor) {
            lin.addChildLinkage(lp.getBackbonePosition());
        }
        for (LinkagePosition lp : _donor) {
            lin.addParentLinkage(lp.getBackbonePosition());
        }
        lin.setProbabilityLower(_donor.getFirst().getProbabilityLower());
        lin.setProbabilityUpper(_donor.getFirst().getProbabilityUpper());
        lin.setChildProbabilityLower(_acceptor.getFirst().getProbabilityLower());
        lin.setChildProbabilityUpper(_acceptor.getFirst().getProbabilityUpper());
        edge.addGlycosidicLinkage(lin);
        return edge;
    }

    private Substituent makeSubstituentWithRepeat(Modification _mod) throws GlycanException, WURCSFormatException {
        MAPAnalyzer mapAnalyze = new MAPAnalyzer();
        mapAnalyze.start(_mod.getMAPCode());
        BaseCrossLinkedTemplate bcT = mapAnalyze.getCrossTemplate();
        GlycanRepeatModification ret = new GlycanRepeatModification(bcT);
        ret.setHeadAtom(mapAnalyze.getHeadAtom());
        ret.setTailAtom(mapAnalyze.getTailAtom());
        ModificationRepeat repMod = _mod instanceof ModificationRepeat ? (ModificationRepeat)_mod : null;
        ret.setMinRepeatCount(repMod == null ? 1 : repMod.getMinRepeatCount());
        ret.setMaxRepeatCount(repMod == null ? 1 : repMod.getMaxRepeatCount());
        ret.setFirstPosition(new Linkage());
        ret.setSecondPosition(new Linkage());
        return ret;
    }

    private void sortNodes(WURCSGraph _graph) throws WURCSVisitorException {
        WURCSVisitorCollectSequence w = new WURCSVisitorCollectSequence();
        w.start(_graph);
        for (WURCSComponent wc : w.getNodes()) {
            if (!(wc instanceof Backbone) || this.sortedList.contains(wc)) continue;
            this.sortedList.add((Backbone)wc);
        }
    }

    private boolean isCyclicNode(Backbone _backbone) {
        if (!this.root.equals(_backbone)) {
            return false;
        }
        boolean isCyclic = false;
        Backbone end = null;
        block0: for (WURCSEdge edge : _backbone.getChildEdges()) {
            if (edge.getModification().isRing()) continue;
            if (this.isSubstituentEdge(edge) || edge.getModification() instanceof ModificationRepeat) break;
            if (edge.getModification().isGlycosidic() && !edge.getModification().getMAPCode().equals("")) continue;
            for (WURCSEdge cp : edge.getNextComponent().getParentEdges()) {
                if (cp.getNextComponent() instanceof ModificationAlternative || _backbone.equals(cp.getBackbone()) || cp.getBackbone().getParentEdges().isEmpty()) continue;
                end = cp.getBackbone();
            }
            for (WURCSEdge cc : edge.getNextComponent().getChildEdges()) {
                if (!(cc.getNextComponent() instanceof ModificationAlternative)) continue;
            }
            if (end == null) continue;
            for (WURCSEdge cc : edge.getNextComponent().getChildEdges()) {
                if (!end.equals(cc.getBackbone())) continue;
                end = null;
                continue block0;
            }
        }
        isCyclic = end != null;
        return isCyclic;
    }

    private boolean isCyclicNodeByEdge(WURCSEdge _edge) {
        Modification mod = _edge.getModification();
        if (mod instanceof ModificationRepeat) {
            return false;
        }
        if (this.isSubstituentEdge(_edge)) {
            return false;
        }
        if (mod.isRing()) {
            return false;
        }
        if (mod.isGlycosidic() && !mod.getMAPCode().equals("")) {
            return false;
        }
        return this.isCyclicNode(_edge.getBackbone());
    }

    private boolean isSubstituentEdge(WURCSEdge _wedge) {
        Modification mod = _wedge.getModification();
        if (mod.isGlycosidic() || mod.isRing() || mod instanceof ModificationRepeat || mod instanceof ModificationAlternative) {
            return false;
        }
        if (!_wedge.getModification().getMAPCode().equals("")) {
            return _wedge.getNextComponent().getChildEdges().isEmpty() && !_wedge.getNextComponent().getParentEdges().isEmpty();
        }
        return _wedge.getNextComponent().getChildEdges().isEmpty() && _wedge.getNextComponent().getParentEdges().size() == 2;
    }

    private boolean haveChild(Node _parent, Node _child, Node _sub) {
        if (_parent.getParentEdges().isEmpty()) {
            return false;
        }
        boolean ret = false;
        for (Edge edge : _parent.getParentEdges()) {
            if (edge.getParent() == null || edge.getChild() == null || edge.getSubstituent() == null && _sub != null || edge.getSubstituent() != null && _sub == null || !edge.getParent().equals(_child) || !edge.getChild().equals(_parent)) continue;
            ret = true;
        }
        return ret;
    }

    private boolean isAntennaeAnchor(Backbone _backbone) {
        boolean ret = false;
        for (ModificationAlternative modAlt : this.antennae) {
            for (WURCSEdge inEdge : modAlt.getLeadInEdges()) {
                for (WURCSEdge parentEdge : inEdge.getNextComponent().getParentEdges()) {
                    if (!parentEdge.getBackbone().equals(_backbone)) continue;
                    ret = true;
                    break;
                }
                if (!ret) continue;
                break;
            }
            if (!ret) continue;
            break;
        }
        return ret;
    }

    private boolean isFlipFlop(Backbone _parent) {
        if (!_parent.isRoot() || this.root.equals(_parent) || this.antennae.contains(_parent)) {
            return false;
        }
        return this.backbone2node.get(_parent).getParentEdges().isEmpty();
    }

    private boolean isCompositions(WURCSGraph _graph) {
        int count = 0;
        if (_graph.getBackbones().size() == 1) {
            return false;
        }
        for (Backbone bb : _graph.getBackbones()) {
            for (WURCSEdge wurcsEdge : bb.getChildEdges()) {
                Modification mod = wurcsEdge.getModification();
                if (mod.isRing()) continue;
                if (mod.isGlycosidic()) {
                    ++count;
                    continue;
                }
                if (mod instanceof ModificationAlternative) {
                    if (!((ModificationAlternative)mod).getLeadOutEdges().isEmpty() && !((ModificationAlternative)mod).getLeadInEdges().isEmpty()) continue;
                    ++count;
                    continue;
                }
                if (mod.getMAPCode().equals("") || mod.getEdges().size() <= 1) continue;
                ++count;
            }
        }
        return count == 0;
    }

    private boolean isDefinedLinkage(Backbone _acceptor, Edge _edge, Backbone _donor) {
        Node donor = this.backbone2node.get(_donor);
        Node acceptor = this.backbone2node.get(_acceptor);
        if (donor == null || acceptor == null) {
            return false;
        }
        boolean isDefined = false;
        int currentDonorPos = -1;
        int currentAcceptorPos = -1;
        for (Linkage lin : _edge.getGlycosidicLinkages()) {
            if (lin.getChildLinkages().size() > 1 || lin.getParentLinkages().size() > 1) continue;
            currentDonorPos = lin.getChildLinkages().get(0);
            currentAcceptorPos = lin.getParentLinkages().get(0);
        }
        for (Edge edge : acceptor.getChildEdges()) {
            if (edge.getChild() == null || edge.getParent() == null || !edge.getChild().equals(donor) || !edge.getParent().equals(acceptor)) continue;
            for (Linkage lin : edge.getGlycosidicLinkages()) {
                if (lin.getChildLinkages().size() > 1 || lin.getParentLinkages().size() > 1 || !lin.getChildLinkages().contains(currentDonorPos) || !lin.getParentLinkages().contains(currentAcceptorPos)) continue;
                isDefined = true;
            }
        }
        return isDefined;
    }

    private void open(Backbone _backbone, Backbone _cpBackbone, Backbone _ccBackbone, LinkedList<LinkagePosition> _acceptor, LinkedList<LinkagePosition> _donor, Substituent _sub) {
        if (_sub != null) {
            System.out.println(_sub.getSubstituent());
        }
        if (_ccBackbone != null) {
            System.out.println("cc : " + _ccBackbone + "<-" + _backbone);
            System.out.println(_ccBackbone.getSkeletonCode() + " " + _backbone.getSkeletonCode());
            System.out.println("cc : " + this.backbone2node.get(_ccBackbone) + "<-" + this.backbone2node.get(_backbone));
        }
        if (_cpBackbone != null) {
            System.out.println("cp : " + _cpBackbone + "<=" + _backbone);
            System.out.println(_cpBackbone.getSkeletonCode() + " " + _backbone.getSkeletonCode());
            System.out.println("cp : " + this.backbone2node.get(_cpBackbone) + "<-" + this.backbone2node.get(_backbone));
        }
        if (_acceptor != null) {
            for (LinkagePosition lp : _acceptor) {
                System.out.println("acceptor : " + lp.getBackbonePosition() + " " + lp.getDirection() + " " + lp.getProbabilityPosition());
            }
        }
        if (_donor != null) {
            for (LinkagePosition lp : _donor) {
                System.out.println("donor : " + lp.getBackbonePosition() + " " + lp.getDirection() + " " + lp.getProbabilityPosition());
            }
        }
        System.out.println("");
    }
}

