/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.Molecule;
import org.eurocarbdb.application.glycanbuilder.MouseUtils;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.Annotation;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotationMultiple;
import org.eurocarbdb.application.glycoworkbench.PeakList;
import org.eurocarbdb.application.glycoworkbench.plugin.DocumentPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.MSUtils;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYShapeAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYBarDataset;
import org.jfree.data.xy.XYDataset;

public class PeakListChartPanel
extends DocumentPanel<PeakList>
implements ActionListener,
MouseListener,
MouseMotionListener {
    protected AnnotatedPeakList theSearchResults;
    protected DefaultXYDataset theDataset;
    protected DefaultXYDataset theIsotopesDataset;
    protected XYPlot thePlot;
    protected JFreeChart theChart;
    protected ChartPanel theChartPanel;
    protected JToolBar theToolBar;
    protected int current_ind;
    protected TreeMap<Double, Double> visibleData;
    protected Peak current_peak;
    protected TreeSet<Peak> selected_peaks;
    protected String shown_mslevel;
    protected JButton mslevel_button;
    protected boolean was_moving;
    protected boolean is_moving;
    protected Point2D mouse_start_point;
    protected Rectangle2D zoom_rectangle;
    protected Cursor hand_cursor;
    protected GlycanAction ms_action;
    protected GlycanAction msms_action;
    protected boolean update_isotope_curves;
    protected boolean automatic_update_isotope_curves;
    protected boolean show_all_isotopes;
    protected JButton isotopes_button;
    protected JButton ftmode_button;
    protected Vector<SelectionChangeListener> listeners;

    @Override
    protected void initSingletons() {
        super.initSingletons();
        this.selected_peaks = new TreeSet();
        this.shown_mslevel = "msms";
        this.current_ind = 0;
        this.visibleData = new TreeMap();
        this.update_isotope_curves = false;
        this.automatic_update_isotope_curves = false;
        this.show_all_isotopes = false;
    }

    @Override
    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.theDataset = new DefaultXYDataset();
        this.theIsotopesDataset = new DefaultXYDataset();
        this.theChart = ChartFactory.createScatterPlot((String)"PeakList", (String)"m/z ratio", (String)"Intensity", (XYDataset)new XYBarDataset((XYDataset)this.theDataset, 0.001), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.thePlot = (XYPlot)this.theChart.getPlot();
        this.thePlot.setRenderer((XYItemRenderer)new XYBarRenderer());
        this.thePlot.setDataset(1, (XYDataset)this.theIsotopesDataset);
        this.thePlot.setRenderer(1, (XYItemRenderer)new StandardXYItemRenderer(2));
        this.theChartPanel = new ChartPanel(this.theChart);
        this.theChartPanel.setDomainZoomable(false);
        this.theChartPanel.setRangeZoomable(false);
        this.theChartPanel.setPopupMenu(null);
        this.add((Component)this.theChartPanel, "Center");
        this.theToolBar = this.createToolBar();
        this.add((Component)this.theToolBar, "South");
    }

    @Override
    protected void finalSettings() {
        this.hand_cursor = FileUtils.createCursor((String)"hand");
        this.listeners = new Vector();
        this.thePlot.getDomainAxis().addChangeListener(new AxisChangeListener(){

            public void axisChanged(AxisChangeEvent event) {
                PeakListChartPanel.this.updateChart();
            }
        });
        this.theChartPanel.addMouseMotionListener((MouseMotionListener)this);
        this.theChartPanel.addMouseListener((MouseListener)this);
        this.was_moving = false;
        this.is_moving = false;
        this.mouse_start_point = null;
        this.zoom_rectangle = null;
        super.finalSettings();
    }

    @Override
    public PeakList getDocumentFromWorkspace(GlycanWorkspace workspace) {
        return workspace != null ? workspace.getPeakList() : null;
    }

    @Override
    public void setDocumentFromWorkspace(GlycanWorkspace workspace) {
        if (this.theDocument != null) {
            ((PeakList)((Object)this.theDocument)).removeDocumentChangeListener(this);
        }
        if (this.theSearchResults != null) {
            this.theSearchResults.removeDocumentChangeListener(this);
        }
        this.theDocument = this.getDocumentFromWorkspace(workspace);
        if (this.theDocument == null) {
            this.theDocument = new PeakList();
        }
        this.theSearchResults = workspace != null ? workspace.getSearchResults() : null;
        ((PeakList)((Object)this.theDocument)).addDocumentChangeListener(this);
        if (this.theSearchResults != null) {
            this.theSearchResults.addDocumentChangeListener(this);
        }
        this.current_ind = 0;
        this.updateView();
        this.updateActions();
    }

    @Override
    protected void createActions() {
        this.theActionManager.add("mslevel=ms", FileUtils.defaultThemeManager.getImageIcon("msms"), "Change current scan level", -1, "", (ActionListener)this);
        this.theActionManager.add("mslevel=msms", FileUtils.defaultThemeManager.getImageIcon("ms"), "Change current scan level", -1, "", (ActionListener)this);
        this.theActionManager.add("updateisotopecurves=true", FileUtils.defaultThemeManager.getImageIcon("isotopesoff"), "Automatic computation of isotopic distributions inactive", -1, "", (ActionListener)this);
        this.theActionManager.add("updateisotopecurves=false", FileUtils.defaultThemeManager.getImageIcon("isotopeson"), "Automatic computation of isotopic distributions active", -1, "", (ActionListener)this);
        this.theActionManager.add("showallisotopes=true", FileUtils.defaultThemeManager.getImageIcon("ftmodeoff"), "FTICR mode inactive", -1, "", (ActionListener)this);
        this.theActionManager.add("showallisotopes=false", FileUtils.defaultThemeManager.getImageIcon("ftmodeon"), "FTICR mode active", -1, "", (ActionListener)this);
        this.theActionManager.add("new", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.REFRESH, Plugin.DEFAULT_ICON_SIZE), "Clear", 78, "", (ActionListener)this);
        this.theActionManager.add("open", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_OPEN, Plugin.DEFAULT_ICON_SIZE), "Open...", 79, "", (ActionListener)this);
        this.theActionManager.add("print", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_PRINT, Plugin.DEFAULT_ICON_SIZE), "Print...", 80, "", (ActionListener)this);
        this.theActionManager.add("annotatepeaks", FileUtils.defaultThemeManager.getImageIcon("annotatepeaks"), "Find possible annotations for selected peaks", -1, "", (ActionListener)this);
        this.theActionManager.add("arrow", FileUtils.defaultThemeManager.getImageIcon("arrow"), "Activate zoom", -1, "", (ActionListener)this);
        this.theActionManager.add("hand", FileUtils.defaultThemeManager.getImageIcon("hand"), "Activate moving", -1, "", (ActionListener)this);
        this.theActionManager.add("zoomnone", FileUtils.defaultThemeManager.getImageIcon("zoomnone"), "Reset zoom", -1, "", (ActionListener)this);
        this.theActionManager.add("zoomin", FileUtils.defaultThemeManager.getImageIcon("zoomin"), "Zoom in", -1, "", (ActionListener)this);
        this.theActionManager.add("zoomout", FileUtils.defaultThemeManager.getImageIcon("zoomout"), "Zoom out", -1, "", (ActionListener)this);
    }

    protected void updatePeakActions() {
        if (this.ms_action == null && this.theApplication.getPluginManager().getMsPeakActions().size() > 0) {
            this.ms_action = this.theApplication.getPluginManager().getMsPeakActions().iterator().next();
        }
        if (this.msms_action == null && this.theApplication.getPluginManager().getMsMsPeakActions().size() > 0) {
            this.msms_action = this.theApplication.getPluginManager().getMsMsPeakActions().iterator().next();
        }
    }

    @Override
    protected void updateActions() {
        this.theActionManager.get("arrow").setEnabled(this.is_moving);
        this.theActionManager.get("hand").setEnabled(!this.is_moving);
        this.theActionManager.get("zoomnone").setEnabled(((PeakList)((Object)this.theDocument)).size() > 0);
        this.theActionManager.get("zoomin").setEnabled(((PeakList)((Object)this.theDocument)).size() > 0);
        this.theActionManager.get("zoomout").setEnabled(((PeakList)((Object)this.theDocument)).size() > 0);
        this.theActionManager.get("annotatepeaks").setEnabled(this.selected_peaks.size() > 0);
        this.updateMsLevel();
    }

    @Override
    protected void updateData() {
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("new"));
        toolbar.add((Action)this.theActionManager.get("open"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("print"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("arrow"));
        toolbar.add((Action)this.theActionManager.get("hand"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("zoomnone"));
        toolbar.add((Action)this.theActionManager.get("zoomin"));
        toolbar.add((Action)this.theActionManager.get("zoomout"));
        toolbar.addSeparator();
        this.mslevel_button = new JButton((Action)this.theActionManager.get("mslevel=msms"));
        toolbar.add(this.mslevel_button);
        this.mslevel_button.setText(null);
        toolbar.add((Action)this.theActionManager.get("annotatepeaks"));
        toolbar.addSeparator();
        this.isotopes_button = new JButton((Action)this.theActionManager.get("updateisotopecurves=true"));
        toolbar.add(this.isotopes_button);
        this.isotopes_button.setText(null);
        this.ftmode_button = new JButton((Action)this.theActionManager.get("showallisotopes=true"));
        toolbar.add(this.ftmode_button);
        this.ftmode_button.setText(null);
        return toolbar;
    }

    private JPopupMenu createPopupMenu(boolean over_peak) {
        JPopupMenu menu = new JPopupMenu();
        if (over_peak) {
            this.updatePeakActions();
            ButtonGroup group = new ButtonGroup();
            if (this.shown_mslevel.equals("ms")) {
                for (GlycanAction a : this.theApplication.getPluginManager().getMsPeakActions()) {
                    JRadioButtonMenuItem last = new JRadioButtonMenuItem((Action)new GlycanAction(a, "annotatepeaks", -1, "", (ActionListener)this));
                    menu.add(last);
                    last.setSelected(a == this.ms_action);
                    group.add(last);
                }
            } else {
                for (GlycanAction a : this.theApplication.getPluginManager().getMsMsPeakActions()) {
                    JRadioButtonMenuItem last = new JRadioButtonMenuItem((Action)new GlycanAction(a, "annotatepeaks", -1, "", (ActionListener)this));
                    menu.add(last);
                    last.setSelected(a == this.msms_action);
                    group.add(last);
                }
            }
            menu.addSeparator();
        }
        menu.add((Action)this.theActionManager.get("zoomnone"));
        menu.add((Action)this.theActionManager.get("zoomin"));
        menu.add((Action)this.theActionManager.get("zoomout"));
        return menu;
    }

    public double screenToDataX(double length) {
        Rectangle2D data_area = this.theChartPanel.getScreenDataArea();
        double mz_unit = this.thePlot.getDomainAxis().lengthToJava2D(1.0, data_area, this.thePlot.getDomainAxisEdge());
        return length / mz_unit;
    }

    public double screenToDataY(double length) {
        Rectangle2D data_area = this.theChartPanel.getScreenDataArea();
        double int_unit = this.thePlot.getRangeAxis().lengthToJava2D(1.0, data_area, this.thePlot.getRangeAxisEdge());
        return length / int_unit;
    }

    public Point2D screenToDataCoords(Point2D p) {
        Rectangle2D data_area = this.theChartPanel.getScreenDataArea();
        double x = this.thePlot.getDomainAxis().java2DToValue(p.getX(), data_area, this.thePlot.getDomainAxisEdge());
        double y = this.thePlot.getRangeAxis().java2DToValue(p.getY(), data_area, this.thePlot.getRangeAxisEdge());
        return new Point2D.Double(x, y);
    }

    public double screenToDataCoordX(double x) {
        Rectangle2D data_area = this.theChartPanel.getScreenDataArea();
        return this.thePlot.getDomainAxis().java2DToValue(x, data_area, this.thePlot.getDomainAxisEdge());
    }

    public double screenToDataCoordY(double y) {
        Rectangle2D data_area = this.theChartPanel.getScreenDataArea();
        return this.thePlot.getRangeAxis().java2DToValue(y, data_area, this.thePlot.getRangeAxisEdge());
    }

    public void updateMZAxis() {
        if (((PeakList)((Object)this.theDocument)).size() > 0) {
            this.thePlot.getDomainAxis().setRange(((PeakList)((Object)this.theDocument)).getMZRange());
        } else {
            this.thePlot.getDomainAxis().setRange(new Range(0.0, 1.0));
        }
    }

    public void updateIntensityAxis() {
        double max_int = 0.0;
        for (int d = 0; d < this.thePlot.getDatasetCount(); ++d) {
            XYDataset dataset = this.thePlot.getDataset(d);
            for (int s = 0; s < dataset.getSeriesCount(); ++s) {
                for (int i = 0; i < dataset.getItemCount(s); ++i) {
                    max_int = Math.max(max_int, dataset.getYValue(s, i));
                }
            }
        }
        if (max_int == 0.0) {
            return;
        }
        Range new_int_range = new Range(0.0, max_int);
        Rectangle2D data_area = this.theChartPanel.getScreenDataArea();
        if (data_area.getHeight() > 0.0) {
            new_int_range = Range.expand((Range)new_int_range, (double)0.0, (double)(12.0 / data_area.getHeight()));
        }
        this.thePlot.getRangeAxis().setRange(new_int_range);
    }

    public void updateChart() {
        if (((PeakList)((Object)this.theDocument)).size() > 0) {
            Range mz_range = this.thePlot.getDomainAxis().getRange();
            double mz_toll = this.screenToDataX(1.0);
            double[][] data = ((PeakList)((Object)this.theDocument)).getData(mz_range.getLowerBound(), mz_range.getUpperBound());
            this.visibleData.clear();
            double min_int = data[0].length > 0 ? data[1][0] : 0.0;
            double max_int = data[0].length > 0 ? data[1][0] : 0.0;
            for (int i = 0; i < data[0].length; ++i) {
                min_int = Math.min(min_int, data[1][i]);
                max_int = Math.max(max_int, data[1][i]);
                this.visibleData.put(data[0][i], data[1][i]);
            }
            Range new_int_range = new Range(0.0, max_int);
            Rectangle2D data_area = this.theChartPanel.getScreenDataArea();
            if (data_area.getHeight() > 0.0) {
                new_int_range = Range.expand((Range)new_int_range, (double)0.0, (double)(12.0 / data_area.getHeight()));
            }
            this.thePlot.getRangeAxis().setRange(new_int_range);
            this.theDataset.removeSeries((Comparable)((Object)"intensities"));
            this.theDataset.addSeries((Comparable)((Object)"intensities"), data);
        } else {
            this.thePlot.getRangeAxis().setRange(new Range(0.0, 1.0));
            this.theDataset.removeSeries((Comparable)((Object)"intensities"));
        }
        this.showSelection();
    }

    public void updateTitle() {
        if (((PeakList)((Object)this.theDocument)).size() > 0) {
            String title = "PeakList";
            title = this.shown_mslevel.equals("ms") ? title + ", MS" : title + ", MS/MS";
            this.theChart.setTitle(title);
        } else {
            this.theChart.setTitle("PeakList");
        }
    }

    public void updateMsLevel() {
        if (this.theWorkspace.getCurrentScan() != null) {
            this.onSetMsLevel(this.theWorkspace.getCurrentScan().isMsMs() ? "msms" : "ms", false);
        } else {
            this.onSetMsLevel("msms", false);
        }
    }

    @Override
    public void updateView() {
        this.resetSelection();
        this.updateMZAxis();
        this.updateChart();
        this.updateTitle();
    }

    private Peak findNearestPeak(double mz, double intensity, double mz_toll, double int_toll) {
        SortedMap<Double, Double> submap = this.visibleData.subMap(mz - mz_toll, mz + mz_toll);
        Peak found = null;
        double min_diff = 0.0;
        for (Map.Entry<Double, Double> e : submap.entrySet()) {
            double diff = Math.abs(e.getValue() - intensity);
            if (!(diff <= int_toll) || found != null && !(diff < min_diff)) continue;
            found = new Peak(e.getKey(), e.getValue());
        }
        return found;
    }

    public Peak findPeakAt(Point2D p) {
        if (((PeakList)((Object)this.theDocument)).size() > 0) {
            Point2D dp = this.screenToDataCoords(p);
            double mz_toll = this.screenToDataX(3.0);
            double int_toll = this.screenToDataY(3.0);
            return this.findNearestPeak(dp.getX(), dp.getY(), mz_toll, int_toll);
        }
        return null;
    }

    public boolean hasSelection() {
        return this.selected_peaks.size() > 0;
    }

    public boolean isSelected(Peak peak) {
        return peak == null ? false : this.selected_peaks.contains(peak);
    }

    public void resetSelection() {
        this.current_peak = null;
        this.selected_peaks.clear();
        this.fireUpdatedSelection();
    }

    public void setSelection(Peak peak) {
        if (peak != null) {
            this.selected_peaks.clear();
            this.selected_peaks.add(peak);
            this.current_peak = peak;
            this.fireUpdatedSelection();
        } else {
            this.resetSelection();
        }
    }

    public void addSelection(Peak peak) {
        if (peak != null) {
            if (!this.isSelected(peak)) {
                this.selected_peaks.add(peak);
            } else {
                this.current_peak = peak;
            }
            this.fireUpdatedSelection();
        }
    }

    public void enforceSelection(Peak peak) {
        if (peak != null) {
            if (!this.isSelected(peak)) {
                this.setSelection(peak);
            } else {
                this.current_peak = peak;
                this.fireUpdatedSelection();
            }
        } else {
            this.resetSelection();
        }
    }

    private void showSelection() {
        this.thePlot.clearAnnotations();
        if (this.selected_peaks.size() > 0) {
            double width = this.screenToDataX(6.0);
            double height = this.screenToDataY(6.0);
            double margin = this.screenToDataY(8.0);
            for (Peak p : this.selected_peaks) {
                Rectangle2D.Double shape = new Rectangle2D.Double(p.getMZ() - width / 2.0, p.getIntensity() - height / 2.0, width, height);
                if (p.equals(this.current_peak)) {
                    this.thePlot.addAnnotation((XYAnnotation)new XYShapeAnnotation((Shape)shape, (Stroke)new BasicStroke(2.0f), (Paint)Color.black));
                    this.thePlot.addAnnotation((XYAnnotation)new XYTextAnnotation(new DecimalFormat("0.0000").format(p.getMZ()), p.getMZ(), p.getIntensity() + margin));
                    continue;
                }
                this.thePlot.addAnnotation((XYAnnotation)new XYShapeAnnotation((Shape)shape, (Stroke)new BasicStroke(1.0f), (Paint)Color.black));
            }
        }
    }

    public void onPrint() {
        PrinterJob pj = this.theWorkspace.getPrinterJob();
        if (pj == null) {
            return;
        }
        try {
            pj.setPrintable((Printable)this.theChartPanel);
            if (pj.printDialog()) {
                pj.print();
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void onActivateZooming() {
        this.is_moving = false;
        this.theChartPanel.setCursor(Cursor.getDefaultCursor());
    }

    public void onActivateMoving() {
        this.is_moving = true;
        this.theChartPanel.setCursor(this.hand_cursor);
    }

    public void onZoomNone() {
        if (((PeakList)((Object)this.theDocument)).size() > 0) {
            this.thePlot.getDomainAxis().setRange(((PeakList)((Object)this.theDocument)).getMZRange());
        }
    }

    public void onZoomIn() {
        if (((PeakList)((Object)this.theDocument)).size() > 0) {
            this.thePlot.getDomainAxis().resizeRange(0.5);
        }
    }

    public void onZoomOut() {
        if (((PeakList)((Object)this.theDocument)).size() > 0) {
            this.thePlot.getDomainAxis().resizeRange(2.0);
            if (this.thePlot.getDomainAxis().getRange().contains(((PeakList)((Object)this.theDocument)).getMinMZ()) || this.thePlot.getDomainAxis().getRange().contains(((PeakList)((Object)this.theDocument)).getMaxMZ())) {
                this.thePlot.getDomainAxis().setRange(((PeakList)((Object)this.theDocument)).getMZRange());
            }
        }
    }

    public void onSetMsLevel(String mslevel, boolean changedoc) {
        this.shown_mslevel = mslevel;
        if (mslevel.equals("ms")) {
            this.mslevel_button.setAction((Action)this.theActionManager.get("mslevel=msms"));
            this.mslevel_button.setText(null);
            if (changedoc) {
                this.theWorkspace.setMsMs(this.theWorkspace.getCurrentScan(), false);
            }
        } else {
            this.mslevel_button.setAction((Action)this.theActionManager.get("mslevel=ms"));
            this.mslevel_button.setText(null);
            if (changedoc) {
                this.theWorkspace.setMsMs(this.theWorkspace.getCurrentScan(), true);
            }
        }
        this.updateTitle();
    }

    public void onSetUpdateIsotopeCurves(Boolean f) {
        this.automatic_update_isotope_curves = f;
        if (this.automatic_update_isotope_curves) {
            this.isotopes_button.setAction((Action)this.theActionManager.get("updateisotopecurves=false"));
        } else {
            this.isotopes_button.setAction((Action)this.theActionManager.get("updateisotopecurves=true"));
        }
        this.isotopes_button.setText(null);
    }

    public void onSetShowAllIsotopes(Boolean f) {
        this.show_all_isotopes = f;
        if (this.show_all_isotopes) {
            this.ftmode_button.setAction((Action)this.theActionManager.get("showallisotopes=false"));
        } else {
            this.ftmode_button.setAction((Action)this.theActionManager.get("showallisotopes=true"));
        }
        this.ftmode_button.setText(null);
    }

    public boolean onAnnotatePeaks(String parent_action) {
        try {
            if (this.selected_peaks.size() > 0) {
                this.updatePeakActions();
                if (this.shown_mslevel.equals("ms")) {
                    if (parent_action != null) {
                        this.ms_action = this.theApplication.getPluginManager().getMsPeakAction(parent_action);
                    }
                    if (this.theApplication.getPluginManager().runAction(this.ms_action, (Object)new PeakList(this.selected_peaks))) {
                        this.update_isotope_curves = this.automatic_update_isotope_curves;
                        return true;
                    }
                    return false;
                }
                if (parent_action != null) {
                    this.msms_action = this.theApplication.getPluginManager().getMsMsPeakAction(parent_action);
                }
                if (this.theApplication.getPluginManager().runAction(this.msms_action, (Object)new PeakList(this.selected_peaks))) {
                    this.update_isotope_curves = this.automatic_update_isotope_curves;
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return false;
        }
    }

    private void removeIsotopeCurves() {
        while (this.theIsotopesDataset.getSeriesCount() > 0) {
            this.theIsotopesDataset.removeSeries(this.theIsotopesDataset.getSeriesKey(0));
        }
    }

    private void updateIsotopeCurves() {
        this.update_isotope_curves = false;
        TreeMap<Peak, Collection<Annotation>> map = new TreeMap<Peak, Collection<Annotation>>();
        for (PeakAnnotationMultiple pam : this.theSearchResults.getAnnotations()) {
            if (map.get(pam.getPeak()) == null) {
                map.put(pam.getPeak(), new Vector());
            }
            Collection<Annotation> dest = map.get(pam.getPeak());
            for (Vector<Annotation> va : pam.getAnnotations()) {
                dest.addAll(va);
            }
        }
        this.addIsotopeCurves(map);
    }

    public void addIsotopeCurves(TreeMap<Peak, Collection<Annotation>> annotations) {
        if (((PeakList)((Object)this.theDocument)).size() == 0) {
            return;
        }
        this.removeIsotopeCurves();
        if (annotations != null) {
            if (this.show_all_isotopes) {
                this.thePlot.setRenderer(1, (XYItemRenderer)new StandardXYItemRenderer(1));
                this.thePlot.getRenderer(1).setShape((Shape)new Ellipse2D.Double(0.0, 0.0, 7.0, 7.0));
            } else {
                this.thePlot.setRenderer(1, (XYItemRenderer)new StandardXYItemRenderer(2));
            }
            MSUtils.IsotopeList isotope_list = new MSUtils.IsotopeList(this.show_all_isotopes);
            for (Map.Entry<Peak, Collection<Annotation>> pa : annotations.entrySet()) {
                Peak p = pa.getKey();
                HashSet<Molecule> compositions = new HashSet<Molecule>();
                for (Annotation a : pa.getValue()) {
                    try {
                        compositions.add(a.getFragmentEntry().fragment.computeIon());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                HashMap<String, double[][]> all_curves = new HashMap<String, double[][]>();
                for (Molecule molecule : compositions) {
                    try {
                        double[][] data = MSUtils.getIsotopesCurve(1, molecule, this.show_all_isotopes);
                        isotope_list.adjust(data, p.getMZ(), p.getIntensity());
                        all_curves.put(molecule.toString(), data);
                    }
                    catch (Exception e) {
                        LogUtils.report((Exception)e);
                    }
                }
                if (all_curves.size() > 1) {
                    double[][] data = MSUtils.average(all_curves.values(), this.show_all_isotopes);
                    String string = "average-" + p.getMZ();
                    this.theIsotopesDataset.addSeries((Comparable)((Object)string), data);
                    this.thePlot.getRenderer(1).setSeriesPaint(this.theIsotopesDataset.indexOf((Comparable)((Object)string)), (Paint)Color.magenta);
                    this.thePlot.getRenderer(1).setSeriesStroke(this.theIsotopesDataset.indexOf((Comparable)((Object)string)), (Stroke)new BasicStroke(2.0f));
                    isotope_list.add(data, false);
                } else if (all_curves.size() == 1) {
                    isotope_list.add((double[][])all_curves.values().iterator().next(), false);
                }
                for (Map.Entry entry : all_curves.entrySet()) {
                    String name = (String)entry.getKey() + "-" + p.getMZ();
                    this.theIsotopesDataset.addSeries((Comparable)((Object)name), (double[][])entry.getValue());
                    this.thePlot.getRenderer(1).setSeriesPaint(this.theIsotopesDataset.indexOf((Comparable)((Object)name)), (Paint)Color.blue);
                }
            }
        }
        this.updateIntensityAxis();
    }

    public void addSelectionChangeListener(SelectionChangeListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeSelectionChangeListener(SelectionChangeListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public void fireUpdatedSelection() {
        for (SelectionChangeListener l : this.listeners) {
            l.selectionChanged(new SelectionChangeEvent(this));
        }
        this.removeIsotopeCurves();
        this.updateIntensityAxis();
        this.showSelection();
        this.updateActions();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = GlycanAction.getAction((ActionEvent)e);
        String param = GlycanAction.getParam((ActionEvent)e);
        if (action.equals("new")) {
            this.theApplication.onNew((BaseDocument)this.theDocument);
        } else if (action.equals("open")) {
            this.theApplication.onOpen(null, (BaseDocument)this.theDocument, false);
        } else if (action.equals("print")) {
            this.onPrint();
        } else if (action.equals("arrow")) {
            this.onActivateZooming();
        } else if (action.equals("hand")) {
            this.onActivateMoving();
        } else if (action.equals("zoomnone")) {
            this.onZoomNone();
        } else if (action.equals("zoomin")) {
            this.onZoomIn();
        } else if (action.equals("zoomout")) {
            this.onZoomOut();
        } else if (action.equals("mslevel")) {
            this.onSetMsLevel(param, true);
        } else if (action.equals("annotatepeaks")) {
            this.onAnnotatePeaks(param);
        } else if (action.equals("updateisotopecurves")) {
            this.onSetUpdateIsotopeCurves(Boolean.valueOf(param));
        } else if (action.equals("showallisotopes")) {
            this.onSetShowAllIsotopes(Boolean.valueOf(param));
        }
        this.updateActions();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (MouseUtils.isPopupTrigger((MouseEvent)e)) {
            this.current_peak = this.findPeakAt(e.getPoint());
            this.enforceSelection(this.current_peak);
            this.createPopupMenu(this.current_peak != null).show((Component)this.theChartPanel, e.getX(), e.getY());
        } else {
            this.was_moving = this.is_moving;
            if ((MouseUtils.isPushTrigger((MouseEvent)e) || MouseUtils.isMoveTrigger((MouseEvent)e)) && this.theChartPanel.getScreenDataArea().contains(e.getPoint())) {
                this.mouse_start_point = e.getPoint();
                if (MouseUtils.isMoveTrigger((MouseEvent)e)) {
                    this.onActivateMoving();
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mouse_start_point != null && ((PeakList)((Object)this.theDocument)).size() > 0) {
            if (this.is_moving) {
                double mz_delta = this.screenToDataX(this.mouse_start_point.getX() - e.getPoint().getX());
                if (mz_delta > 0.0) {
                    double old_upper_bound = this.thePlot.getDomainAxis().getUpperBound();
                    double old_lower_bound = this.thePlot.getDomainAxis().getLowerBound();
                    double new_upper_bound = Math.min(old_upper_bound + mz_delta, ((PeakList)((Object)this.theDocument)).getMaxMZ());
                    double new_lower_bound = old_lower_bound + new_upper_bound - old_upper_bound;
                    this.thePlot.getDomainAxis().setRange(new Range(new_lower_bound, new_upper_bound));
                } else {
                    double old_upper_bound = this.thePlot.getDomainAxis().getUpperBound();
                    double old_lower_bound = this.thePlot.getDomainAxis().getLowerBound();
                    double new_lower_bound = Math.max(old_lower_bound + mz_delta, ((PeakList)((Object)this.theDocument)).getMinMZ());
                    double new_upper_bound = old_upper_bound + new_lower_bound - old_lower_bound;
                    this.thePlot.getDomainAxis().setRange(new Range(new_lower_bound, new_upper_bound));
                }
                this.mouse_start_point = e.getPoint();
            } else {
                Graphics2D g2 = (Graphics2D)this.theChartPanel.getGraphics();
                g2.setXORMode(Color.gray);
                if (this.zoom_rectangle != null) {
                    g2.draw(this.zoom_rectangle);
                }
                double start_x = Math.min((double)e.getX(), this.mouse_start_point.getX());
                double end_x = Math.max((double)e.getX(), this.mouse_start_point.getX());
                Rectangle2D data_area = this.theChartPanel.getScreenDataArea((int)start_x, (int)this.mouse_start_point.getY());
                double xmax = Math.min(end_x, data_area.getMaxX());
                this.zoom_rectangle = new Rectangle2D.Double(start_x, data_area.getMinY(), xmax - start_x, data_area.getHeight());
                g2.draw(this.zoom_rectangle);
                g2.dispose();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (MouseUtils.isPopupTrigger((MouseEvent)e)) {
            if (this.zoom_rectangle != null) {
                Graphics2D g2 = (Graphics2D)this.getGraphics();
                g2.setXORMode(Color.gray);
                g2.draw(this.zoom_rectangle);
                g2.dispose();
            }
            this.mouse_start_point = null;
            this.zoom_rectangle = null;
            this.current_peak = this.findPeakAt(e.getPoint());
            this.enforceSelection(this.current_peak);
            this.createPopupMenu(this.current_peak != null).show((Component)this.theChartPanel, e.getX(), e.getY());
        } else {
            if (this.zoom_rectangle != null && this.mouse_start_point != null) {
                if (Math.abs((double)e.getX() - this.mouse_start_point.getX()) > 10.0) {
                    double start_x = Math.min((double)e.getX(), this.mouse_start_point.getX());
                    double end_x = Math.max((double)e.getX(), this.mouse_start_point.getX());
                    Rectangle2D data_area = this.theChartPanel.getScreenDataArea((int)start_x, (int)this.mouse_start_point.getY());
                    double new_lower_bound = this.screenToDataCoordX(start_x);
                    double new_upper_bound = this.screenToDataCoordX(Math.min(end_x, data_area.getMaxX()));
                    this.thePlot.getDomainAxis().setRange(new Range(new_lower_bound, new_upper_bound));
                } else {
                    Graphics2D g2 = (Graphics2D)this.getGraphics();
                    g2.setXORMode(Color.gray);
                    g2.draw(this.zoom_rectangle);
                    g2.dispose();
                }
            }
            if (!this.was_moving && this.is_moving) {
                this.onActivateZooming();
            }
            this.zoom_rectangle = null;
            this.mouse_start_point = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.current_peak = this.findPeakAt(e.getPoint());
        if (MouseUtils.isSelectTrigger((MouseEvent)e)) {
            this.setSelection(this.current_peak);
        } else if (MouseUtils.isAddSelectTrigger((MouseEvent)e)) {
            this.addSelection(this.current_peak);
        } else if (MouseUtils.isActionTrigger((MouseEvent)e)) {
            this.setSelection(this.current_peak);
            this.onAnnotatePeaks(null);
        }
    }

    @Override
    public void documentChanged(BaseDocument.DocumentChangeEvent e) {
        if (e.getSource() == this.theWorkspace.getSearchResults()) {
            if (this.update_isotope_curves) {
                this.updateIsotopeCurves();
            }
        } else {
            this.removeIsotopeCurves();
            super.documentChanged(e);
        }
    }

    @Override
    public void internalDocumentChanged(GlycanWorkspace.Event e) {
        this.updateMsLevel();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (!this.checkForUpdates()) {
            this.updateChart();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (!this.checkForUpdates()) {
            this.updateChart();
        }
    }

    public static class SelectionChangeEvent {
        private PeakListChartPanel src;

        public SelectionChangeEvent(PeakListChartPanel _src) {
            this.src = _src;
        }

        public PeakListChartPanel getSource() {
            return this.src;
        }
    }

    public static interface SelectionChangeListener {
        public void selectionChanged(SelectionChangeEvent var1);
    }
}

