/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.dialog;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.dialog.ModalDialog;
import org.grits.toolbox.core.datamodel.dialog.ProjectExplorerDialog;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentDesignOntologyAPI;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentTemplateEntry;

public class SelectExperimentDialog
extends ModalDialog {
    private static final Logger logger = Logger.getLogger(SelectExperimentDialog.class);
    private Button fromTemplateRadio;
    private ComboViewer selectedTemplateCombo;
    private ExperimentTemplateEntry templateFile;
    private Entry experimentSelected;
    private Button copyFromButton;
    protected Button OKbutton;
    private Text existingDesignText;

    public SelectExperimentDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Select Experiment Design");
        this.setMessage("Select an existing experiment design");
    }

    protected Control createDialogArea(final Composite parent) {
        this.parent = parent;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 10;
        parent.setLayout((Layout)gridLayout);
        Label label1 = new Label(parent, 0);
        label1.setText("Select Experiment Design: ");
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        label1.setLayoutData((Object)gd);
        this.fromTemplateRadio = new Button(parent, 16);
        this.fromTemplateRadio.setSelection(false);
        this.fromTemplateRadio.setText("From Template");
        this.fromTemplateRadio.setEnabled(false);
        this.fromTemplateRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object s;
                ISelection selection;
                if (SelectExperimentDialog.this.selectedTemplateCombo != null && (selection = SelectExperimentDialog.this.selectedTemplateCombo.getSelection()) instanceof IStructuredSelection && (s = ((IStructuredSelection)selection).getFirstElement()) instanceof ExperimentTemplateEntry) {
                    SelectExperimentDialog.this.setTemplateFile((ExperimentTemplateEntry)s);
                    SelectExperimentDialog.this.experimentSelected = null;
                }
            }
        });
        this.selectedTemplateCombo = new ComboViewer(parent, 8);
        this.selectedTemplateCombo.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return null;
            }
        });
        this.selectedTemplateCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ExperimentTemplateEntry)element).getName();
            }
        });
        this.selectedTemplateCombo.getCombo().setLayoutData((Object)new GridData(4, 4, true, true));
        try {
            List<ExperimentTemplateEntry> templates = new ExperimentDesignOntologyAPI().getAllExperimentTemplateEntries();
            if (templates == null || templates.isEmpty()) {
                this.selectedTemplateCombo.getCombo().setEnabled(false);
                this.fromTemplateRadio.setEnabled(false);
            } else {
                this.selectedTemplateCombo.setInput(templates);
                this.selectedTemplateCombo.getCombo().setEnabled(true);
                this.selectedTemplateCombo.getCombo().select(0);
                this.fromTemplateRadio.setEnabled(true);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("org.grits.toolbox.editor.experimentdesigner Cannot load the existing templates! " + e));
            MessageDialog.openInformation((Shell)parent.getShell(), (String)"Warning", (String)("Cannot retrieve experiment design templates: " + e.getMessage()));
            this.selectedTemplateCombo.getCombo().setEnabled(false);
        }
        this.selectedTemplateCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object s;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (s = ((IStructuredSelection)selection).getFirstElement()) instanceof ExperimentTemplateEntry) {
                    SelectExperimentDialog.this.setTemplateFile((ExperimentTemplateEntry)s);
                    if (SelectExperimentDialog.this.fromTemplateRadio.getSelection()) {
                        SelectExperimentDialog.this.experimentSelected = null;
                    }
                }
            }
        });
        Label designLabel = new Label(parent, 4);
        designLabel.setText("");
        gd = new GridData();
        gd.horizontalSpan = 1;
        designLabel.setLayoutData((Object)gd);
        this.copyFromButton = new Button(parent, 16);
        this.copyFromButton.setSelection(false);
        this.copyFromButton.setText("Copy existing design");
        this.copyFromButton.setToolTipText("Copy from an existing experiment design");
        this.copyFromButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.getSource();
                if (!button.getSelection()) {
                    return;
                }
                SelectExperimentDialog.this.OKbutton.setEnabled(false);
                Shell newShell = new Shell(parent.getShell(), 0x10008000);
                ProjectExplorerDialog dlg = new ProjectExplorerDialog(newShell){
                    Entry selectedEntry;
                    {
                        this.selectedEntry = null;
                    }

                    protected void okPressed() {
                        SelectExperimentDialog.this.experimentSelected = this.selectedEntry;
                        super.okPressed();
                    }

                    public Control createDialogArea(Composite parent) {
                        super.createDialogArea(parent);
                        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                            public void selectionChanged(SelectionChangedEvent event) {
                                ISelection selection = event.getSelection();
                                if (selection.isEmpty()) {
                                    return;
                                }
                                TreeSelection to = (TreeSelection)selection;
                                if (to.size() == 1) {
                                    Entry node = (Entry)to.getFirstElement();
                                    boolean match = false;
                                    if (node.getProperty().getType().equals("org.grits.toolbox.property.sample")) {
                                        List children = node.getChildren();
                                        for (Entry entry : children) {
                                            if (!entry.getProperty().getType().equals("org.grits.toolbox.property.experiment")) continue;
                                            match = true;
                                            selectedEntry = entry;
                                            break;
                                        }
                                    }
                                    if (match) {
                                        this.setEnabledOKbutton(true);
                                    } else {
                                        this.setEnabledOKbutton(false);
                                    }
                                } else {
                                    this.setEnabledOKbutton(false);
                                }
                            }
                        });
                        return parent;
                    }

                    public void setEnabledOKbutton(boolean enabled) {
                        this.getButton(0).setEnabled(enabled);
                    }
                };
                dlg.setTitle("Experiment Design Selection");
                dlg.setMessage("Choose an experiment design");
                dlg.open();
                if (SelectExperimentDialog.this.experimentSelected != null) {
                    SelectExperimentDialog.this.setReturnCode(2);
                    SelectExperimentDialog.this.existingDesignText.setText(SelectExperimentDialog.this.experimentSelected.getDisplayName());
                    SelectExperimentDialog.this.OKbutton.setEnabled(true);
                }
            }
        });
        this.existingDesignText = new Text(parent, 132);
        this.existingDesignText.setEditable(false);
        this.existingDesignText.setText("");
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.widthHint = 100;
        this.existingDesignText.setLayoutData((Object)gd);
        Label designLabel2 = new Label(parent, 4);
        designLabel2.setText("");
        gd = new GridData();
        gd.horizontalSpan = 1;
        designLabel2.setLayoutData((Object)gd);
        new Label(parent, 0);
        this.createCANCELButton(parent);
        this.createOKButton(parent);
        return parent;
    }

    protected Button createCANCELButton(Composite parent2) {
        GridData cancelData = new GridData();
        cancelData.horizontalAlignment = 0x1000008;
        cancelData.grabExcessHorizontalSpace = true;
        Button CancelButton = new Button(parent2, 8);
        CancelButton.setText("Cancel");
        CancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectExperimentDialog.this.setReturnCode(1);
                SelectExperimentDialog.this.close();
            }
        });
        CancelButton.setLayoutData((Object)cancelData);
        return CancelButton;
    }

    protected Button createOKButton(Composite parent2) {
        GridData okData = new GridData();
        okData.horizontalAlignment = 0x1000008;
        this.OKbutton = new Button(parent2, 8);
        this.OKbutton.setText("   OK   ");
        this.OKbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (SelectExperimentDialog.this.isValidInput()) {
                    SelectExperimentDialog.this.okPressed();
                    SelectExperimentDialog.this.close();
                }
            }
        });
        this.OKbutton.setLayoutData((Object)okData);
        return this.OKbutton;
    }

    protected boolean isValidInput() {
        return true;
    }

    protected Entry createEntry() {
        return null;
    }

    public ExperimentTemplateEntry getTemplateFile() {
        return this.templateFile;
    }

    public void setTemplateFile(ExperimentTemplateEntry templateFile) {
        this.templateFile = templateFile;
    }

    public Entry getExperimentSelected() {
        return this.experimentSelected;
    }

    public void setExperimentSelected(Entry experimentSelected) {
        this.experimentSelected = experimentSelected;
    }
}

