/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.actions;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditor;
import org.grits.toolbox.editor.experimentdesigner.model.EntityWithPosition;
import org.grits.toolbox.editor.experimentdesigner.model.Parameter;
import org.grits.toolbox.editor.experimentdesigner.model.ParameterGroup;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentDesignOntologyAPI;
import org.grits.toolbox.editor.experimentdesigner.views.ParameterView;

public class AddParameterGroupAction {
    private static Logger logger = Logger.getLogger(AddParameterGroupAction.class);
    ParameterGroup group;
    boolean isRequired = false;
    @Inject
    IEventBroker eventBroker;
    GraphEditor editor;

    @Execute
    public void run(@Named(value="activeShell") @Named(value="activeShell") Shell shell, MApplication application, MPart protocolPart) {
        if (protocolPart != null && protocolPart.getObject() != null) {
            ProtocolNode protocol = ((ParameterView)protocolPart.getObject()).getProtocol();
            if (protocol == null) {
                return;
            }
            this.editor = (GraphEditor)((Object)application.getContext().get(GraphEditor.class));
            if (this.editor == null) {
                logger.error((Object)"Cannot get the reference to Graph Editor");
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Update Error", (String)"Cannot get the reference to Graph Editor");
                return;
            }
            TreeViewer treeViewer = ((ParameterView)protocolPart.getObject()).getTreeViewer();
            try {
                ExperimentDesignOntologyAPI ontologyAPI = new ExperimentDesignOntologyAPI();
                List<ParameterGroup> groups = ontologyAPI.getParameterGroups();
                ListDialog dialog = new ListDialog(shell){

                    protected Control createDialogArea(Composite container) {
                        Composite parent = (Composite)super.createDialogArea(container);
                        Composite newContainer = new Composite(parent, 0);
                        newContainer.setLayout((Layout)new GridLayout(2, false));
                        GridData gd = new GridData(4, 0, false, false);
                        Label label = new Label(newContainer, 0);
                        label.setText("Required?");
                        label.setLayoutData((Object)gd);
                        final Button required = new Button(newContainer, 32);
                        gd = new GridData(4, 0, true, false);
                        required.setText("");
                        required.setSelection(false);
                        required.setLayoutData((Object)gd);
                        required.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent e) {
                                (this).AddParameterGroupAction.this.isRequired = required.getSelection();
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }
                        });
                        return parent;
                    }
                };
                dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                dialog.setTitle("Parameter Group Selection");
                dialog.setLabelProvider((ILabelProvider)new ArrayLabelProvider());
                dialog.setInput(groups);
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    int i = 0;
                    while (i < result.length) {
                        this.group = (ParameterGroup)result[i];
                        ArrayList<EntityWithPosition> paramsAndParamGroups = new ArrayList<EntityWithPosition>();
                        List<ParameterGroup> existingGroups = protocol.getParameterGroups();
                        if (existingGroups != null) {
                            int nextGroupId = 0;
                            for (ParameterGroup parameterGroup : existingGroups) {
                                nextGroupId = Math.max(nextGroupId, parameterGroup.getId());
                            }
                            ++nextGroupId;
                            ParameterGroup newCopy = new ParameterGroup();
                            newCopy.setLabel(this.group.getLabel());
                            newCopy.setUri(this.group.getUri());
                            newCopy.setDescription(this.group.getDescription());
                            newCopy.setRequired(this.isRequired);
                            newCopy.setId(nextGroupId);
                            newCopy.setPosition(this.findPosition(protocol));
                            List<Parameter> parameters = this.group.getParameters();
                            if (parameters != null) {
                                ArrayList<Parameter> clonedList = new ArrayList<Parameter>(parameters.size());
                                for (Parameter p : parameters) {
                                    clonedList.add(new Parameter(p, newCopy.getId()));
                                }
                                newCopy.setParameters(clonedList);
                            }
                            existingGroups.add(newCopy);
                            paramsAndParamGroups.addAll(existingGroups);
                        } else {
                            ArrayList<ParameterGroup> newGroups = new ArrayList<ParameterGroup>();
                            this.group.setId(1);
                            this.group.setRequired(this.isRequired);
                            this.group.setPosition(this.findPosition(protocol));
                            newGroups.add(this.group);
                            protocol.setParameterGroups(newGroups);
                            paramsAndParamGroups.addAll(newGroups);
                        }
                        if (protocol.getParameters() != null) {
                            paramsAndParamGroups.addAll(protocol.getParameters());
                        }
                        treeViewer.setInput(paramsAndParamGroups);
                        treeViewer.refresh();
                        treeViewer.expandAll();
                        protocol.setTemplateChanged(true);
                        this.eventBroker.post("EventTopic_EventPart_Modified", (Object)protocol);
                        this.editor.refreshProtocolNode(protocol);
                        ++i;
                    }
                }
                this.isRequired = false;
            }
            catch (Exception e) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Error Reading Ontology", (Throwable)e);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error Reading Ontology");
            }
        }
    }

    private int findPosition(ProtocolNode protocol) {
        int maxPosition = 0;
        ArrayList<EntityWithPosition> allEntries = new ArrayList<EntityWithPosition>();
        allEntries.addAll(protocol.getParameterGroups());
        allEntries.addAll(protocol.getParameters());
        for (EntityWithPosition entityWithPosition : allEntries) {
            if (entityWithPosition.getPosition() == null || entityWithPosition.getPosition() <= maxPosition) continue;
            maxPosition = entityWithPosition.getPosition();
        }
        return maxPosition + 1;
    }

    static class ArrayLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ArrayLabelProvider() {
        }

        public String getText(Object element) {
            return ((ParameterGroup)element).getLabel();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((ParameterGroup)element).getLabel();
        }

        public void dispose() {
            super.dispose();
        }
    }
}

