/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.entry.ms.dialog.MSConvertDialog;
import org.grits.toolbox.entry.ms.preference.MSConvertPreference;

public class MSConvertHandler {
    private static final Logger logger = Logger.getLogger(MSConvertHandler.class);
    public static final String PARAMETER = "instrumentfile_Path";
    public static final String PARAMETER2 = "msPath";
    public static final String COMMAND_ID = "org.grits.toolbox.entry.ms.command.msconvert";
    String convertedFile = null;
    String scanNumberFilter = null;
    String scanTimeFilter = null;
    String scanNumberExt = "";
    String scanTimeExt = "";

    @Execute
    public String execute(@Named(value="activeShell") @Named(value="activeShell") Shell shell, final @Named(value="instrumentfile_Path") @Named(value="instrumentfile_Path") String file, final @Named(value="msPath") @Named(value="msPath") String msPath) {
        MSConvertPreference preferences;
        block16: {
            block15: {
                preferences = MSConvertPreference.loadPreferences();
                if (preferences != null && preferences.getLocation() != null && preferences.getFileType() != null) break block15;
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Please set the preferences for MSConvert first!");
                return null;
            }
            this.scanNumberFilter = null;
            this.scanTimeFilter = null;
            this.scanNumberExt = "";
            this.scanTimeExt = "";
            MSConvertDialog argumentDialog = new MSConvertDialog(shell);
            if (argumentDialog.open() == 0) {
                Integer scanNumberB = argumentDialog.getScanNumberBegin();
                Integer scanNumberE = argumentDialog.getScanNumberEnd();
                if (scanNumberB != null && scanNumberE != null) {
                    this.scanNumberFilter = "scanNumber " + scanNumberB + "-" + scanNumberE + " ";
                    this.scanNumberExt = "_" + scanNumberB + "_" + scanNumberE;
                }
                Double scanTimeB = argumentDialog.getScanTimeBegin();
                Double scanTimeE = argumentDialog.getScanTimeEnd();
                if (scanTimeB != null && scanTimeE != null) {
                    this.scanTimeFilter = "scanTime [" + scanTimeB + "-" + scanTimeE + "] ";
                    this.scanTimeExt = "_" + scanTimeB + "_" + scanTimeE;
                }
                break block16;
            }
            return null;
        }
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask("Converting " + file + "...", -1);
                        Runtime r = Runtime.getRuntime();
                        String fullPath = String.valueOf(msPath) + File.separator + file;
                        String outputDir = String.valueOf(msPath) + File.separator + file.substring(0, file.lastIndexOf(File.separator));
                        String tppline = "\"titleMaker <RunId>.<ScanNumber>.<ScanNumber>.<ChargeState> File:\"<SourcePath>\", NativeID:\"<Id>\"\"";
                        String[] cmd = null;
                        cmd = MSConvertHandler.this.scanTimeFilter != null && MSConvertHandler.this.scanNumberFilter != null ? new String[]{String.valueOf(preferences.getLocation()) + File.separator + "msconvert", fullPath, "--32", "--zlib", "--ignoreUnknownInstrumentError", "--" + preferences.getFileType(), "-o", outputDir, "--filter", tppline, "--filter", MSConvertHandler.this.scanTimeFilter, "--filter", MSConvertHandler.this.scanNumberFilter} : (MSConvertHandler.this.scanTimeFilter != null ? new String[]{String.valueOf(preferences.getLocation()) + File.separator + "msconvert", fullPath, "--32", "--zlib", "--ignoreUnknownInstrumentError", "--" + preferences.getFileType(), "-o", outputDir, "--filter", tppline, "--filter", MSConvertHandler.this.scanTimeFilter} : (MSConvertHandler.this.scanNumberFilter != null ? new String[]{String.valueOf(preferences.getLocation()) + File.separator + "msconvert", fullPath, "--32", "--zlib", "--ignoreUnknownInstrumentError", "--" + preferences.getFileType(), "-o", outputDir, "--filter", tppline, "--filter", MSConvertHandler.this.scanNumberFilter} : new String[]{String.valueOf(preferences.getLocation()) + File.separator + "msconvert", fullPath, "--32", "--zlib", "--ignoreUnknownInstrumentError", "--" + preferences.getFileType(), "-o", outputDir, "--filter", tppline}));
                        logger.info((Object)"Executing command: ");
                        int i = 0;
                        while (i < cmd.length) {
                            logger.info((Object)(" " + cmd[i]));
                            ++i;
                        }
                        Process p = r.exec(cmd);
                        BufferedReader bfr = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        String line = "";
                        StringBuffer errorString = new StringBuffer();
                        while (bfr.ready()) {
                            line = bfr.readLine();
                            logger.info((Object)line);
                            errorString.append(String.valueOf(line) + "\n");
                        }
                        bfr.close();
                        BufferedReader errorReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        while (errorReader.ready()) {
                            line = errorReader.readLine();
                            logger.debug((Object)line);
                            errorString.append(String.valueOf(line) + "\n");
                        }
                        errorReader.close();
                        int exitValue = p.waitFor();
                        if (exitValue != 0) {
                            logger.error((Object)("MSConvert failed! Reason: " + errorString));
                            throw new InvocationTargetException(new Throwable(errorString.toString()));
                        }
                        if (file.lastIndexOf(".") != -1) {
                            MSConvertHandler.this.convertedFile = file.substring(0, file.lastIndexOf("."));
                            MSConvertHandler.this.convertedFile = String.valueOf(MSConvertHandler.this.convertedFile) + "." + preferences.getFileType();
                        }
                        if (!MSConvertHandler.this.scanTimeExt.isEmpty() || !MSConvertHandler.this.scanNumberExt.isEmpty()) {
                            File cFile = new File(String.valueOf(msPath) + File.separator + MSConvertHandler.this.convertedFile);
                            String newFileName = file.substring(0, file.lastIndexOf("."));
                            if (!MSConvertHandler.this.scanTimeExt.isEmpty()) {
                                newFileName = String.valueOf(newFileName) + MSConvertHandler.this.scanTimeExt;
                            }
                            if (!MSConvertHandler.this.scanNumberExt.isEmpty()) {
                                newFileName = String.valueOf(newFileName) + MSConvertHandler.this.scanNumberExt;
                            }
                            newFileName = String.valueOf(newFileName) + "." + preferences.getFileType();
                            cFile.renameTo(new File(String.valueOf(msPath) + File.separator + newFileName));
                            MSConvertHandler.this.convertedFile = newFileName;
                        }
                        monitor.done();
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
            progressMonitorDialog.run(true, false, runnable);
            return this.convertedFile;
        }
        catch (InvocationTargetException e) {
            String cause = "";
            if (e.getTargetException() instanceof InvocationTargetException) {
                if (((InvocationTargetException)e.getTargetException()).getTargetException() != null) {
                    cause = ((InvocationTargetException)e.getTargetException()).getTargetException().getMessage();
                }
            } else if (e.getTargetException() instanceof Throwable) {
                cause = e.getTargetException().getMessage();
            }
            if (cause != null && cause.equals("msconvert: not found")) {
                logger.error((Object)"No msconvert tool found.");
            } else {
                logger.error((Object)"Failed to execute MSConvert", (Throwable)e);
            }
            MessageDialog.openError((Shell)shell, (String)"Error", (String)("Failed to execute MSConvert. Reason: " + cause));
        }
        catch (InterruptedException e) {
            logger.info((Object)"MSConvert is interrupted", (Throwable)e);
        }
        catch (UnsupportedVersionException e) {
            logger.error((Object)"Preference version is not supported", (Throwable)e);
        }
        return null;
    }

    @CanExecute
    public boolean canExecute() {
        return System.getProperty("os.name").startsWith("Windows");
    }
}

