/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.projectexplorer.dialog;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.GeneralSettings;
import org.grits.toolbox.core.datamodel.SettingEntry;
import org.grits.toolbox.core.utils.SettingsHandler;

public class NewProjectInfoDialog
extends Dialog {
    private static final Logger logger = Logger.getLogger(NewProjectInfoDialog.class);
    private static final int WIDTH_HINT = 580;
    private String infoMessage = this.getInfoText();
    private Button doNotShow;
    private Boolean doNotShowValue = false;

    public NewProjectInfoDialog(Shell parentShell) {
        super(parentShell);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getInfoText() {
        String infoMessage = "No message to display. Something went wrong";
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                URL resourceURL = FileLocator.toFileURL((URL)Platform.getBundle((String)"org.grits.toolbox.core").getResource("preference"));
                String fileLocation = String.valueOf(resourceURL.getPath()) + File.separator + "display_text" + File.separator + "newProjectMessage.txt";
                bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(fileLocation)));
                byte[] contents = new byte[262144];
                int bytesRead = 0;
                while ((bytesRead = bufferedInputStream.read(contents)) != -1) {
                    infoMessage = new String(contents, 0, bytesRead, "UTF-8");
                }
                return infoMessage;
            }
            catch (FileNotFoundException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                if (bufferedInputStream == null) return infoMessage;
                try {
                    bufferedInputStream.close();
                    return infoMessage;
                }
                catch (IOException ex2) {
                    logger.fatal((Object)ex2.getMessage(), (Throwable)ex2);
                }
                return infoMessage;
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                if (bufferedInputStream == null) return infoMessage;
                try {
                    bufferedInputStream.close();
                    return infoMessage;
                }
                catch (IOException ex3) {
                    logger.fatal((Object)ex3.getMessage(), (Throwable)ex3);
                }
                return infoMessage;
            }
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException ex) {
                    logger.fatal((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("GRITS Toolbox");
    }

    protected Control createDialogArea(Composite parent) {
        Composite outerContainer = new Composite(parent, 4);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = 10;
        gridLayout.marginBottom = 10;
        gridLayout.marginRight = 10;
        gridLayout.marginLeft = 10;
        gridLayout.verticalSpacing = 10;
        outerContainer.setLayout((Layout)gridLayout);
        List<String> parsedText = this.getParsedInfoText();
        Iterator<String> parsedTextIterator = parsedText.iterator();
        Link link = new Link(outerContainer, 65);
        link.setText(parsedTextIterator.next());
        GridData gd = new GridData();
        gd.widthHint = 580;
        gd.horizontalAlignment = 1;
        link.setLayoutData((Object)gd);
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.openWebPage(e.text);
            }

            private void openWebPage(String webURL) {
                try {
                    Program.launch((String)webURL);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.fatal((Object)"Error opening browser");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.openWebPage(e.text);
            }
        });
        ScrolledComposite scrolledComposite = new ScrolledComposite(outerContainer, 2816);
        GridData layoutData = new GridData();
        layoutData.heightHint = 400;
        layoutData.widthHint = 600;
        scrolledComposite.setLayoutData((Object)layoutData);
        scrolledComposite.setBackground(parent.getDisplay().getSystemColor(25));
        scrolledComposite.setBackgroundMode(2);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite infoContainer = new Composite((Composite)scrolledComposite, 0);
        GridLayout infoContainerLayout = new GridLayout(1, false);
        infoContainerLayout.verticalSpacing = 20;
        infoContainer.setLayout((Layout)infoContainerLayout);
        this.generateInfoPart(infoContainer, parsedTextIterator);
        scrolledComposite.setContent((Control)infoContainer);
        scrolledComposite.setMinSize(infoContainer.computeSize(-1, -1));
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        this.addDoNotShowCheckbox(outerContainer);
        return outerContainer;
    }

    private void generateInfoPart(Composite infoContainer, Iterator<String> parsedTextIterator) {
        while (parsedTextIterator.hasNext()) {
            Composite paraContainer = new Composite(infoContainer, 0);
            GridLayout paraContainerLayout = new GridLayout(1, false);
            paraContainerLayout.verticalSpacing = 5;
            paraContainer.setLayout((Layout)paraContainerLayout);
            GridData paraGridData = new GridData();
            paraContainer.setLayoutData((Object)paraGridData);
            StyledText styledText = new StyledText(paraContainer, 0);
            styledText.setText(parsedTextIterator.next());
            StyleRange style1 = this.getUnderLinedStyleRange(styledText.getCharCount());
            styledText.setStyleRange(style1);
            GridData gd = new GridData(1808);
            gd.verticalSpan = 1;
            styledText.setLayoutData((Object)gd);
            if (!parsedTextIterator.hasNext()) continue;
            Label label = new Label(paraContainer, 64);
            label.setText(parsedTextIterator.next());
            gd = new GridData(1808);
            gd.verticalSpan = 1;
            gd.widthHint = 580;
            label.setLayoutData((Object)gd);
        }
    }

    private void addDoNotShowCheckbox(Composite infoContainer) {
        this.doNotShow = new Button(infoContainer, 32);
        this.doNotShow.setText("Do not show again");
        this.doNotShow.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewProjectInfoDialog.this.doNotShowValue = NewProjectInfoDialog.this.doNotShow.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private List<String> getParsedInfoText() {
        ArrayList<String> parsedTexts = new ArrayList<String>();
        parsedTexts.add(0, this.infoMessage.substring(this.infoMessage.indexOf("<TITLE>") + 7, this.infoMessage.indexOf("</TITLE>")).trim());
        String body = this.infoMessage.substring(this.infoMessage.indexOf("<BODY>") + 6, this.infoMessage.indexOf("</BODY>"));
        String para = "";
        String nextParsedText = null;
        while (body.contains("<p>")) {
            para = body.substring(body.indexOf("<p>") + 3, body.indexOf("</p>"));
            nextParsedText = "";
            if (para.contains("<h1>")) {
                nextParsedText = para.substring(para.indexOf("<h1>") + 4, para.indexOf("</h1>"));
                parsedTexts.add(nextParsedText.trim());
                parsedTexts.add(para.substring(para.indexOf("</h1>") + 5).trim());
            } else {
                parsedTexts.add(para.trim());
            }
            body = body.substring(body.indexOf("</p>") + 4);
        }
        return parsedTexts;
    }

    private StyleRange getUnderLinedStyleRange(int characterCount) {
        StyleRange style = new StyleRange();
        style.start = 0;
        style.length = characterCount;
        style.underline = true;
        return style;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button okButton = super.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        okButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneralSettings settings = null;
                try {
                    settings = SettingsHandler.readSettings();
                }
                catch (Exception exception) {
                    logger.warn((Object)"Settings file does not exist yet");
                }
                if (settings == null) {
                    settings = new GeneralSettings();
                }
                SettingEntry se = new SettingEntry();
                se.setId("GRITS Workflow Dialog");
                se.setName("GRITS Workflow Dialog");
                se.setDescription("The dialog which gives information about the next steps after creating a project in GRITS");
                if (NewProjectInfoDialog.this.doNotShowValue.booleanValue()) {
                    settings.addHiddenDialog(se);
                } else {
                    settings.removeHiddenDialog(se);
                }
                try {
                    SettingsHandler.writeSettings(settings);
                }
                catch (Exception ex) {
                    logger.error((Object)"Cannot write settings file", (Throwable)ex);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }
}

