/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.share;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.property.project.ProjectCollaborator;
import org.grits.toolbox.core.datamodel.property.project.ProjectEvent;
import org.grits.toolbox.core.datamodel.property.project.ProjectTasklist;
import org.grits.toolbox.core.preference.project.ActionPreference;
import org.grits.toolbox.core.preference.project.CollaboratorPreference;
import org.grits.toolbox.core.preference.project.CollaboratorTableColumn;
import org.grits.toolbox.core.preference.project.CollaboratorTablePreference;
import org.grits.toolbox.core.preference.project.CountryPreference;
import org.grits.toolbox.core.preference.project.EventPreference;
import org.grits.toolbox.core.preference.project.FundingPreference;
import org.grits.toolbox.core.preference.project.KeywordPreference;
import org.grits.toolbox.core.preference.project.PersonPreference;
import org.grits.toolbox.core.preference.project.PositionPreference;
import org.grits.toolbox.core.preference.project.RolePreference;
import org.grits.toolbox.core.preference.project.StatusPreference;
import org.grits.toolbox.core.preference.project.TasklistPreference;
import org.grits.toolbox.core.preference.project.TasklistTableColumn;
import org.grits.toolbox.core.preference.project.TasklistTablePreference;
import org.grits.toolbox.core.preference.share.IGritsPreferenceStore;
import org.grits.toolbox.core.preference.share.MultiChoiceInteger;
import org.grits.toolbox.core.preference.share.MultiChoicePreference;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.SingleChoicePreference;

public class ProjectPreferenceStore {
    private static final Logger logger = Logger.getLogger(ProjectPreferenceStore.class);
    @Inject
    private static IGritsPreferenceStore gritsPreferenceStore;
    private static Map<String, SingleChoicePreference> singleSelectionTypeMap;
    private static Map<String, MultiChoicePreference<?>> multiSelectionTypeMap;

    static {
        singleSelectionTypeMap = new HashMap<String, SingleChoicePreference>();
        multiSelectionTypeMap = new HashMap();
    }

    public static SingleChoicePreference getSingleChoicePreference(Preference preference) {
        String preferenceName = preference.getPreferenceName();
        logger.info((Object)("Getting preference : " + preferenceName));
        SingleChoicePreference preferenceObject = singleSelectionTypeMap.get(preferenceName);
        if (preferenceObject == null) {
            preferenceObject = new SingleChoicePreference(gritsPreferenceStore, preference);
            singleSelectionTypeMap.put(preferenceName, preferenceObject);
        }
        return preferenceObject;
    }

    public static <T> MultiChoicePreference<T> getMultiChoicePreference(ParameterizedPreference parameterizedPreference) {
        String preferenceName = parameterizedPreference.getPreferenceName();
        logger.info((Object)("Getting preference : " + preferenceName));
        MultiChoicePreference<Object> preferenceObject = multiSelectionTypeMap.get(preferenceName);
        if (preferenceObject == null) {
            preferenceObject = new MultiChoicePreference(gritsPreferenceStore, parameterizedPreference);
            multiSelectionTypeMap.put(preferenceName, preferenceObject);
        }
        return preferenceObject;
    }

    public static MultiChoiceInteger getMultiChoiceInteger(IntegerPreference integerPreference) {
        String preferenceName = integerPreference.getPreferenceName();
        logger.info((Object)("Getting preference : " + preferenceName));
        MultiChoiceInteger preferenceObject = (MultiChoiceInteger)multiSelectionTypeMap.get(preferenceName);
        if (preferenceObject == null) {
            preferenceObject = new MultiChoiceInteger(gritsPreferenceStore, integerPreference);
            multiSelectionTypeMap.put(preferenceName, preferenceObject);
        }
        return preferenceObject;
    }

    static /* synthetic */ Logger access$1() {
        return logger;
    }

    public static enum IntegerPreference {
        COLLABORATORS_TABLE(CollaboratorTableColumn.COLUMNS.length, ParameterizedPreference.HIDDEN_ENUM_NOT_TO_BE_USED_COLLABORATOR_TABLE),
        TASKLIST_TABLE(TasklistTableColumn.COLUMNS.length, ParameterizedPreference.HIDDEN_ENUM_NOT_TO_BE_USED_TASKLIST_TABLE);

        private int maxValue;
        ParameterizedPreference parameterizedPreference = null;

        private IntegerPreference(int maxValue, ParameterizedPreference parameterizedPreference) {
            this.maxValue = maxValue;
            this.parameterizedPreference = parameterizedPreference;
        }

        public String getDefaultFileName() {
            return this.parameterizedPreference.getDefaultFileName();
        }

        public String getPreferenceName() {
            return this.parameterizedPreference.getPreferenceName();
        }

        public int getMaxValue() {
            return this.maxValue;
        }
    }

    public static enum ParameterizedPreference {
        COLLABORATOR(ProjectCollaborator.class, null, String.valueOf(CollaboratorPreference.class.getName()) + ".all", CollaboratorPreference.class + ".defaultCollaborators", CollaboratorPreference.class + ".otherCollaborators"),
        EVENT(ProjectEvent.class, null, String.valueOf(EventPreference.class.getName()) + ".all", EventPreference.class + ".defaultEvents", EventPreference.class + ".otherEvents"),
        KEYWORD(String.class, "keyword_preference.xml", String.valueOf(KeywordPreference.class.getName()) + ".all", KeywordPreference.class + ".default", KeywordPreference.class + ".other"),
        TASKLIST(ProjectTasklist.class, null, String.valueOf(TasklistPreference.class.getName()) + ".allTasklists", TasklistPreference.class + ".defaultTasklists", TasklistPreference.class + ".otherTasklists"),
        HIDDEN_ENUM_NOT_TO_BE_USED_COLLABORATOR_TABLE(Integer.class, null, String.valueOf(CollaboratorTablePreference.class.getName()) + ".visible", new String[0]),
        HIDDEN_ENUM_NOT_TO_BE_USED_TASKLIST_TABLE(Integer.class, null, String.valueOf(TasklistTablePreference.class.getName()) + ".visible", new String[0]);

        String defaultFileName = null;
        String preferenceName = null;
        String[] previousNames = new String[0];
        Class<?> unmarshallerClass;

        private <T> ParameterizedPreference(Class<T> unmarshallerClass, String defaultFileName, String preferenceName, String ... previousNames) {
            this.unmarshallerClass = unmarshallerClass;
            this.defaultFileName = defaultFileName;
            this.preferenceName = preferenceName;
            this.previousNames = previousNames;
        }

        public String getDefaultFileName() {
            return this.defaultFileName;
        }

        public String getPreferenceName() {
            return this.preferenceName;
        }

        public String[] getPreviousNames() {
            return this.previousNames;
        }
    }

    public static enum Preference {
        ACTION("action_preference.xml", String.valueOf(ActionPreference.class.getName()) + ".all", ActionPreference.class + ".all"),
        FUNDING("funding_preference.xml", String.valueOf(FundingPreference.class.getName()) + ".all", FundingPreference.class + ".all"),
        PERSON("person_preference.xml", String.valueOf(PersonPreference.class.getName()) + ".all", PersonPreference.class + ".all"),
        POSITION("position_preference.xml", String.valueOf(PositionPreference.class.getName()) + ".all", PositionPreference.class + ".all"),
        ROLE("role_preference.xml", String.valueOf(RolePreference.class.getName()) + ".all", RolePreference.class + ".all"),
        STATUS("status_preference.xml", String.valueOf(StatusPreference.class.getName()) + ".all", StatusPreference.class + ".all"),
        TASK("task_preference.xml", String.valueOf(TasklistPreference.class.getName()) + ".all", TasklistPreference.class + ".all");

        String defaultFileName = null;
        String preferenceName = null;
        String[] previousNames = new String[0];

        private Preference(String defaultFileName, String preferenceName, String ... previousNames) {
            this.defaultFileName = defaultFileName;
            this.preferenceName = preferenceName;
            this.previousNames = previousNames;
        }

        public String getDefaultFileName() {
            return this.defaultFileName;
        }

        public String getPreferenceName() {
            return this.preferenceName;
        }

        public String[] getPreviousNames() {
            return this.previousNames;
        }
    }

    public static enum StringPreference {
        COUNTRY(String.valueOf(CountryPreference.class.getName()) + ".default", CountryPreference.class + ".default");

        String preferenceName = null;
        String value = null;
        String[] previousNames = new String[0];

        private StringPreference(String preferenceName, String ... previousNames) {
            this.preferenceName = preferenceName;
            this.previousNames = previousNames;
            this.loadValue();
        }

        public String getPreferenceName() {
            return this.preferenceName;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean savePreference() {
            PreferenceEntity preferenceEntity = new PreferenceEntity(this.preferenceName);
            preferenceEntity.setValue(this.value);
            return gritsPreferenceStore.savePreference(preferenceEntity);
        }

        /*
         * Unable to fully structure code
         */
        private void loadValue() {
            block6: {
                try {
                    this.value = ProjectPreferenceStore.access$0().getPreferenceEntity(this.preferenceName).getValue();
                }
                catch (UnsupportedVersionException v0) {
                    index = 0;
                    preferenceElement = null;
                    ** while (index < this.previousNames.length)
                }
lbl-1000:
                // 1 sources

                {
                    preferenceElement = ProjectPreferenceStore.access$0().getPreferenceElement(this.previousNames[index]);
                    if (preferenceElement != null) {
                        this.value = preferenceElement.getAttribute("value") == null ? null : preferenceElement.getAttributeValue("value");
                        this.savePreference();
                        ProjectPreferenceStore.access$0().removePreference(this.previousNames[index]);
                    } else {
                        ++index;
                        continue;
                    }
lbl18:
                    // 1 sources

                    break block6;
                }
                catch (Exception e) {
                    ProjectPreferenceStore.access$1().fatal((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

