/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.editor;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.editor.ICancelableEditor;
import org.grits.toolbox.core.editor.IEntryEditorPart;
import org.grits.toolbox.widgets.processDialog.GRITSProgressDialog;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;

public abstract class CancelableMultiPageEditor
implements ICancelableEditor {
    private static final Logger logger = Logger.getLogger(CancelableMultiPageEditor.class);
    protected int iStatus = GRITSProcessStatus.OK;
    protected GRITSProgressDialog dtpdThreadedDialog = null;
    private CTabFolder container;
    protected MPart part;
    private Map<CTabItem, IEntryEditorPart> cTabItemToPartTabMap = new HashMap<CTabItem, IEntryEditorPart>();

    public MPart getPart() {
        return this.part;
    }

    public void setPart(MPart part) {
        this.part = part;
    }

    @PostConstruct
    public void createPartControl(Composite parent, MPart part) {
        this.part = part;
        this.container = this.createContainer(parent, part);
        this.createPages();
        if (this.getActivePage() == -1) {
            this.setActivePage(0);
        }
    }

    public int getActivePage() {
        CTabFolder tabFolder = this.container;
        if (tabFolder != null && !tabFolder.isDisposed()) {
            return tabFolder.getSelectionIndex();
        }
        return -1;
    }

    public void setActivePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        this.container.setSelection(pageIndex);
    }

    private CTabFolder createContainer(Composite parent, final MPart part) {
        parent.setLayout((Layout)new FillLayout());
        final CTabFolder newContainer = new CTabFolder(parent, 0x800400);
        newContainer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.changeTab(e);
            }

            private void changeTab(SelectionEvent e) {
                int selectionIndex = CancelableMultiPageEditor.this.container.getSelectionIndex();
                logger.info((Object)("Tab changed to " + selectionIndex));
                selectionIndex = selectionIndex < 0 ? 0 : selectionIndex;
                IEntryEditorPart currentTab = CancelableMultiPageEditor.this.getcTabItemToPartTabMap().get(CancelableMultiPageEditor.this.container.getSelection());
                part.getContext().set(IEntryEditorPart.class, (Object)currentTab);
                CancelableMultiPageEditor.this.container.getSelection().notifyListeners(13, new Event());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.changeTab(e);
            }
        });
        newContainer.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 256: 
                    case 512: {
                        int detail = e.detail;
                        e.doit = true;
                        e.detail = 0;
                        Composite control = newContainer.getParent();
                        do {
                            if (control.traverse(detail)) {
                                return;
                            }
                            if (control.getListeners(31).length != 0) {
                                return;
                            }
                            if (!(control instanceof Shell)) continue;
                            return;
                        } while ((control = control.getParent()) != null);
                    }
                }
            }
        });
        return newContainer;
    }

    public Map<CTabItem, IEntryEditorPart> getcTabItemToPartTabMap() {
        return this.cTabItemToPartTabMap;
    }

    public int getStatus() {
        return this.iStatus;
    }

    public void setStatus(int _iStatus) {
        this.iStatus = _iStatus;
    }

    public GRITSProgressDialog getThreadedDialog() {
        return this.dtpdThreadedDialog;
    }

    public void setThreadedDialog(GRITSProgressDialog dtpdThreadedDialog) {
        this.dtpdThreadedDialog = dtpdThreadedDialog;
    }

    protected Control getControl(int pageIndex) {
        return this.getItem(pageIndex).getControl();
    }

    private CTabItem getItem(int pageIndex) {
        return this.container.getItem(pageIndex);
    }

    public IEntryEditorPart getPageItem(int pageIndex) {
        CTabItem item = this.container.getItem(pageIndex);
        if (item != null) {
            return this.cTabItemToPartTabMap.get(item);
        }
        return null;
    }

    public int getPageCount() {
        CTabFolder folder = this.container;
        if (folder != null && !folder.isDisposed()) {
            return folder.getItemCount();
        }
        return 0;
    }

    public Composite getContainer() {
        return this.container;
    }

    private CTabItem createItem(int index, Control control) {
        CTabItem item = new CTabItem(this.container, 0, index);
        item.setControl(control);
        return item;
    }

    public int addPage(Control control) {
        int index = this.getPageCount();
        this.addPage(index, control);
        return index;
    }

    public void addPage(int index, Control control) {
        this.createItem(index, control);
    }

    public int addPage(IEntryEditorPart editor, Entry input) throws Exception {
        int index = this.getPageCount();
        this.addPage(index, editor, input);
        return index;
    }

    public void addPage(int index, IEntryEditorPart editor, Entry input) throws Exception {
        editor.setEntry(input);
        Composite parent2 = new Composite(this.getContainer(), 0);
        parent2.setLayout((Layout)new FillLayout());
        editor.createPartControl(parent2);
        CTabItem item = this.createItem(index, (Control)parent2);
        item.setData((Object)editor);
        this.cTabItemToPartTabMap.put(item, editor);
    }

    @Override
    public boolean isCanceled() {
        return this.iStatus == GRITSProcessStatus.CANCEL;
    }

    protected abstract void createPages();

    protected void setPageImage(int pageIndex, Image image) {
        this.getItem(pageIndex).setImage(image);
    }

    protected void setPageText(int pageIndex, String text) {
        this.getItem(pageIndex).setText(text);
    }

    protected void setPartName(String partName) {
        this.part.setLabel(partName);
    }

    protected String getTitle() {
        return this.part.getLabel();
    }

    public void removePage(int pageIndex) {
        if (pageIndex >= 0 && pageIndex < this.getPageCount()) {
            CTabItem item = this.getItem(pageIndex);
            Control pageControl = item.getControl();
            item.dispose();
            if (pageControl != null) {
                pageControl.dispose();
            }
            this.cTabItemToPartTabMap.remove(item);
        }
    }
}

